/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TableSequenceDefinition
extends SequenceDefinition {
    public TableSequenceDefinition(Sequence sequence) {
        super(sequence);
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("INSERT INTO ");
            writer.write(this.getSequenceTableName());
            writer.write("(" + this.getSequenceNameFieldName());
            writer.write(", " + this.getSequenceCounterFieldName());
            writer.write(") values (");
            writer.write("'" + this.getName() + "', " + Integer.toString(this.sequence.getInitialValue() - 1) + ")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DELETE FROM ");
            writer.write(this.getSequenceTableName());
            writer.write(" WHERE " + this.getSequenceNameFieldName());
            writer.write(" = '" + this.getName() + "'");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        Vector results = session.priviledgedExecuteSelectingCall(new SQLCall("SELECT * FROM " + this.getSequenceTableName() + " WHERE " + this.getSequenceNameFieldName() + " = '" + this.getName() + "'"));
        return !results.isEmpty();
    }

    public String getSequenceTableName() {
        return this.getTableSequence().getQualifiedTableName();
    }

    public String getSequenceCounterFieldName() {
        return this.getTableSequence().getCounterFieldName();
    }

    public String getSequenceNameFieldName() {
        return this.getTableSequence().getNameFieldName();
    }

    public TableDefinition buildTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName(this.getSequenceTableName());
        definition.addPrimaryKeyField(this.getSequenceNameFieldName(), String.class, 50);
        definition.addField(this.getSequenceCounterFieldName(), BigDecimal.class);
        return definition;
    }

    protected TableSequence getTableSequence() {
        if (this.sequence instanceof TableSequence) {
            return (TableSequence)this.sequence;
        }
        return (TableSequence)((DefaultSequence)this.sequence).getDefaultSequence();
    }
}

