/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinition
extends DatabaseObjectDefinition {
    protected List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    protected Map<String, ForeignKeyConstraint> foreignKeyMap;
    protected List<UniqueKeyConstraint> uniqueKeys;
    protected List<IndexDefinition> indexes = new ArrayList<IndexDefinition>();
    protected String creationPrefix = "CREATE TABLE ";
    protected String creationSuffix = "";
    private boolean createSQLFiles;
    private boolean createVPDCalls = false;
    private String tenantFieldName;

    public TableDefinition() {
        this.foreignKeyMap = new HashMap<String, ForeignKeyConstraint>();
        this.uniqueKeys = new ArrayList<UniqueKeyConstraint>();
    }

    public void addField(String fieldName, Class type2) {
        this.addField(new FieldDefinition(fieldName, type2));
    }

    public void addField(String fieldName, Class type2, int fieldSize) {
        this.addField(new FieldDefinition(fieldName, type2, fieldSize));
    }

    public void addField(String fieldName, Class type2, int fieldSize, int fieldSubSize) {
        this.addField(new FieldDefinition(fieldName, type2, fieldSize, fieldSubSize));
    }

    public void addField(String fieldName, String typeName) {
        this.addField(new FieldDefinition(fieldName, typeName));
    }

    public void addField(FieldDefinition field) {
        this.getFields().add(field);
    }

    public void addForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        ForeignKeyConstraint foreignKey = new ForeignKeyConstraint(name, sourceField, targetField, targetTable);
        this.addForeignKeyConstraint(foreignKey);
    }

    public void addUniqueKeyConstraint(String name, String sourceField) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceField);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addUniqueKeyConstraint(String name, String[] sourceFields) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceFields);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint foreignKey) {
        if (!this.foreignKeyMap.containsKey(foreignKey.getName())) {
            this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
        }
    }

    public void addUniqueKeyConstraint(UniqueKeyConstraint uniqueKey) {
        this.getUniqueKeys().add(uniqueKey);
    }

    public void addIndex(IndexDefinition index) {
        this.getIndexes().add(index);
    }

    public void addIdentityField(String fieldName, Class type2) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type2);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addIdentityField(String fieldName, Class type2, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type2, fieldSize);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type2) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type2);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type2, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type2, fieldSize);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public Writer buildConstraintCreationWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(foreignKey.getName() + " ");
            }
            foreignKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + foreignKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildConstraintDeletionWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + foreignKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintCreationWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(uniqueKey.getName() + " ");
            }
            uniqueKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + uniqueKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintDeletionWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + uniqueKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public IndexDefinition buildIndex(AbstractSession session, String key, List<String> columnNames, boolean isUniqueSetOnField) {
        String indexName = this.buildIndexName(this.getName(), key, session.getPlatform().getIndexNamePrefix(isUniqueSetOnField), session.getPlatform().getMaxIndexNameSize(), session.getPlatform());
        IndexDefinition index = new IndexDefinition();
        index.setName(indexName);
        index.setTargetTable(this.getFullName());
        index.getFields().addAll(columnNames);
        return index;
    }

    public Writer buildIndexDeletionWriter(AbstractSession session, String key, Writer writer, boolean isUniqueSetOnField) {
        String indexName = this.buildIndexName(this.getName(), key, session.getPlatform().getIndexNamePrefix(isUniqueSetOnField), session.getPlatform().getMaxIndexNameSize(), session.getPlatform());
        IndexDefinition index = new IndexDefinition();
        index.setName(indexName);
        index.setTargetTable(this.getFullName());
        index.buildDeletionWriter(session, writer);
        return writer;
    }

    public String getCreationPrefix() {
        return this.creationPrefix;
    }

    public void setCreationPrefix(String creationPrefix) {
        this.creationPrefix = creationPrefix;
    }

    public String getCreationSuffix() {
        return this.creationSuffix;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.creationSuffix = creationSuffix;
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write(this.getCreationPrefix() + this.getFullName() + " (");
            Iterator<FieldDefinition> itetrator = this.getFields().iterator();
            while (itetrator.hasNext()) {
                FieldDefinition field = itetrator.next();
                field.appendDBString(writer, session, this);
                if (!itetrator.hasNext()) continue;
                writer.write(", ");
            }
            List<String> keyFields = this.getPrimaryKeyFieldNames();
            if (!keyFields.isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(", ");
                if (session.getPlatform().requiresNamedPrimaryKeyConstraints()) {
                    writer.write("CONSTRAINT " + this.getFullName() + "_PK ");
                }
                writer.write("PRIMARY KEY (");
                Iterator<String> iterator = keyFields.iterator();
                while (iterator.hasNext()) {
                    writer.write(iterator.next());
                    if (!iterator.hasNext()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            if (session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
                for (UniqueKeyConstraint constraint : this.getUniqueKeys()) {
                    writer.write(", ");
                    constraint.appendDBString(writer, session);
                }
            }
            writer.write(")");
            session.getPlatform().writeTableCreationSuffix(writer, this.getCreationSuffix());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TABLE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildVPDCreationPolicyWriter(AbstractSession session, Writer writer) {
        try {
            writer.write(session.getPlatform().getVPDCreationPolicyString(this.getName(), session));
            return writer;
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public Writer buildVPDCreationFunctionWriter(AbstractSession session, Writer writer) {
        try {
            writer.write(session.getPlatform().getVPDCreationFunctionString(this.getName(), this.tenantFieldName));
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildVPDDeletionWriter(AbstractSession session, Writer writer) {
        try {
            writer.write(session.getPlatform().getVPDDeletionString(this.getName(), session));
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    protected void buildFieldTypes(AbstractSession session) {
        for (FieldDefinition field : this.getFields()) {
            if (field.getForeignKeyFieldName() == null) continue;
            this.addForeignKeyConstraint(this.buildForeignKeyConstraint(field, session.getPlatform()));
        }
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition field, DatabasePlatform platform) {
        Vector<String> sourceFields = new Vector<String>();
        Vector<String> targetFields = new Vector<String>();
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        DatabaseField tempTargetField = new DatabaseField(field.getForeignKeyFieldName());
        DatabaseField tempSourceField = new DatabaseField(field.getName());
        sourceFields.add(tempSourceField.getName());
        targetFields.add(tempTargetField.getName());
        fkConstraint.setSourceFields(sourceFields);
        fkConstraint.setTargetFields(targetFields);
        fkConstraint.setTargetTable(tempTargetField.getTable().getQualifiedNameDelimited(platform));
        String tempName = this.buildForeignKeyConstraintName(this.getName(), tempSourceField.getName(), platform.getMaxForeignKeyNameSize(), platform);
        fkConstraint.setName(tempName);
        return fkConstraint;
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(List<String> fkFieldNames, List<String> pkFieldNames, TableDefinition targetTable, DatabasePlatform platform) {
        assert (fkFieldNames.size() > 0 && fkFieldNames.size() == pkFieldNames.size());
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        for (int i = 0; i < fkFieldNames.size(); ++i) {
            fkConstraint.getSourceFields().add(fkFieldNames.get(i));
            fkConstraint.getTargetFields().add(pkFieldNames.get(i));
        }
        fkConstraint.setTargetTable(targetTable.getFullName());
        String fkFieldName = fkFieldNames.get(0);
        String name = this.buildForeignKeyConstraintName(this.getName(), fkFieldName, platform.getMaxForeignKeyNameSize(), platform);
        fkConstraint.setName(name);
        return fkConstraint;
    }

    protected String buildForeignKeyConstraintName(String tableName, String fieldName, int maximumNameLength, DatabasePlatform platform) {
        char c;
        int i;
        StringBuffer buff;
        String adjustedTableName;
        boolean useDelimiters;
        String startDelimiter = "";
        String endDelimiter = "";
        boolean bl = useDelimiters = !platform.getStartDelimiter().equals("") && (tableName.startsWith(platform.getStartDelimiter()) || fieldName.startsWith(platform.getStartDelimiter()));
        if (useDelimiters) {
            startDelimiter = platform.getStartDelimiter();
            endDelimiter = platform.getEndDelimiter();
        }
        if ((adjustedTableName = tableName).indexOf(32) != -1 || adjustedTableName.indexOf(34) != -1 || adjustedTableName.indexOf(96) != -1) {
            buff = new StringBuffer();
            for (i = 0; i < tableName.length(); ++i) {
                c = tableName.charAt(i);
                if (c == ' ' || c == '\"' || c == '`') continue;
                buff.append(c);
            }
            adjustedTableName = buff.toString();
        }
        buff = new StringBuffer();
        for (i = 0; i < fieldName.length(); ++i) {
            c = fieldName.charAt(i);
            if (c == ' ' || c == '\"' || c == '`') continue;
            buff.append(c);
        }
        String adjustedFieldName = buff.toString();
        String foreignKeyName = startDelimiter + "FK_" + adjustedTableName + "_" + adjustedFieldName + endDelimiter;
        if (foreignKeyName.length() > maximumNameLength && (foreignKeyName = startDelimiter + adjustedTableName + "_" + adjustedFieldName + endDelimiter).length() > maximumNameLength && (foreignKeyName = startDelimiter + Helper.removeAllButAlphaNumericToFit(adjustedTableName + adjustedFieldName, maximumNameLength) + endDelimiter).length() > maximumNameLength) {
            String onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(adjustedTableName, 0);
            String onlyAlphaNumericFieldName = Helper.removeAllButAlphaNumericToFit(adjustedFieldName, 0);
            foreignKeyName = startDelimiter + Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName, onlyAlphaNumericFieldName, maximumNameLength) + endDelimiter;
            if (foreignKeyName.length() > maximumNameLength) {
                String shortenedFieldName = Helper.removeVowels(onlyAlphaNumericFieldName);
                String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
                int delimiterLength = startDelimiter.length() + endDelimiter.length();
                foreignKeyName = shortenedFieldName.length() + delimiterLength >= maximumNameLength ? startDelimiter + Helper.truncate(shortenedFieldName, maximumNameLength - delimiterLength) + endDelimiter : startDelimiter + Helper.truncate(shortenedTableName, maximumNameLength - shortenedFieldName.length() - delimiterLength) + shortenedFieldName + endDelimiter;
            }
        }
        return foreignKeyName;
    }

    protected UniqueKeyConstraint buildUniqueKeyConstraint(String name, List<String> fieldNames, int serialNumber, DatabasePlatform platform) {
        assert (fieldNames.size() > 0);
        UniqueKeyConstraint unqConstraint = new UniqueKeyConstraint();
        for (String fieldName : fieldNames) {
            unqConstraint.addSourceField(fieldName);
        }
        if (name == null || name.equals("")) {
            unqConstraint.setName(this.buildUniqueKeyConstraintName(this.getName(), serialNumber, platform.getMaxUniqueKeyNameSize()));
        } else if (name.length() > platform.getMaxUniqueKeyNameSize()) {
            unqConstraint.setName(name.substring(0, platform.getMaxUniqueKeyNameSize() - 1));
        } else {
            unqConstraint.setName(name);
        }
        return unqConstraint;
    }

    protected String buildUniqueKeyConstraintName(String tableName, int serialNumber, int maximumNameLength) {
        String serialName;
        String onlyAlphaNumericTableName;
        String uniqueKeyName = "UNQ_" + tableName + "_" + serialNumber;
        if (uniqueKeyName.length() > maximumNameLength && (uniqueKeyName = tableName + serialNumber).length() > maximumNameLength && (uniqueKeyName = Helper.removeAllButAlphaNumericToFit(tableName + serialNumber, maximumNameLength)).length() > maximumNameLength && (uniqueKeyName = Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(tableName, 0), serialName = String.valueOf(serialNumber), maximumNameLength)).length() > maximumNameLength) {
            String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
            uniqueKeyName = Helper.truncate(shortenedTableName, maximumNameLength - serialName.length()) + serialName;
        }
        return uniqueKeyName;
    }

    protected String buildIndexName(String tableName, String key, String indexPrefix, int maximumNameLength, DatabasePlatform platform) {
        String indexName;
        char c;
        int i;
        StringBuffer buff;
        String adjustedTableName;
        boolean useDelimiters;
        String startDelimiter = "";
        String endDelimiter = "";
        boolean bl = useDelimiters = !platform.getStartDelimiter().equals("") && (tableName.startsWith(platform.getStartDelimiter()) || key.startsWith(platform.getStartDelimiter()));
        if (useDelimiters) {
            startDelimiter = platform.getStartDelimiter();
            endDelimiter = platform.getEndDelimiter();
        }
        if ((adjustedTableName = tableName).indexOf(32) != -1 || adjustedTableName.indexOf(34) != -1 || adjustedTableName.indexOf(96) != -1) {
            buff = new StringBuffer();
            for (i = 0; i < tableName.length(); ++i) {
                c = tableName.charAt(i);
                if (c == ' ' || c == '\"' || c == '`') continue;
                buff.append(c);
            }
            adjustedTableName = buff.toString();
        }
        buff = new StringBuffer();
        for (i = 0; i < key.length(); ++i) {
            c = key.charAt(i);
            if (c == ' ' || c == '\"' || c == '`') continue;
            buff.append(c);
        }
        String adjustedFieldName = buff.toString();
        if (indexPrefix == null) {
            indexPrefix = "IX_";
        }
        if ((indexName = startDelimiter + indexPrefix + adjustedTableName + "_" + adjustedFieldName + endDelimiter).length() > maximumNameLength && (indexName = startDelimiter + adjustedTableName + "_" + adjustedFieldName + endDelimiter).length() > maximumNameLength && (indexName = startDelimiter + Helper.removeAllButAlphaNumericToFit(adjustedTableName + adjustedFieldName, maximumNameLength) + endDelimiter).length() > maximumNameLength) {
            String onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(adjustedTableName, 0);
            String onlyAlphaNumericFieldName = Helper.removeAllButAlphaNumericToFit(adjustedFieldName, 0);
            indexName = startDelimiter + Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName, onlyAlphaNumericFieldName, maximumNameLength) + endDelimiter;
            if (indexName.length() > maximumNameLength) {
                String shortenedFieldName = Helper.removeVowels(onlyAlphaNumericFieldName);
                String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
                int delimiterLength = startDelimiter.length() + endDelimiter.length();
                indexName = shortenedFieldName.length() + delimiterLength >= maximumNameLength ? startDelimiter + Helper.truncate(shortenedFieldName, maximumNameLength - delimiterLength) + endDelimiter : startDelimiter + Helper.truncate(shortenedTableName, maximumNameLength - shortenedFieldName.length() - delimiterLength) + shortenedFieldName + endDelimiter;
            }
        }
        return indexName;
    }

    @Override
    public Object clone() {
        TableDefinition clone = (TableDefinition)super.clone();
        if (this.fields != null) {
            clone.setFields(new ArrayList<FieldDefinition>(this.fields.size()));
            for (FieldDefinition fieldDef : this.getFields()) {
                clone.addField((FieldDefinition)fieldDef.clone());
            }
        }
        if (this.foreignKeyMap != null) {
            clone.setForeignKeyMap(new HashMap<String, ForeignKeyConstraint>(this.foreignKeyMap));
        }
        if (this.uniqueKeys != null) {
            clone.setUniqueKeys(new ArrayList<UniqueKeyConstraint>(this.uniqueKeys));
        }
        return clone;
    }

    public void createConstraints(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        this.createUniqueConstraints(session, schemaWriter);
        this.createForeignConstraints(session, schemaWriter);
    }

    void createUniqueConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createUniqueConstraintsOnDatabase(session);
            return;
        }
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty() || session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
            return;
        }
        for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
            this.buildUniqueConstraintCreationWriter(session, uniqueKey, schemaWriter).toString();
            this.writeLineSeperator(session, schemaWriter);
        }
    }

    void createForeignConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createForeignConstraintsOnDatabase(session);
            return;
        }
        if (session.getPlatform().supportsForeignKeyConstraints()) {
            for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
                this.buildConstraintCreationWriter(session, foreignKey, schemaWriter).toString();
                this.writeLineSeperator(session, schemaWriter);
            }
        }
    }

    public void createConstraintsOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.createUniqueConstraintsOnDatabase(session);
        this.createForeignConstraintsOnDatabase(session);
    }

    void createUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty() || session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
            return;
        }
        for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildUniqueConstraintCreationWriter(session, uniqueKey, new StringWriter()).toString()));
        }
    }

    void createForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildConstraintCreationWriter(session, foreignKey, new StringWriter()).toString()));
        }
    }

    public void createIndexes(AbstractSession session, Writer writer) {
        List<String> primKeyList;
        if (!session.getPlatform().supportsIndexes()) {
            return;
        }
        if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() && !(primKeyList = this.getPrimaryKeyFieldNames()).isEmpty()) {
            IndexDefinition index = this.buildIndex(session, primKeyList.get(0), primKeyList, false);
            if (writer == null) {
                index.createOnDatabase(session);
            } else {
                index.buildCreationWriter(session, writer);
                this.writeLineSeperator(session, writer);
            }
        }
        if (session.getPlatform().shouldCreateIndicesOnUniqueKeys()) {
            for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
                IndexDefinition index = this.buildIndex(session, uniqueKey.getName(), uniqueKey.getSourceFields(), false);
                if (writer == null) {
                    index.createOnDatabase(session);
                    continue;
                }
                index.buildCreationWriter(session, writer);
                this.writeLineSeperator(session, writer);
            }
            for (FieldDefinition field : this.getFields()) {
                if (!field.isUnique()) continue;
                ArrayList<String> columnAsList = new ArrayList<String>();
                columnAsList.add(field.getName());
                IndexDefinition index = this.buildIndex(session, field.getName(), columnAsList, true);
                if (writer == null) {
                    index.createOnDatabase(session);
                    continue;
                }
                index.buildCreationWriter(session, writer);
                this.writeLineSeperator(session, writer);
            }
        }
        for (IndexDefinition index : this.getIndexes()) {
            if (writer == null) {
                index.createOnDatabase(session);
                continue;
            }
            index.buildCreationWriter(session, writer);
            this.writeLineSeperator(session, writer);
        }
    }

    public void writeLineSeperator(AbstractSession session, Writer writer) {
        try {
            if (this.createSQLFiles) {
                writer.write(session.getPlatform().getStoredProcedureTerminationToken());
            }
            writer.write("\n");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public String deletionStringFor(DatabaseAccessor accessor) {
        return "DROP TABLE " + this.getName();
    }

    public void dropConstraints(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropConstraintsOnDatabase(session);
        } else {
            if (session.getPlatform().supportsForeignKeyConstraints()) {
                for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
                    this.buildConstraintDeletionWriter(session, foreignKey, schemaWriter);
                    this.writeLineSeperator(session, schemaWriter);
                }
            }
            if (session.getPlatform().supportsUniqueKeyConstraints() && !session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
                for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
                    this.buildUniqueConstraintDeletionWriter(session, uniqueKey, schemaWriter);
                    this.writeLineSeperator(session, schemaWriter);
                }
            }
        }
    }

    public void dropConstraintsOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.dropForeignConstraintsOnDatabase(session);
        this.dropUniqueConstraintsOnDatabase(session);
    }

    private void dropUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty() || session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
            return;
        }
        for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
            try {
                session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildUniqueConstraintDeletionWriter(session, uniqueKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    private void dropForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            try {
                session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildConstraintDeletionWriter(session, foreignKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    public void dropIndexes(AbstractSession session, Writer writer) {
        List<String> primKeyList;
        if (!session.getPlatform().supportsIndexes()) {
            return;
        }
        if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() && !(primKeyList = this.getPrimaryKeyFieldNames()).isEmpty()) {
            IndexDefinition index = this.buildIndex(session, primKeyList.get(0), primKeyList, false);
            if (writer == null) {
                try {
                    index.dropFromDatabase(session);
                }
                catch (Exception notThere) {}
            } else {
                index.buildDeletionWriter(session, writer);
                this.writeLineSeperator(session, writer);
            }
        }
        if (session.getPlatform().shouldCreateIndicesOnUniqueKeys()) {
            for (UniqueKeyConstraint uniqueKey : this.getUniqueKeys()) {
                IndexDefinition index = this.buildIndex(session, uniqueKey.getName(), uniqueKey.getSourceFields(), false);
                if (writer == null) {
                    try {
                        index.dropFromDatabase(session);
                    }
                    catch (Exception notThere) {}
                    continue;
                }
                index.buildDeletionWriter(session, writer);
                this.writeLineSeperator(session, writer);
            }
            for (FieldDefinition field : this.getFields()) {
                if (!field.isUnique()) continue;
                ArrayList<String> columnAsList = new ArrayList<String>();
                columnAsList.add(field.getName());
                IndexDefinition index = this.buildIndex(session, field.getName(), columnAsList, true);
                if (writer == null) {
                    try {
                        index.dropFromDatabase(session);
                    }
                    catch (Exception notThere) {}
                    continue;
                }
                index.buildDeletionWriter(session, writer);
                this.writeLineSeperator(session, writer);
            }
        }
        for (IndexDefinition index : this.getIndexes()) {
            if (writer == null) {
                try {
                    index.dropFromDatabase(session);
                }
                catch (Exception notThere) {}
                continue;
            }
            index.buildDeletionWriter(session, writer);
            this.writeLineSeperator(session, writer);
        }
    }

    public Map<String, ForeignKeyConstraint> getForeignKeyMap() {
        return this.foreignKeyMap;
    }

    public void setForeignKeyMap(Map<String, ForeignKeyConstraint> foreignKeyMap) {
        this.foreignKeyMap = foreignKeyMap;
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public Collection<ForeignKeyConstraint> getForeignKeys() {
        return this.foreignKeyMap.values();
    }

    public List<UniqueKeyConstraint> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setIndexes(List<IndexDefinition> indexes) {
        this.indexes = indexes;
    }

    public void setCreateVPDCalls(boolean createVPDCalls, String tenantFieldName) {
        this.createVPDCalls = createVPDCalls;
        this.tenantFieldName = tenantFieldName;
    }

    public List<IndexDefinition> getIndexes() {
        return this.indexes;
    }

    public List<String> getPrimaryKeyFieldNames() {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (FieldDefinition field : this.getFields()) {
            if (!field.isPrimaryKey()) continue;
            keyNames.add(field.getName());
        }
        return keyNames;
    }

    @Override
    public void postCreateObject(AbstractSession session, Writer createSchemaWriter, boolean createSQLFiles) {
        this.setCreateSQLFiles(createSQLFiles);
        this.createIndexes(session, createSchemaWriter);
    }

    @Override
    public void preDropObject(AbstractSession session, Writer dropSchemaWriter, boolean createSQLFiles) {
        this.setCreateSQLFiles(createSQLFiles);
        this.dropIndexes(session, dropSchemaWriter);
    }

    public void setFields(List<FieldDefinition> fields) {
        this.fields = fields;
    }

    public void setForeignKeys(List<ForeignKeyConstraint> foreignKeys) {
        this.foreignKeyMap.clear();
        if (foreignKeys != null) {
            for (ForeignKeyConstraint foreignKey : foreignKeys) {
                this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
            }
        }
    }

    public void setUniqueKeys(List<UniqueKeyConstraint> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    @Override
    public boolean shouldCreateVPDCalls(AbstractSession session) {
        if (this.createVPDCalls && !session.getPlatform().supportsVPD()) {
            throw ValidationException.vpdNotSupported(session.getPlatform().getClass().getName());
        }
        return this.createVPDCalls;
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }
}

