/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchGroup
extends AttributeGroup {
    private boolean shouldLoad;

    public FetchGroup() {
    }

    public FetchGroup(String name) {
        super(name);
    }

    @Deprecated
    public Set<String> getAttributes() {
        return this.getAttributeNames();
    }

    public String onUnfetchedAttribute(FetchGroupTracker entity, String attributeName) {
        Object result;
        ReadObjectQuery query = new ReadObjectQuery(entity);
        query.setShouldUseDefaultFetchGroup(false);
        Session session = entity._persistence_getSession();
        boolean shouldLoadResultIntoSelectionObject = false;
        if (session.isUnitOfWork()) {
            shouldLoadResultIntoSelectionObject = !((UnitOfWork)session).isObjectRegistered(entity);
        } else {
            boolean bl = shouldLoadResultIntoSelectionObject = !session.getIdentityMapAccessor().containsObjectInIdentityMap(entity);
        }
        if (shouldLoadResultIntoSelectionObject) {
            query.setShouldLoadResultIntoSelectionObject(true);
            query.dontCheckCache();
            query.setShouldMaintainCache(false);
            entity._persistence_setFetchGroup(null);
            entity._persistence_setSession(null);
        }
        if ((result = session.executeQuery(query)) == null) {
            if (shouldLoadResultIntoSelectionObject) {
                entity._persistence_setFetchGroup(this);
                entity._persistence_setSession(session);
            }
            Object[] args = new Object[]{query.getSelectionId()};
            return ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_reference", args);
        }
        return null;
    }

    public String onUnfetchedAttributeForSet(FetchGroupTracker entity, String attributeName) {
        return this.onUnfetchedAttribute(entity, attributeName);
    }

    public void setShouldLoad(boolean shouldLoad) {
        this.shouldLoad = shouldLoad;
    }

    public void setShouldLoadAll(boolean shouldLoad) {
        this.shouldLoad = shouldLoad;
        if (this.hasItems()) {
            for (Map.Entry<String, AttributeItem> entry : this.getItems().entrySet()) {
                FetchGroup group2 = (FetchGroup)entry.getValue().getGroup();
                if (group2 == null) continue;
                group2.setShouldLoadAll(shouldLoad);
            }
        }
    }

    public boolean shouldLoad() {
        return this.shouldLoad;
    }

    @Override
    protected FetchGroup newGroup(String name, AttributeGroup parent) {
        FetchGroup fetchGroup = new FetchGroup(name);
        if (parent != null) {
            fetchGroup.setShouldLoad(((FetchGroup)parent).shouldLoad());
        }
        return fetchGroup;
    }

    @Override
    public boolean isFetchGroup() {
        return true;
    }

    public boolean isEntityFetchGroup() {
        return false;
    }

    public LoadGroup toLoadGroupLoadOnly() {
        if (!this.shouldLoad) {
            return null;
        }
        LoadGroup loadGroup = new LoadGroup(this.getName());
        if (this.hasItems()) {
            for (Map.Entry<String, AttributeItem> entry : this.getItems().entrySet()) {
                FetchGroup group2 = (FetchGroup)entry.getValue().getGroup();
                if (group2 != null) {
                    loadGroup.addAttribute(entry.getKey(), group2.toLoadGroupLoadOnly());
                    continue;
                }
                loadGroup.addAttribute(entry.getKey());
            }
        }
        if (!loadGroup.getItems().isEmpty()) {
            return loadGroup;
        }
        return null;
    }

    @Override
    public FetchGroup clone() {
        return (FetchGroup)super.clone();
    }

    @Override
    public FetchGroup getGroup(String attributeNameOrPath) {
        return (FetchGroup)super.getGroup(attributeNameOrPath);
    }

    @Override
    public void addAttribute(String attributeNameOrPath, AttributeGroup group2) {
        super.addAttribute(attributeNameOrPath, group2 != null ? group2.toFetchGroup() : null);
    }

    public void addAttribute(String attributeNameOrPath, FetchGroup group2) {
        super.addAttribute(attributeNameOrPath, group2);
    }
}

