/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingMarshalRecord
extends MarshalRecord {
    private MarshalRecord marshalRecord;
    private ContentHandlerRecord validatingRecord;

    public ValidatingMarshalRecord(MarshalRecord marshalRecord, XMLMarshaller xmlMarshaller) {
        this.marshalRecord = marshalRecord;
        Schema schema = xmlMarshaller.getSchema();
        ValidatorHandler validatorHandler = schema.newValidatorHandler();
        validatorHandler.setErrorHandler(new ValidatingMarshalRecordErrorHandler(marshalRecord, xmlMarshaller.getErrorHandler()));
        this.validatingRecord = new ContentHandlerRecord();
        this.validatingRecord.setMarshaller(xmlMarshaller);
        this.validatingRecord.setContentHandler(validatorHandler);
    }

    public void startDocument(String encoding, String version) {
        this.validatingRecord.startDocument(encoding, version);
        this.marshalRecord.startDocument(encoding, version);
    }

    public void endDocument() {
        this.validatingRecord.endDocument();
        this.marshalRecord.endDocument();
    }

    public void element(XPathFragment frag) {
        this.validatingRecord.element(frag);
        this.marshalRecord.element(frag);
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.validatingRecord.attribute(xPathFragment, namespaceResolver, value);
        this.marshalRecord.attribute(xPathFragment, namespaceResolver, value);
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        this.validatingRecord.attribute(namespaceURI, localName, qName, value);
        this.marshalRecord.attribute(namespaceURI, localName, qName, value);
    }

    public void closeStartElement() {
        this.validatingRecord.closeStartElement();
        this.marshalRecord.closeStartElement();
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.endElement(xPathFragment, namespaceResolver);
        this.marshalRecord.endElement(xPathFragment, namespaceResolver);
    }

    public HashMap getPositionalNodes() {
        return this.marshalRecord.getPositionalNodes();
    }

    public void addGroupingElement(XPathNode xPathNode) {
        this.validatingRecord.addGroupingElement(xPathNode);
        this.marshalRecord.addGroupingElement(xPathNode);
    }

    public void removeGroupingElement(XPathNode xPathNode) {
        this.validatingRecord.removeGroupingElement(xPathNode);
        this.marshalRecord.removeGroupingElement(xPathNode);
    }

    public void add(DatabaseField key, Object value) {
        this.validatingRecord.add(key, value);
        this.marshalRecord.add(key, value);
    }

    public Object put(DatabaseField key, Object value) {
        this.validatingRecord.put(key, value);
        return this.marshalRecord.put(key, value);
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        this.validatingRecord.namespaceDeclarations(namespaceResolver);
        this.marshalRecord.namespaceDeclarations(namespaceResolver);
    }

    public void startPrefixMapping(String prefix, String namespaceURI) {
        this.validatingRecord.startPrefixMapping(prefix, namespaceURI);
        this.marshalRecord.startPrefixMapping(prefix, namespaceURI);
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        this.validatingRecord.startPrefixMappings(namespaceResolver);
        this.marshalRecord.startPrefixMappings(namespaceResolver);
    }

    public void endPrefixMapping(String prefix) {
        this.validatingRecord.endPrefixMapping(prefix);
        this.marshalRecord.endPrefixMapping(prefix);
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
        this.validatingRecord.endPrefixMappings(namespaceResolver);
        this.marshalRecord.endPrefixMappings(namespaceResolver);
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.openStartElement(xPathFragment, namespaceResolver);
        this.marshalRecord.openStartElement(xPathFragment, namespaceResolver);
    }

    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        this.validatingRecord.openStartGroupingElements(namespaceResolver);
        return this.marshalRecord.openStartGroupingElements(namespaceResolver);
    }

    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        this.validatingRecord.closeStartGroupingElements(groupingFragment);
        this.marshalRecord.closeStartGroupingElements(groupingFragment);
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.addPositionalNodes(xPathFragment, namespaceResolver);
        this.marshalRecord.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public void characters(String value) {
        this.validatingRecord.characters(value);
        this.marshalRecord.characters(value);
    }

    public void cdata(String value) {
        this.validatingRecord.cdata(value);
        this.marshalRecord.cdata(value);
    }

    public void node(Node node, NamespaceResolver resolver) {
        this.validatingRecord.node(node, resolver);
        this.marshalRecord.node(node, resolver);
    }

    public String getLocalName() {
        return this.marshalRecord.getLocalName();
    }

    public String getNamespaceURI() {
        return this.marshalRecord.getNamespaceURI();
    }

    public void clear() {
        this.validatingRecord.clear();
        this.marshalRecord.clear();
    }

    public Document getDocument() {
        return this.marshalRecord.getDocument();
    }

    public Element getDOM() {
        return this.marshalRecord.getDOM();
    }

    public String transformToXML() {
        return this.marshalRecord.transformToXML();
    }

    public boolean contains(Object value) {
        return this.marshalRecord.contains(value);
    }

    public Object get(DatabaseField key) {
        return this.marshalRecord.get(key);
    }

    public Object getIndicatingNoEntry(String fieldName) {
        return this.marshalRecord.getIndicatingNoEntry(fieldName);
    }

    public String resolveNamespacePrefix(String prefix) {
        return this.marshalRecord.resolveNamespacePrefix(prefix);
    }

    public XMLMarshaller getMarshaller() {
        return this.marshalRecord.getMarshaller();
    }

    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        this.validatingRecord.setMarshaller(marshaller);
        this.marshalRecord.setMarshaller(marshaller);
    }

    public XMLUnmarshaller getUnmarshaller() {
        return this.marshalRecord.getUnmarshaller();
    }

    public void setUnmarshaller(XMLUnmarshaller unmarshaller) {
        this.validatingRecord.setUnmarshaller(unmarshaller);
        this.marshalRecord.setUnmarshaller(unmarshaller);
    }

    public void setDocPresPolicy(DocumentPreservationPolicy policy) {
        this.validatingRecord.setDocPresPolicy(policy);
        this.marshalRecord.setDocPresPolicy(policy);
    }

    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.marshalRecord.getDocPresPolicy();
    }

    public Object getOwningObject() {
        return this.marshalRecord.getOwningObject();
    }

    public void setOwningObject(Object obj) {
        this.validatingRecord.setOwningObject(obj);
        this.marshalRecord.setOwningObject(obj);
    }

    public Object getCurrentObject() {
        return this.marshalRecord.getCurrentObject();
    }

    public void setCurrentObject(Object obj) {
        this.marshalRecord.setCurrentObject(obj);
        this.validatingRecord.setCurrentObject(obj);
    }

    public QName getLeafElementType() {
        return this.marshalRecord.getLeafElementType();
    }

    public void setLeafElementType(QName type2) {
        this.validatingRecord.setLeafElementType(type2);
        this.marshalRecord.setLeafElementType(type2);
    }

    public void setNamespaceResolver(NamespaceResolver nr) {
        this.validatingRecord.setNamespaceResolver(nr);
        this.marshalRecord.setNamespaceResolver(nr);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.marshalRecord.getNamespaceResolver();
    }

    public AbstractSession getSession() {
        return this.marshalRecord.getSession();
    }

    public void setSession(AbstractSession session) {
        this.session = session;
        this.validatingRecord.setSession(session);
        this.marshalRecord.setSession(session);
    }

    public boolean isXOPPackage() {
        return this.marshalRecord.isXOPPackage();
    }

    public void setXOPPackage(boolean isXOPPackage) {
        this.validatingRecord.setXOPPackage(isXOPPackage);
        this.marshalRecord.setXOPPackage(isXOPPackage);
    }

    public boolean containsKey(Object key) {
        return this.marshalRecord.containsKey(key);
    }

    public boolean containsKey(String fieldName) {
        return this.marshalRecord.containsKey(fieldName);
    }

    public boolean containsKey(DatabaseField key) {
        return this.marshalRecord.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.marshalRecord.containsValue(value);
    }

    public Enumeration elements() {
        return this.marshalRecord.elements();
    }

    public Set entrySet() {
        return this.marshalRecord.entrySet();
    }

    public Object get(Object key) {
        return this.marshalRecord.get(key);
    }

    public Object get(String fieldName) {
        return this.marshalRecord.get(fieldName);
    }

    public Object getValues(DatabaseField key) {
        return this.marshalRecord.getValues(key);
    }

    public Object getValues(String key) {
        return this.marshalRecord.getValues(key);
    }

    public Object getIndicatingNoEntry(DatabaseField key) {
        return this.marshalRecord.getIndicatingNoEntry(key);
    }

    public DatabaseField getField(DatabaseField key) {
        return this.marshalRecord.getField(key);
    }

    public Vector getFields() {
        return this.marshalRecord.getFields();
    }

    public Vector getValues() {
        return this.marshalRecord.getValues();
    }

    public boolean isEmpty() {
        return this.marshalRecord.isEmpty();
    }

    public boolean hasNullValueInFields() {
        return this.marshalRecord.hasNullValueInFields();
    }

    public Enumeration keys() {
        return this.marshalRecord.keys();
    }

    public Set keySet() {
        return this.marshalRecord.keySet();
    }

    public void mergeFrom(AbstractRecord row) {
        this.validatingRecord.mergeFrom(row);
        this.marshalRecord.mergeFrom(row);
    }

    public Object put(Object key, Object value) throws ValidationException {
        this.validatingRecord.put(key, value);
        return this.marshalRecord.put(key, value);
    }

    public Object put(String key, Object value) {
        this.validatingRecord.put(key, value);
        return this.marshalRecord.put(key, value);
    }

    public void putAll(Map map) {
        this.validatingRecord.putAll(map);
        this.marshalRecord.putAll(map);
    }

    public Object remove(Object key) {
        this.validatingRecord.remove(key);
        return this.marshalRecord.remove(key);
    }

    public Object remove(String fieldName) {
        this.validatingRecord.remove(fieldName);
        return this.marshalRecord.remove(fieldName);
    }

    public Object remove(DatabaseField key) {
        this.validatingRecord.remove(key);
        return this.marshalRecord.remove(key);
    }

    public void replaceAt(Object value, int index) {
        this.validatingRecord.replaceAt(value, index);
        this.marshalRecord.replaceAt(value, index);
    }

    public void setNullValueInFields(boolean nullValueInFields) {
        this.validatingRecord.setNullValueInFields(nullValueInFields);
        this.marshalRecord.setNullValueInFields(nullValueInFields);
    }

    public int size() {
        return this.marshalRecord.size();
    }

    public Collection values() {
        return this.marshalRecord.values();
    }

    public void beforeContainmentMarshal(Object child) {
        this.marshalRecord.beforeContainmentMarshal(child);
    }

    public void afterContainmentMarshal(Object parent, Object child) {
        this.marshalRecord.afterContainmentMarshal(parent, child);
    }

    public static class MarshalSAXParseException
    extends SAXParseException {
        private Object object;

        public MarshalSAXParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber, Exception e, Object object) {
            super(message, publicId, systemId, lineNumber, columnNumber, e);
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    private static class ValidatingMarshalRecordErrorHandler
    implements ErrorHandler {
        private MarshalRecord marshalRecord;
        private ErrorHandler errorHandler;

        public ValidatingMarshalRecordErrorHandler(MarshalRecord marshalRecord, ErrorHandler errorHandler) {
            this.marshalRecord = marshalRecord;
            this.errorHandler = errorHandler;
        }

        public void warning(SAXParseException exception) throws SAXException {
            if (null == this.errorHandler) {
                throw exception;
            }
            this.errorHandler.warning(this.marshalSAXParseException(exception));
        }

        public void error(SAXParseException exception) throws SAXException {
            if (null == this.errorHandler) {
                throw exception;
            }
            this.errorHandler.error(this.marshalSAXParseException(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            if (null == this.errorHandler) {
                throw exception;
            }
            this.errorHandler.fatalError(this.marshalSAXParseException(exception));
        }

        private MarshalSAXParseException marshalSAXParseException(SAXParseException exception) {
            return new MarshalSAXParseException(exception.getLocalizedMessage(), exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getException(), this.marshalRecord.getOwningObject());
        }
    }
}

