/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;

public class XMLCompositeDirectCollectionMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private static final String SPACE = " ";
    private XMLCompositeDirectCollectionMapping xmlCompositeDirectCollectionMapping;
    private int index = -1;

    public XMLCompositeDirectCollectionMappingNodeValue(XMLCompositeDirectCollectionMapping xmlCompositeDirectCollectionMapping) {
        this.xmlCompositeDirectCollectionMapping = xmlCompositeDirectCollectionMapping;
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        if (this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            return xPathFragment.nameIsText() || xPathFragment.isAttribute();
        }
        XPathFragment nextFragment = xPathFragment.getNextFragment();
        return nextFragment != null && (nextFragment.nameIsText() || nextFragment.isAttribute());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object objectValue;
        if (this.xmlCompositeDirectCollectionMapping.isReadOnly()) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object collection = this.xmlCompositeDirectCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (!cp.hasNext(iterator)) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        StringBuilder stringValueStringBuilder = new StringBuilder();
        if (this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            while (cp.hasNext(iterator)) {
                QName schemaType;
                String newValue;
                objectValue = cp.next(iterator, session);
                if (this.xmlCompositeDirectCollectionMapping.hasValueConverter()) {
                    objectValue = this.xmlCompositeDirectCollectionMapping.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.xmlCompositeDirectCollectionMapping.getValueConverter()).convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller()) : this.xmlCompositeDirectCollectionMapping.getValueConverter().convertObjectValueToDataValue(objectValue, session);
                }
                if (null == (newValue = this.getValueToWrite(schemaType = this.getSchemaType((XMLField)this.xmlCompositeDirectCollectionMapping.getField(), objectValue, session), objectValue, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), marshalRecord))) continue;
                stringValueStringBuilder.append(newValue);
                if (!cp.hasNext(iterator)) continue;
                stringValueStringBuilder.append(SPACE);
            }
            XPathFragment groupingFragment2 = marshalRecord.openStartGroupingElements(namespaceResolver);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, stringValueStringBuilder.toString());
                marshalRecord.closeStartGroupingElements(groupingFragment2);
            } else {
                marshalRecord.closeStartGroupingElements(groupingFragment2);
                if (this.xmlCompositeDirectCollectionMapping.isCDATA()) {
                    marshalRecord.cdata(stringValueStringBuilder.toString());
                } else {
                    marshalRecord.characters(stringValueStringBuilder.toString());
                }
            }
        } else {
            while (cp.hasNext(iterator)) {
                objectValue = cp.next(iterator, session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
            }
        }
        return true;
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        if (this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            StringTokenizer stringTokenizer = new StringTokenizer(value);
            while (stringTokenizer.hasMoreTokens()) {
                this.addUnmarshalValue(unmarshalRecord, stringTokenizer.nextToken(), collection);
            }
        } else {
            this.addUnmarshalValue(unmarshalRecord, value, collection);
        }
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        XMLField xmlField = (XMLField)this.xmlCompositeDirectCollectionMapping.getField();
        if (xmlField.getLastXPathFragment().nameIsText()) {
            String type2 = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != type2) {
                String namespaceURI = null;
                int colonIndex = type2.indexOf(58);
                if (colonIndex > -1) {
                    String prefix = type2.substring(0, colonIndex);
                    namespaceURI = unmarshalRecord.resolveNamespacePrefix(prefix);
                    type2 = type2.substring(colonIndex + 1);
                }
                unmarshalRecord.setTypeQName(new QName(namespaceURI, type2));
            }
            if (this.xmlCompositeDirectCollectionMapping.getNullPolicy().isNullRepresentedByXsiNil() && this.xmlCompositeDirectCollectionMapping.getNullPolicy().valueIsNull(atts)) {
                this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
            }
        } else if (xmlField.getLastXPathFragment().isAttribute() && !this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            String namespaceURI = xmlField.getLastXPathFragment().getNamespaceURI();
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            String value = atts.getValue(namespaceURI, xmlField.getLastXPathFragment().getLocalName());
            Object collection = unmarshalRecord.getContainerInstance(this);
            this.addUnmarshalValue(unmarshalRecord, value, collection);
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        XMLField xmlField = (XMLField)this.xmlCompositeDirectCollectionMapping.getField();
        if (!xmlField.getLastXPathFragment().nameIsText()) {
            return;
        }
        String value = ((Object)unmarshalRecord.getCharacters()).toString();
        Object collection = unmarshalRecord.getContainerInstance(this);
        unmarshalRecord.resetStringBuffer();
        if (this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            StringTokenizer stringTokenizer = new StringTokenizer(value);
            while (stringTokenizer.hasMoreTokens()) {
                this.addUnmarshalValue(unmarshalRecord, stringTokenizer.nextToken(), collection);
            }
        } else if (xmlField.getLastXPathFragment().nameIsText()) {
            this.addUnmarshalValue(unmarshalRecord, value, collection);
        }
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        String value = ((Object)unmarshalRecord.getCharacters()).toString();
        unmarshalRecord.resetStringBuffer();
        if (this.xmlCompositeDirectCollectionMapping.usesSingleNode()) {
            StringTokenizer stringTokenizer = new StringTokenizer(value);
            while (stringTokenizer.hasMoreTokens()) {
                this.addUnmarshalValue(unmarshalRecord, stringTokenizer.nextToken(), collection);
            }
        } else {
            XMLField xmlField = (XMLField)this.xmlCompositeDirectCollectionMapping.getField();
            if (xmlField.getLastXPathFragment().nameIsText()) {
                this.addUnmarshalValue(unmarshalRecord, value, collection);
            }
        }
    }

    private void addUnmarshalValue(UnmarshalRecord unmarshalRecord, Object value, Object collection) {
        if (null == value) {
            return;
        }
        if (this.xmlCompositeDirectCollectionMapping.getNullPolicy().isNullRepresentedByXsiNil() && (unmarshalRecord.isNil() || this.xmlCompositeDirectCollectionMapping.getNullPolicy().valueIsNull(unmarshalRecord.getAttributes()))) {
            return;
        }
        if (!this.isWhitespaceAware() && "".equals(value)) {
            value = null;
        }
        XMLField xmlField = (XMLField)this.xmlCompositeDirectCollectionMapping.getField();
        XMLConversionManager xmlConversionManager = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = xmlField.getJavaClass(unmarshalRecord.getTypeQName());
            value = xmlConversionManager.convertObject(value, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value = xmlField.convertValueBasedOnSchemaType(value, xmlConversionManager, unmarshalRecord);
        }
        if (this.xmlCompositeDirectCollectionMapping.hasValueConverter()) {
            value = this.xmlCompositeDirectCollectionMapping.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.xmlCompositeDirectCollectionMapping.getValueConverter()).convertDataValueToObjectValue(value, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : this.xmlCompositeDirectCollectionMapping.getValueConverter().convertDataValueToObjectValue(value, unmarshalRecord.getSession());
        }
        if (value != null && value.getClass() == ClassConstants.STRING) {
            if (this.xmlCompositeDirectCollectionMapping.isCollapsingStringValues()) {
                value = XMLConversionManager.getDefaultXMLManager().collapseStringValue((String)value);
            } else if (this.xmlCompositeDirectCollectionMapping.isNormalizingStringValues()) {
                value = XMLConversionManager.getDefaultXMLManager().normalizeStringValue((String)value);
            }
        }
        unmarshalRecord.addAttributeValue(this, value, collection);
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeDirectCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlCompositeDirectCollectionMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlCompositeDirectCollectionMapping.hasValueConverter()) {
            value = this.xmlCompositeDirectCollectionMapping.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.xmlCompositeDirectCollectionMapping.getValueConverter()).convertObjectValueToDataValue(value, session, marshalRecord.getMarshaller()) : this.xmlCompositeDirectCollectionMapping.getValueConverter().convertObjectValueToDataValue(value, session);
        }
        XMLField xmlField = (XMLField)this.xmlCompositeDirectCollectionMapping.getField();
        if (null != value) {
            QName fieldValue;
            QName schemaType = this.getSchemaType(xmlField, value, session);
            boolean isElementOpen = false;
            if (XMLConstants.QNAME_QNAME.equals(schemaType) && ((fieldValue = (QName)value).getNamespaceURI() == null || fieldValue.getNamespaceURI().equals("") && marshalRecord.getNamespaceResolver().getDefaultNamespaceURI() != null) && namespaceResolver.getDefaultNamespaceURI().equals(xPathFragment.getNamespaceURI()) && xPathFragment.getPrefix() == null) {
                String prefix = namespaceResolver.generatePrefix();
                String xPath = prefix + ":" + xPathFragment.getShortName();
                XPathFragment newFragment = new XPathFragment(xPath);
                newFragment.setNamespaceURI(namespaceResolver.getDefaultNamespaceURI());
                newFragment.setNextFragment(xPathFragment.getNextFragment());
                marshalRecord.openStartElement(newFragment, namespaceResolver);
                isElementOpen = true;
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceResolver.getDefaultNamespaceURI());
                marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                xPathFragment = newFragment;
            }
            if (!isElementOpen) {
                marshalRecord.openStartElement(xPathFragment, namespaceResolver);
            }
            String stringValue = this.getValueToWrite(schemaType, value, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), marshalRecord);
            XPathFragment nextFragment = xPathFragment.getNextFragment();
            if (nextFragment.isAttribute()) {
                marshalRecord.attribute(nextFragment, namespaceResolver, stringValue);
                marshalRecord.closeStartElement();
            } else {
                if (xmlField.isTypedTextField()) {
                    this.updateNamespaces(schemaType, marshalRecord, xmlField);
                }
                marshalRecord.closeStartElement();
                marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                if (this.xmlCompositeDirectCollectionMapping.isCDATA()) {
                    marshalRecord.cdata(stringValue);
                } else {
                    marshalRecord.characters(stringValue);
                }
            }
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        } else if (this.xmlCompositeDirectCollectionMapping.getNullPolicy().getMarshalNullRepresentation() != XMLNullRepresentationType.ABSENT_NODE) {
            marshalRecord.openStartElement(xPathFragment, namespaceResolver);
            XPathFragment nextFragment = xPathFragment.getNextFragment();
            this.xmlCompositeDirectCollectionMapping.getNullPolicy().directMarshal(nextFragment, marshalRecord, object, session, namespaceResolver);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    public XMLCompositeDirectCollectionMapping getMapping() {
        return this.xmlCompositeDirectCollectionMapping;
    }

    public boolean isWhitespaceAware() {
        return !this.xmlCompositeDirectCollectionMapping.getNullPolicy().isNullRepresentedByEmptyNode();
    }

    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }
}

