/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class QNameInheritancePolicy
extends InheritancePolicy {
    private NamespaceResolver namespaceResolver;

    public QNameInheritancePolicy() {
    }

    public QNameInheritancePolicy(ClassDescriptor desc) {
        super(desc);
    }

    protected void updateTables() {
        Vector<DatabaseTable> childTables = this.getDescriptor().getTables();
        Vector<DatabaseTable> parentTables = this.getParentDescriptor().getTables();
        Vector uniqueTables = Helper.concatenateUniqueVectors(childTables, parentTables);
        this.getDescriptor().setTables(uniqueTables);
        if (childTables.isEmpty()) {
            this.getDescriptor().setInternalDefaultTable();
        } else {
            this.getDescriptor().setInternalDefaultTable((DatabaseTable)uniqueTables.get(uniqueTables.indexOf(childTables.get(0))));
        }
    }

    public void initialize(AbstractSession session) {
        super.initialize(session);
        if (!this.shouldUseClassNameAsIndicator()) {
            for (Map.Entry entry : new HashMap(this.getClassIndicatorMapping()).entrySet()) {
                QName qname;
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String indicatorValue = (String)key;
                int index = indicatorValue.indexOf(58);
                if (index != -1 && this.namespaceResolver != null) {
                    String prefix = indicatorValue.substring(0, index);
                    String localPart = indicatorValue.substring(index + 1);
                    String uri = this.namespaceResolver.resolveNamespacePrefix(prefix);
                    qname = new QName(uri, localPart);
                } else {
                    qname = this.namespaceResolver != null ? new QName(this.namespaceResolver.getDefaultNamespaceURI(), indicatorValue) : new QName(indicatorValue);
                }
                this.getClassIndicatorMapping().put(qname, entry.getValue());
            }
        }
        if (this.getClassIndicatorField() != null) {
            XMLField classIndicatorXMLField;
            try {
                classIndicatorXMLField = (XMLField)this.getClassIndicatorField();
            }
            catch (ClassCastException ex) {
                classIndicatorXMLField = new XMLField(this.getClassIndicatorField().getName());
                this.setClassIndicatorField(classIndicatorXMLField);
            }
            XPathFragment frag = classIndicatorXMLField.getLastXPathFragment();
            if (frag != null && frag.hasNamespace() && this.namespaceResolver != null) {
                String uri = this.namespaceResolver.resolveNamespacePrefix(frag.getPrefix());
                classIndicatorXMLField.getLastXPathFragment().setNamespaceURI(uri);
            }
        }
    }

    public Class classFromRow(AbstractRecord rowFromDatabase, AbstractSession session) throws DescriptorException {
        Class concreteClass;
        ((XMLRecord)rowFromDatabase).setSession(session);
        if (this.hasClassExtractor() || this.shouldUseClassNameAsIndicator()) {
            return super.classFromRow(rowFromDatabase, session);
        }
        Object indicator = rowFromDatabase.get(this.getClassIndicatorField());
        if (indicator == AbstractRecord.noEntry) {
            return null;
        }
        if (indicator == null) {
            return null;
        }
        if (indicator instanceof String) {
            String indicatorValue = (String)indicator;
            int index = indicatorValue.indexOf(58);
            if (index == -1) {
                String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(null);
                if (uri == null) {
                    concreteClass = (Class)this.classIndicatorMapping.get(new QName(((XMLRecord)rowFromDatabase).getNamespaceResolver().getDefaultNamespaceURI(), indicatorValue));
                } else {
                    QName qname = new QName(uri, indicatorValue);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                }
            } else {
                String prefix = indicatorValue.substring(0, index);
                String localPart = indicatorValue.substring(index + 1);
                String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(prefix);
                if (uri != null) {
                    QName qname = new QName(uri, localPart);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                } else {
                    concreteClass = (Class)this.classIndicatorMapping.get(indicatorValue);
                }
            }
        } else {
            concreteClass = (Class)this.classIndicatorMapping.get(indicator);
        }
        if (concreteClass == null) {
            throw DescriptorException.missingClassForIndicatorFieldValue(indicator, this.getDescriptor());
        }
        return concreteClass;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public void setClassIndicatorFieldName(String fieldName) {
        if (fieldName == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new XMLField(fieldName));
        }
    }
}

