/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.MemberOfNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTree;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class SelectGenerationContext
extends GenerationContext {
    private boolean useParallelExpressions = false;
    private boolean shouldCheckSelectNodeBeforeResolving = false;
    private MemberOfNode memberOfNode = null;
    private boolean shouldUseOuterJoins = false;
    private GenerationContext outer = null;

    public SelectGenerationContext() {
    }

    public SelectGenerationContext(GenerationContext outer, ParseTree newParseTree) {
        this(outer.getParseTreeContext(), outer.getSession(), newParseTree);
        this.outer = outer;
    }

    public SelectGenerationContext(ParseTreeContext newContext, AbstractSession newSession, ParseTree newParseTree) {
        super(newContext, newSession, newParseTree);
        this.useParallelExpressions = this.computeUseParallelExpressions();
    }

    public void setMemberOfNode(MemberOfNode newMemberOfNode) {
        this.memberOfNode = newMemberOfNode;
    }

    public MemberOfNode getMemberOfNode() {
        return this.memberOfNode;
    }

    private boolean computeUseParallelExpressions() {
        boolean computedUseParallelExpressions = ((SelectNode)this.parseTree.getQueryNode()).hasOneToOneSelected(this);
        computedUseParallelExpressions = computedUseParallelExpressions || ((SelectNode)this.parseTree.getQueryNode()).isVariableInINClauseSelected(this) || this.parseTree.getContext().hasMoreThanOneVariablePerType() || this.parseTree.getContext().hasMoreThanOneAliasInFrom();
        return computedUseParallelExpressions;
    }

    public boolean useParallelExpressions() {
        return this.useParallelExpressions;
    }

    public void checkSelectNodeBeforeResolving(boolean shouldCheck) {
        this.shouldCheckSelectNodeBeforeResolving = shouldCheck;
    }

    public boolean shouldCheckSelectNodeBeforeResolving() {
        return this.shouldCheckSelectNodeBeforeResolving;
    }

    public boolean shouldUseOuterJoins() {
        return this.shouldUseOuterJoins;
    }

    public void useOuterJoins() {
        this.shouldUseOuterJoins = true;
    }

    public void dontUseOuterJoins() {
        this.shouldUseOuterJoins = false;
    }

    public boolean hasMemberOfNode() {
        return this.memberOfNode != null;
    }

    public boolean isSelectGenerationContext() {
        return true;
    }

    public GenerationContext getOuterContext() {
        return this.outer;
    }

    public Expression joinVariables(Set variables) {
        if (this.outer == null || variables == null || variables.isEmpty()) {
            return null;
        }
        Expression expr = null;
        for (String name : variables) {
            Expression outerExpr;
            VariableNode var = new VariableNode(name);
            Expression innerExpr = var.generateExpression(this);
            if (innerExpr == (outerExpr = var.generateExpression(this.outer))) continue;
            Expression join = innerExpr.equal(outerExpr);
            expr = var.appendExpression(expr, join);
        }
        return expr;
    }
}

