/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryImpl
implements EntityManagerFactory,
PersistenceUnitUtil,
JpaEntityManagerFactory {
    protected EntityManagerFactoryDelegate delegate;

    public static Object getIdentifier(Object entity, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(entity);
        if (descriptor == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_persistence_util_non_persistent_class", new Object[]{entity}));
        }
        if (descriptor.getCMPPolicy() != null) {
            return descriptor.getCMPPolicy().createPrimaryKeyInstance(entity, session);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_persistence_util_non_persistent_class", new Object[]{entity}));
    }

    public static Boolean isLoaded(Object entity, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(entity);
        if (descriptor == null) {
            return null;
        }
        Vector<DatabaseMapping> mappings = descriptor.getMappings();
        for (DatabaseMapping mapping : mappings) {
            if (mapping.isLazy() || EntityManagerFactoryImpl.isLoaded(entity, mapping.getAttributeName(), mapping)) continue;
            return false;
        }
        return true;
    }

    public static Boolean isLoaded(Object entity, String attributeName, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(entity);
        if (descriptor == null) {
            return null;
        }
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            return null;
        }
        return EntityManagerFactoryImpl.isLoaded(entity, attributeName, mapping);
    }

    public static boolean isLoaded(Object entity, String attributeName, DatabaseMapping mapping) {
        if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).isLazy()) {
            Object value = mapping.getAttributeValueFromObject(entity);
            IndirectionPolicy policy = ((ForeignReferenceMapping)mapping).getIndirectionPolicy();
            return policy.objectIsInstantiated(value);
        }
        if (entity instanceof FetchGroupTracker) {
            return ((FetchGroupTracker)entity)._persistence_isAttributeFetched(attributeName);
        }
        return true;
    }

    public EntityManagerFactoryImpl(DatabaseSessionImpl session) {
        this.delegate = new EntityManagerFactoryDelegate(session, this);
    }

    public EntityManagerFactoryImpl(EntityManagerSetupImpl setupImpl, Map properties) {
        this.delegate = new EntityManagerFactoryDelegate(setupImpl, properties, this);
    }

    public EntityManagerFactoryImpl(String persistenceUnitName, Map<String, Object> properties, List<ClassDescriptor> descriptors) {
        this.delegate = new EntityManagerFactoryDelegate(persistenceUnitName, properties, descriptors, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshMetadata(Map properties) {
        EntityManagerSetupImpl setupImpl = this.delegate.getSetupImpl();
        if (setupImpl == null) {
            throw PersistenceUnitLoadingException.cannotRefreshEntityManagerFactoryCreatedFromSession(this.delegate.getServerSession().getName());
        }
        String sessionName = setupImpl.getSessionName();
        Map<String, Object> existingProperties = this.delegate.getProperties();
        HashMap<String, Object> deployProperties = new HashMap<String, Object>();
        deployProperties.putAll(existingProperties);
        if (properties != null) {
            deployProperties.putAll(properties);
        }
        EntityManagerSetupImpl newSetupImpl = setupImpl.refreshMetadata(properties);
        EntityManagerFactoryDelegate oldDelegate = this.delegate;
        this.delegate = new EntityManagerFactoryDelegate(newSetupImpl, deployProperties, this);
        try {
            if (newSetupImpl.shouldGetSessionOnCreateFactory(deployProperties)) {
                this.getServerSession();
            }
        }
        catch (RuntimeException ex) {
            if (this.delegate != null) {
                this.delegate.close();
            } else {
                newSetupImpl.undeploy();
            }
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                EntityManagerFactoryProvider.emSetupImpls.put(sessionName, setupImpl);
                SessionManager.getManager().getSessions().put(sessionName, setupImpl.getSession());
                setupImpl.setIsMetadataExpired(false);
            }
            this.delegate = oldDelegate;
            throw ex;
        }
    }

    @Override
    public SessionBroker getSessionBroker() {
        return this.delegate.getSessionBroker();
    }

    @Override
    public ServerSession getServerSession() {
        return this.delegate.getServerSession();
    }

    @Override
    public synchronized void close() {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public EntityManager createEntityManager() {
        return this.createEntityManagerImpl(null);
    }

    @Override
    public EntityManager createEntityManager(Map properties) {
        return this.createEntityManagerImpl(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerImpl createEntityManagerImpl(Map properties) {
        EntityManagerSetupImpl setupImpl = this.delegate.getSetupImpl();
        if (setupImpl != null && setupImpl.isMetadataExpired()) {
            String sessionName = setupImpl.getSessionName();
            EntityManagerSetupImpl storedImpl = null;
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                storedImpl = EntityManagerFactoryProvider.emSetupImpls.get(sessionName);
            }
            if (storedImpl != null) {
                this.delegate = new EntityManagerFactoryDelegate(storedImpl, this.delegate.getProperties(), this);
            }
        }
        return this.delegate.createEntityManagerImpl(properties);
    }

    @Override
    public EntityManagerFactoryDelegate unwrap() {
        return this.delegate;
    }

    protected void verifyOpen() {
        this.delegate.verifyOpen();
    }

    protected void finalize() throws Throwable {
        this.delegate = null;
    }

    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    public boolean getBeginEarlyTransaction() {
        return this.delegate.getBeginEarlyTransaction();
    }

    public void setBeginEarlyTransaction(boolean beginEarlyTransaction) {
        this.delegate.setBeginEarlyTransaction(beginEarlyTransaction);
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.delegate.setFlushMode(flushMode);
    }

    public ReferenceMode getReferenceMode() {
        return this.delegate.getReferenceMode();
    }

    public void setReferenceMode(ReferenceMode referenceMode) {
        this.delegate.setReferenceMode(referenceMode);
    }

    public boolean getCloseOnCommit() {
        return this.delegate.getCloseOnCommit();
    }

    public void setCloseOnCommit(boolean closeOnCommit) {
        this.delegate.setCloseOnCommit(closeOnCommit);
    }

    public boolean getPersistOnCommit() {
        return this.delegate.getPersistOnCommit();
    }

    @Override
    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.delegate;
    }

    public void setPersistOnCommit(boolean persistOnCommit) {
        this.delegate.setPersistOnCommit(persistOnCommit);
    }

    public boolean getCommitWithoutPersistRules() {
        return this.delegate.getCommitWithoutPersistRules();
    }

    public void setCommitWithoutPersistRules(boolean commitWithoutPersistRules) {
        this.delegate.setCommitWithoutPersistRules(commitWithoutPersistRules);
    }

    public String getFlushClearCache() {
        return this.delegate.getFlushClearCache();
    }

    public void setFlushClearCache(String flushClearCache) {
        this.delegate.setFlushClearCache(flushClearCache);
    }

    public boolean shouldValidateExistence() {
        return this.delegate.shouldValidateExistence();
    }

    public void setShouldValidateExistence(boolean shouldValidateExistence) {
        this.delegate.setShouldValidateExistence(shouldValidateExistence);
    }

    @Override
    public Cache getCache() {
        return this.delegate.getCache();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public DatabaseSessionImpl getDatabaseSession() {
        return this.delegate.getDatabaseSession();
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    @Override
    public Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    public void setMetamodel(Metamodel aMetamodel) {
        this.delegate.setMetamodel(aMetamodel);
    }

    @Override
    public boolean isLoaded(Object entity, String attributeName) {
        return this.delegate.isLoaded(entity, attributeName);
    }

    @Override
    public boolean isLoaded(Object entity) {
        return this.delegate.isLoaded(entity);
    }

    @Override
    public Object getIdentifier(Object entity) {
        return this.delegate.getIdentifier(entity);
    }

    public boolean shouldOrderUpdates() {
        return this.delegate.shouldOrderUpdates();
    }

    public void setShouldOrderUpdates(boolean shouldOrderUpdates) {
        this.delegate.setShouldOrderUpdates(shouldOrderUpdates);
    }
}

