/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import javax.xml.transform.TransformerException;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.MbeansSourceMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbeansSource
extends ModelerSource
implements MbeansSourceMBean {
    private static Logger log = Logger.getLogger(MbeansSource.class.getName());
    Registry registry;
    String type;
    boolean loading = true;
    List<ObjectName> mbeans = new ArrayList<ObjectName>();
    static boolean loaderLoaded = false;
    private Document document;
    private HashMap<ObjectName, Node> object2Node = new HashMap();
    long lastUpdate;
    long updateInterval = 10000L;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    @Override
    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public List<ObjectName> getMBeans() {
        return this.mbeans;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String location, String type2, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type2);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void start() throws Exception {
        this.registry.invoke(this.mbeans, "start", false);
    }

    public void stop() throws Exception {
        this.registry.invoke(this.mbeans, "stop", false);
    }

    @Override
    public void init() throws Exception {
        if (this.mbeans == null) {
            this.execute();
        }
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        this.registry.invoke(this.mbeans, "init", false);
    }

    public void destroy() throws Exception {
        this.registry.invoke(this.mbeans, "destroy", false);
    }

    @Override
    public void load() throws Exception {
        this.execute();
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            InputStream stream = this.getInputStream();
            long t1 = System.currentTimeMillis();
            this.document = DomUtil.readXml(stream);
            Element descriptorsN = this.document.getDocumentElement();
            if (descriptorsN == null) {
                log.log(Level.SEVERE, "No descriptors found");
                return;
            }
            Node firstMbeanN = DomUtil.getChild((Node)descriptorsN, null);
            if (firstMbeanN == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("No child " + descriptorsN);
                }
                firstMbeanN = descriptorsN;
            }
            MBeanServer server = Registry.getRegistry(null, null).getMBeanServer();
            if (!loaderLoaded) {
                ObjectName defaultLoader = new ObjectName("modeler", "loader", "modeler");
                MLet mlet = new MLet(new URL[0], this.getClass().getClassLoader());
                server.registerMBean(mlet, defaultLoader);
                loaderLoaded = true;
            }
            Node mbeanN = firstMbeanN;
            while (mbeanN != null) {
                Node firstN;
                String nodeName = mbeanN.getNodeName();
                if ("mbean".equals(nodeName) || "MLET".equals(nodeName)) {
                    Node firstAttN;
                    Node constructorN;
                    String code = DomUtil.getAttribute(mbeanN, "code");
                    String objectName = DomUtil.getAttribute(mbeanN, "objectName");
                    if (objectName == null) {
                        objectName = DomUtil.getAttribute(mbeanN, "name");
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Processing mbean objectName=" + objectName + " code=" + code);
                    }
                    if ((constructorN = DomUtil.getChild(mbeanN, "constructor")) == null) {
                        constructorN = mbeanN;
                    }
                    this.processArg(constructorN);
                    try {
                        ObjectName oname = new ObjectName(objectName);
                        if (!server.isRegistered(oname)) {
                            String modelMBean = BaseModelMBean.class.getName();
                            server.createMBean(modelMBean, oname, new Object[]{code, this}, new String[]{String.class.getName(), ModelerSource.class.getName()});
                            this.mbeans.add(oname);
                        }
                        this.object2Node.put(oname, mbeanN);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "Error creating mbean " + objectName, ex);
                    }
                    Node descN = firstAttN = DomUtil.getChild(mbeanN, "attribute");
                    while (descN != null) {
                        this.processAttribute(server, descN, objectName);
                        descN = DomUtil.getNext(descN);
                    }
                } else if ("jmx-operation".equals(nodeName)) {
                    String name = DomUtil.getAttribute(mbeanN, "objectName");
                    if (name == null) {
                        name = DomUtil.getAttribute(mbeanN, "name");
                    }
                    String operation = DomUtil.getAttribute(mbeanN, "operation");
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Processing invoke objectName=" + name + " code=" + operation);
                    }
                    try {
                        ObjectName oname = new ObjectName(name);
                        this.processArg(mbeanN);
                        server.invoke(oname, operation, null, null);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error in invoke " + name + " " + operation);
                    }
                }
                ManagedBean managed = new ManagedBean();
                DomUtil.setAttributes(managed, mbeanN);
                Node descN = firstN = DomUtil.getChild(mbeanN, "attribute");
                while (descN != null) {
                    AttributeInfo ci = new AttributeInfo();
                    DomUtil.setAttributes(ci, descN);
                    managed.addAttribute(ci);
                    descN = DomUtil.getNext(descN);
                }
                mbeanN = DomUtil.getNext(mbeanN, null, 1);
            }
            if (log.isLoggable(Level.INFO)) {
                long t2 = System.currentTimeMillis();
                log.log(Level.INFO, "Reading mbeans  " + (t2 - t1));
            }
            this.loading = false;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error reading mbeans ", ex);
        }
    }

    @Override
    public void updateField(ObjectName oname, String name, Object value) {
        String oldValue;
        if (this.loading) {
            return;
        }
        Node n = this.object2Node.get(oname);
        if (n == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Node not found " + oname);
            }
            return;
        }
        Node attNode = DomUtil.findChildWithAtt(n, "attribute", "name", name);
        if (attNode == null) {
            attNode = n.getOwnerDocument().createElement("attribute");
            DomUtil.setAttribute(attNode, "name", name);
            n.appendChild(attNode);
        }
        if ((oldValue = DomUtil.getAttribute(attNode, "value")) != null) {
            DomUtil.removeAttribute(attNode, "value");
        }
        DomUtil.setText(attNode, value.toString());
    }

    @Override
    public void save() {
        long time = System.currentTimeMillis();
        if (this.location != null && time - this.lastUpdate > this.updateInterval) {
            this.lastUpdate = time;
            try {
                FileOutputStream fos = new FileOutputStream(this.location);
                DomUtil.writeXml(this.document, fos);
            }
            catch (TransformerException e) {
                log.log(Level.SEVERE, "Error writing");
            }
            catch (FileNotFoundException e) {
                log.log(Level.SEVERE, "Error writing", e);
            }
        }
    }

    private void processAttribute(MBeanServer server, Node descN, String objectName) {
        String attName = DomUtil.getAttribute(descN, "name");
        String value = DomUtil.getAttribute(descN, "value");
        String type2 = null;
        if (value == null) {
            value = DomUtil.getContent(descN);
        }
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Set attribute " + objectName + " " + attName + " " + value);
            }
            ObjectName oname = new ObjectName(objectName);
            if (type2 == null) {
                type2 = this.registry.getType(oname, attName);
            }
            if (type2 == null) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Can't find attribute " + objectName + " " + attName);
                }
            } else {
                Object valueO = this.registry.convertValue(type2, value);
                server.setAttribute(oname, new Attribute(attName, valueO));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error processing attribute " + objectName + " " + attName + " " + value, ex);
        }
    }

    private void processArg(Node mbeanN) {
        Node firstArgN;
        Node argN = firstArgN = DomUtil.getChild(mbeanN, "arg");
        while (argN != null) {
            String type2 = DomUtil.getAttribute(argN, "type");
            String value = DomUtil.getAttribute(argN, "value");
            if (value == null) {
                value = DomUtil.getContent(argN);
            }
            argN = DomUtil.getNext(argN);
        }
    }
}

