/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.ConstructorInfo;
import org.apache.tomcat.util.modeler.FieldInfo;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.NotificationInfo;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbeansDescriptorsDOMSource
extends ModelerSource {
    private static Logger log = Logger.getLogger(MbeansDescriptorsDOMSource.class.getName());
    Registry registry;
    String type;
    List<ObjectName> mbeans = new ArrayList<ObjectName>();

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String location, String type2, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type2);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            InputStream stream = (InputStream)this.source;
            long t1 = System.currentTimeMillis();
            Document doc = DomUtil.readXml(stream);
            Element descriptorsN = doc.getDocumentElement();
            if (descriptorsN == null) {
                log.log(Level.SEVERE, "No descriptors found");
                return;
            }
            Node firstMbeanN = null;
            firstMbeanN = "mbean".equals(descriptorsN.getNodeName()) ? descriptorsN : DomUtil.getChild((Node)descriptorsN, "mbean");
            if (firstMbeanN == null) {
                log.log(Level.SEVERE, " No mbean tags ");
                return;
            }
            Node mbeanN = firstMbeanN;
            while (mbeanN != null) {
                ParameterInfo pi;
                Node paramN;
                Node firstParamN;
                Node firstDescriptorN;
                FieldInfo fi;
                Node fieldN;
                Node firstFieldN;
                Node firstN;
                ManagedBean managed = new ManagedBean();
                DomUtil.setAttributes(managed, mbeanN);
                Node mbeanDescriptorN = DomUtil.getChild(mbeanN, "descriptor");
                if (mbeanDescriptorN != null) {
                    Node firstFieldN2;
                    Node fieldN2 = firstFieldN2 = DomUtil.getChild(mbeanDescriptorN, "field");
                    while (fieldN2 != null) {
                        FieldInfo fi2 = new FieldInfo();
                        DomUtil.setAttributes(fi2, fieldN2);
                        managed.addField(fi2);
                        fieldN2 = DomUtil.getNext(fieldN2);
                    }
                }
                Node descN = firstN = DomUtil.getChild(mbeanN, "attribute");
                while (descN != null) {
                    AttributeInfo ai = new AttributeInfo();
                    DomUtil.setAttributes(ai, descN);
                    Node descriptorN = DomUtil.getChild(descN, "descriptor");
                    if (descriptorN != null) {
                        fieldN = firstFieldN = DomUtil.getChild(descriptorN, "field");
                        while (fieldN != null) {
                            fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            ai.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    managed.addAttribute(ai);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Create attribute " + ai);
                    }
                    descN = DomUtil.getNext(descN);
                }
                descN = firstN = DomUtil.getChild(mbeanN, "constructor");
                while (descN != null) {
                    ConstructorInfo ci = new ConstructorInfo();
                    DomUtil.setAttributes(ci, descN);
                    firstDescriptorN = DomUtil.getChild(descN, "descriptor");
                    if (firstDescriptorN != null) {
                        fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                        while (fieldN != null) {
                            fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            ci.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    paramN = firstParamN = DomUtil.getChild(descN, "parameter");
                    while (paramN != null) {
                        pi = new ParameterInfo();
                        DomUtil.setAttributes(pi, paramN);
                        ci.addParameter(pi);
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addConstructor(ci);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Create constructor " + ci);
                    }
                    descN = DomUtil.getNext(descN);
                }
                descN = firstN = DomUtil.getChild(mbeanN, "notification");
                while (descN != null) {
                    NotificationInfo ni = new NotificationInfo();
                    DomUtil.setAttributes(ni, descN);
                    firstDescriptorN = DomUtil.getChild(descN, "descriptor");
                    if (firstDescriptorN != null) {
                        fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                        while (fieldN != null) {
                            fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            ni.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    paramN = firstParamN = DomUtil.getChild(descN, "notification-type");
                    while (paramN != null) {
                        ni.addNotifType(DomUtil.getContent(paramN));
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addNotification(ni);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Created notification " + ni);
                    }
                    descN = DomUtil.getNext(descN);
                }
                descN = firstN = DomUtil.getChild(mbeanN, "operation");
                while (descN != null) {
                    OperationInfo oi = new OperationInfo();
                    DomUtil.setAttributes(oi, descN);
                    firstDescriptorN = DomUtil.getChild(descN, "descriptor");
                    if (firstDescriptorN != null) {
                        fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                        while (fieldN != null) {
                            fi = new FieldInfo();
                            DomUtil.setAttributes(fi, fieldN);
                            oi.addField(fi);
                            fieldN = DomUtil.getNext(fieldN);
                        }
                    }
                    paramN = firstParamN = DomUtil.getChild(descN, "parameter");
                    while (paramN != null) {
                        pi = new ParameterInfo();
                        DomUtil.setAttributes(pi, paramN);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Add param " + pi.getName());
                        }
                        oi.addParameter(pi);
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addOperation(oi);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Create operation " + oi);
                    }
                    descN = DomUtil.getNext(descN);
                }
                this.registry.addManagedBean(managed);
                mbeanN = DomUtil.getNext(mbeanN);
            }
            if (log.isLoggable(Level.FINE)) {
                long t2 = System.currentTimeMillis();
                log.log(Level.FINE, "Reading descriptors ( dom ) " + (t2 - t1));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error reading descriptors ", ex);
        }
    }
}

