/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerateScratchSpace;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;

public abstract class OpenConglomerate {
    private Conglomerate init_conglomerate;
    private TransactionManager init_xact_manager;
    private Transaction init_rawtran;
    private int init_openmode;
    private int init_lock_level;
    private DynamicCompiledOpenConglomInfo init_dynamic_info;
    private boolean init_hold;
    private LockingPolicy init_locking_policy;
    private boolean useUpdateLocks;
    private boolean forUpdate;
    private boolean getBaseTableLocks;
    private OpenConglomerateScratchSpace runtime_mem;
    private ContainerHandle container;

    protected abstract RowLocation newRowLocationTemplate() throws StandardException;

    public abstract int[] getFormatIds();

    public boolean latchPageAndRepositionScan(RowPosition rowPosition) throws StandardException {
        boolean bl = false;
        rowPosition.current_page = null;
        try {
            if (rowPosition.current_rh != null) {
                rowPosition.current_page = this.container.getPage(rowPosition.current_rh.getPageNumber());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rowPosition.current_page != null) {
            try {
                rowPosition.current_slot = rowPosition.current_page.getSlotNumber(rowPosition.current_rh);
            }
            catch (StandardException standardException) {
                bl = true;
                rowPosition.current_slot = rowPosition.current_page.getNextSlotNumber(rowPosition.current_rh);
                if (rowPosition.current_slot == -1) {
                    rowPosition.current_page.unlatch();
                    rowPosition.current_page = null;
                }
                --rowPosition.current_slot;
            }
        }
        if (rowPosition.current_page == null) {
            long l;
            if (rowPosition.current_rh != null) {
                l = rowPosition.current_rh.getPageNumber();
            } else if (rowPosition.current_pageno != -1L) {
                l = rowPosition.current_pageno;
            } else {
                return false;
            }
            rowPosition.current_page = this.container.getNextPage(l);
            rowPosition.current_slot = -1;
            rowPosition.current_pageno = -1L;
            bl = true;
        }
        if (bl) {
            rowPosition.current_rh = null;
        }
        return bl;
    }

    public boolean latchPage(RowPosition rowPosition) throws StandardException {
        rowPosition.current_page = null;
        try {
            rowPosition.current_page = this.container.getPage(rowPosition.current_rh.getPageNumber());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rowPosition.current_page != null) {
            try {
                rowPosition.current_slot = rowPosition.current_page.getSlotNumber(rowPosition.current_rh);
                return true;
            }
            catch (Throwable throwable) {
                rowPosition.current_page.unlatch();
                rowPosition.current_page = null;
            }
        }
        return false;
    }

    public boolean lockPositionForRead(RowPosition rowPosition, RowPosition rowPosition2, boolean bl, boolean bl2) throws StandardException {
        boolean bl3;
        if (rowPosition.current_rh == null) {
            rowPosition.current_rh = rowPosition.current_page.getRecordHandleAtSlot(rowPosition.current_slot);
        }
        if (!(bl3 = this.container.getLockingPolicy().lockRecordForRead(this.init_rawtran, this.container, rowPosition.current_rh, false, this.forUpdate))) {
            rowPosition.current_page.unlatch();
            rowPosition.current_page = null;
            if (rowPosition2 != null) {
                rowPosition2.current_page.unlatch();
                rowPosition2.current_page = null;
            }
            if (!bl2) {
                throw StandardException.newException("40XL1");
            }
            this.container.getLockingPolicy().lockRecordForRead(this.init_rawtran, this.container, rowPosition.current_rh, true, this.forUpdate);
            if (bl) {
                if (this.latchPageAndRepositionScan(rowPosition) && rowPosition.current_slot != -1) {
                    rowPosition.positionAtNextSlot();
                    this.lockPositionForRead(rowPosition, rowPosition2, true, true);
                }
            } else {
                this.latchPage(rowPosition);
            }
        }
        return bl3;
    }

    public boolean lockPositionForWrite(RowPosition rowPosition, boolean bl) throws StandardException {
        boolean bl2;
        if (rowPosition.current_rh == null) {
            rowPosition.current_rh = rowPosition.current_page.fetchFromSlot(null, rowPosition.current_slot, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true);
        }
        if (!(bl2 = this.container.getLockingPolicy().lockRecordForWrite(this.init_rawtran, rowPosition.current_rh, false, false))) {
            rowPosition.current_page.unlatch();
            rowPosition.current_page = null;
            if (!bl) {
                throw StandardException.newException("40XL1");
            }
            this.container.getLockingPolicy().lockRecordForWrite(this.init_rawtran, rowPosition.current_rh, false, true);
            this.latchPage(rowPosition);
        }
        return bl2;
    }

    public void unlockPositionAfterRead(RowPosition rowPosition) throws StandardException {
        if (!this.isClosed()) {
            this.container.getLockingPolicy().unlockRecordAfterRead(this.init_rawtran, this.container, rowPosition.current_rh, this.forUpdate, rowPosition.current_rh_qualified);
        }
    }

    public Properties getInternalTablePropertySet(Properties properties) throws StandardException {
        Properties properties2 = ConglomerateUtil.createRawStorePropertySet(properties);
        this.getTableProperties(properties2);
        return properties2;
    }

    public void getTableProperties(Properties properties) throws StandardException {
        this.container.getContainerProperties(properties);
    }

    public final TransactionManager getXactMgr() {
        return this.init_xact_manager;
    }

    public final Transaction getRawTran() {
        return this.init_rawtran;
    }

    public final ContainerHandle getContainer() {
        return this.container;
    }

    public final int getOpenMode() {
        return this.init_openmode;
    }

    public final Conglomerate getConglomerate() {
        return this.init_conglomerate;
    }

    public final boolean getHold() {
        return this.init_hold;
    }

    public final boolean isForUpdate() {
        return this.forUpdate;
    }

    public final boolean isClosed() {
        return this.container == null;
    }

    public final boolean isUseUpdateLocks() {
        return this.useUpdateLocks;
    }

    public final OpenConglomerateScratchSpace getRuntimeMem() {
        return this.runtime_mem;
    }

    public void checkConsistency() throws StandardException {
    }

    public void debugConglomerate() throws StandardException {
    }

    public SpaceInfo getSpaceInfo() throws StandardException {
        return this.container.getSpaceInfo();
    }

    protected boolean isKeyed() {
        return false;
    }

    protected boolean isTableLocked() {
        return this.init_lock_level == 7;
    }

    public ContainerHandle init(ContainerHandle containerHandle, Conglomerate conglomerate, int[] nArray, int[] nArray2, TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, LockingPolicy lockingPolicy, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        this.init_conglomerate = conglomerate;
        this.init_xact_manager = transactionManager;
        this.init_rawtran = transaction;
        this.init_openmode = n;
        this.init_lock_level = n2;
        this.init_dynamic_info = dynamicCompiledOpenConglomInfo;
        this.init_hold = bl;
        this.init_locking_policy = lockingPolicy;
        this.runtime_mem = dynamicCompiledOpenConglomInfo != null ? (OpenConglomerateScratchSpace)dynamicCompiledOpenConglomInfo : new OpenConglomerateScratchSpace(nArray, nArray2);
        this.forUpdate = (n & 4) != 0;
        this.useUpdateLocks = (n & 0x1000) != 0;
        boolean bl2 = this.getBaseTableLocks = (n & 0x2000) == 0;
        if (conglomerate.isTemporary()) {
            this.init_openmode |= 0x800;
        }
        if (!this.getBaseTableLocks) {
            this.init_locking_policy = null;
        }
        this.container = containerHandle != null ? containerHandle : transaction.openContainer(conglomerate.getId(), this.init_locking_policy, this.init_openmode);
        return this.container;
    }

    public ContainerHandle reopen() throws StandardException {
        if (this.container == null) {
            this.container = this.init_rawtran.openContainer(this.init_conglomerate.getId(), this.init_locking_policy, this.init_openmode);
        }
        return this.container;
    }

    public void close() throws StandardException {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
    }
}

