/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkAction
extends Action {
    Image img;
    String path = "";
    String target = "";

    LinkAction(Image image, String[] tokens) {
        super(8, tokens);
        this.img = image;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].startsWith("target=")) {
                this.target = tokens[i].substring(7);
                continue;
            }
            if (!tokens[i].startsWith("path=")) continue;
            this.path = tokens[i].substring(5);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    void install(Action orig) throws IOException {
        if (isPosix) {
            File f = new File(this.img.getRootDirectory(), this.path);
            if (f.exists()) {
                f.delete();
            }
            String[] cmd = new String[]{"/bin/ln", "-fs", this.target, f.getCanonicalPath()};
            try {
                Process p = Runtime.getRuntime().exec(cmd, null, this.img.getRootDirectory());
                p.waitFor();
                if (p.exitValue() != 0) {
                    throw new Error("/bin/ln -fs failed");
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    @Override
    void remove() throws IOException {
        File f = new File(this.img.getRootDirectory(), this.path);
        this.setPermissions(f, "0644");
        f.delete();
    }

    @Override
    String keyValue() {
        return this.path;
    }

    public String toString() {
        return "link: path=" + this.path;
    }

    @Override
    boolean isDifferent(Action a) {
        if (!(a instanceof LinkAction)) {
            return true;
        }
        LinkAction la = (LinkAction)a;
        return !this.equals(a) || !this.target.equals(la.target);
    }

    @Override
    List<String> getReferencedDirectories() {
        ArrayList<String> l = new ArrayList<String>();
        for (File parent = new File(this.path).getParentFile(); parent != null; parent = parent.getParentFile()) {
            l.add(parent.toString());
        }
        return l;
    }
}

