/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.FileList;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public final class LicenseAction
extends Action
implements FileList.DataSink {
    Image img;
    int size;
    String hash;
    String path;
    Fmri pi;
    String license = "";
    File gzipfile;

    LicenseAction(Image image, Fmri fmri, String[] tokens) {
        super(0, tokens);
        this.img = image;
        this.pi = fmri;
        this.hash = tokens[1];
        for (int i = 2; i < tokens.length; ++i) {
            if (tokens[i].startsWith("license=")) {
                this.license = tokens[i].substring(8);
                continue;
            }
            if (!tokens[i].startsWith("pkg.size=")) continue;
            this.size = Integer.parseInt(tokens[i].substring(9));
        }
        this.path = "license." + this.license;
    }

    void buildFileList(Action orig, FileList flist) {
        flist.add(this);
    }

    void install(Action orig) throws IOException {
        int n;
        if (this.gzipfile == null || this.license == null) {
            return;
        }
        File target = new File(this.pi.getPkgVersionDir(new File(this.img.getMetaDirectory(), "pkg")), this.path);
        target.delete();
        target.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(target);
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(this.gzipfile));
        byte[] buf = new byte[4096];
        while ((n = gis.read(buf)) > 0) {
            fos.write(buf, 0, n);
        }
        fos.close();
        gis.close();
        this.setPermissions(target, "0444");
    }

    String keyValue() {
        return this.license;
    }

    public String toString() {
        return "license: license=" + this.license;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof LicenseAction)) {
            return true;
        }
        LicenseAction la = (LicenseAction)a;
        return !this.equals(a) || !this.hash.equals(la.hash);
    }

    public String getHash() {
        return this.hash;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.license;
    }

    public String getText() throws IOException {
        String line;
        File target = new File(this.pi.getPkgVersionDir(new File(this.img.getMetaDirectory(), "pkg")), this.path);
        FileInputStream is = target.exists() ? new FileInputStream(target) : LicenseAction.getRemoteData(this.img, this.pi, this.hash);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "ISO-8859-1"));
        StringBuffer text = new StringBuffer();
        while ((line = r.readLine()) != null) {
            text.append(line).append("\n");
        }
        return text.toString();
    }

    public void setGzipFile(File f) {
        this.gzipfile = f;
    }
}

