/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.StrictUtf8;
import com.sun.grizzly.websockets.Utf8Utils;
import com.sun.grizzly.websockets.WebSocket;

public class DataFrame {
    private String payload;
    private byte[] bytes;
    private final FrameType type;
    private boolean last = true;

    public DataFrame(FrameType type2) {
        this.type = type2;
    }

    public DataFrame(FrameType type2, String data) {
        this(type2, data, true);
    }

    public DataFrame(FrameType type2, String data, boolean fin) {
        this.type = type2;
        this.setPayload(data);
        this.last = fin;
    }

    public DataFrame(FrameType type2, byte[] data) {
        this(type2, data, true);
    }

    public DataFrame(FrameType type2, byte[] data, boolean fin) {
        this.type = type2;
        type2.setPayload(this, data);
        this.last = fin;
    }

    public FrameType getType() {
        return this.type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public final void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        if (this.payload != null) {
            this.bytes = Utf8Utils.encode(new StrictUtf8(), this.payload);
        }
        return this.bytes;
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "last=" + this.last + ", type=" + this.type.getClass().getSimpleName() + ", payload='" + this.getTextPayload() + '\'' + '}';
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }
}

