/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.websockets.NetworkHandler;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseNetworkHandler
implements NetworkHandler {
    protected final ByteChunk chunk = new ByteChunk();

    protected abstract int read();

    @Override
    public byte[] readLine() throws IOException {
        int idx;
        if (this.chunk.getLength() <= 0) {
            this.read();
        }
        if ((idx = this.chunk.indexOf('\n', 0)) != -1) {
            int eolBytes = 1;
            int offset = this.chunk.getOffset();
            if ((idx += offset) > offset && this.chunk.getBuffer()[idx - 1] == 13) {
                --idx;
                eolBytes = 2;
            }
            int size = idx - offset;
            byte[] result = new byte[size];
            this.chunk.substract(result, 0, size);
            this.chunk.setOffset(this.chunk.getOffset() + eolBytes);
            return result;
        }
        return null;
    }

    public List<String> getBytes() {
        return this.getByteList(this.chunk.getStart(), this.chunk.getEnd());
    }

    private List<String> getByteList(int start, int end) {
        return Utils.toHexStrings(this.chunk.getBytes(), start, end);
    }

    public String toString() {
        return String.format("Active: %s", this.getBytes().toString());
    }
}

