/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.portunif.DefaultFilterChainProtocolHandler;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import javax.net.ssl.SSLEngine;

public class WebProtocolHandler
extends DefaultFilterChainProtocolHandler {
    private final String[] protocols;
    private final boolean isStickyMapping;

    public WebProtocolHandler(String protocolName, boolean isStickyMapping) {
        this.protocols = new String[]{protocolName};
        this.isStickyMapping = isStickyMapping;
    }

    public boolean handle(Context context, PUProtocolRequest protocolRequest) throws IOException {
        protocolRequest.setMapSelectionKey(this.isStickyMapping);
        protocolRequest.setExecuteFilterChain(true);
        return true;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }

    public ByteBuffer getByteBuffer() {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        if (sslEngine != null) {
            ByteBuffer secureInputBuffer = workerThread.getInputBB();
            if (secureInputBuffer == null) {
                int securedBBSize = sslEngine.getSession().getPacketBufferSize();
                secureInputBuffer = ByteBuffer.allocate(securedBBSize * 2);
                workerThread.setInputBB(secureInputBuffer);
            }
            return secureInputBuffer;
        }
        return null;
    }
}

