/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.config.GrizzlyEmbeddedHttps;
import com.sun.grizzly.config.SecurePasswordProvider;
import com.sun.grizzly.config.Utils;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.ServerSocketFactory;
import com.sun.hk2.component.Holder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLConfigHolder {
    private static final String PLAIN_PASSWORD_PROVIDER_NAME = "plain";
    private static final Logger LOGGER = GrizzlyEmbeddedHttps.logger();
    protected Holder<SSLImplementation> sslImplementation;
    protected SSLContext sslContext;
    protected String[] enabledCipherSuites = null;
    protected String[] enabledProtocols = null;
    protected boolean clientMode = false;
    protected boolean needClientAuth = false;
    protected boolean wantClientAuth = false;
    protected int sslInactivityTimeout = 30000;
    private final Ssl ssl;

    public SSLConfigHolder(Habitat habitat, Ssl ssl) throws SSLException {
        this.ssl = ssl;
        this.sslImplementation = habitat.getInhabitantByContract(SSLImplementation.class.getName(), ssl.getClassname());
        if (this.sslImplementation == null) {
            final SSLImplementation impl = SSLConfigHolder.lookupSSLImplementation(habitat, ssl);
            if (impl == null) {
                throw new SSLException("Can not configure SSLImplementation");
            }
            this.sslImplementation = new Holder<SSLImplementation>(){

                @Override
                public SSLImplementation get() {
                    return impl;
                }
            };
        }
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation.get();
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public int getSslInactivityTimeout() {
        return this.sslInactivityTimeout;
    }

    public SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "newSSLEngine: {0}", sslEngine);
        }
        if (this.enabledCipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        if (this.wantClientAuth) {
            sslEngine.setWantClientAuth(this.wantClientAuth);
        }
        if (this.needClientAuth) {
            sslEngine.setNeedClientAuth(this.needClientAuth);
        }
        return sslEngine;
    }

    public boolean configureSSL() {
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        try {
            this.initializeSSL();
            if (this.ssl != null) {
                String[] ciphers;
                String ssl2Ciphers;
                if (Boolean.parseBoolean(this.ssl.getClientAuthEnabled())) {
                    this.needClientAuth = true;
                }
                if (Boolean.parseBoolean(this.ssl.getSsl2Enabled())) {
                    tmpSSLArtifactsList.add("SSLv2");
                }
                if (Boolean.parseBoolean(this.ssl.getSsl3Enabled())) {
                    tmpSSLArtifactsList.add("SSLv3");
                }
                if (Boolean.parseBoolean(this.ssl.getTlsEnabled())) {
                    tmpSSLArtifactsList.add("TLSv1");
                }
                if (Boolean.parseBoolean(this.ssl.getSsl3Enabled()) || Boolean.parseBoolean(this.ssl.getTlsEnabled())) {
                    tmpSSLArtifactsList.add("SSLv2Hello");
                }
                if (tmpSSLArtifactsList.isEmpty()) {
                    this.logEmptyWarning(this.ssl, "WEB0307: All SSL protocol variants disabled for network-listener {0}, using SSL implementation specific defaults");
                } else {
                    this.enabledProtocols = this.filterSupportedProtocols(tmpSSLArtifactsList);
                }
                String auth = this.ssl.getClientAuth();
                if (auth != null) {
                    if ("want".equalsIgnoreCase(auth.trim())) {
                        this.wantClientAuth = true;
                    } else if ("need".equalsIgnoreCase(auth.trim())) {
                        this.needClientAuth = true;
                    }
                }
                this.sslInactivityTimeout = Integer.parseInt(this.ssl.getSSLInactivityTimeout()) * 1000;
                tmpSSLArtifactsList.clear();
                String ssl3Ciphers = this.ssl.getSsl3TlsCiphers();
                if (ssl3Ciphers != null && ssl3Ciphers.length() > 0) {
                    String[] ssl3CiphersArray;
                    for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                        tmpSSLArtifactsList.add(cipher.trim());
                    }
                }
                if ((ssl2Ciphers = this.ssl.getSsl2Ciphers()) != null && ssl2Ciphers.length() > 0) {
                    String[] ssl2CiphersArray;
                    for (String cipher : ssl2CiphersArray = ssl2Ciphers.split(",")) {
                        tmpSSLArtifactsList.add(cipher.trim());
                    }
                }
                if ((ciphers = SSLConfigHolder.getJSSECiphers(tmpSSLArtifactsList)) == null || ciphers.length == 0) {
                    this.logEmptyWarning(this.ssl, "WEB0308: All SSL cipher suites disabled for network-listener(s) {0}.  Using SSL implementation specific defaults");
                } else {
                    this.enabledCipherSuites = ciphers;
                }
            }
            return true;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), e);
            }
            return false;
        }
    }

    protected void logEmptyWarning(Ssl ssl, String msg) {
        StringBuilder name = new StringBuilder();
        for (NetworkListener listener : ((Protocol)ssl.getParent()).findNetworkListeners()) {
            if (name.length() != 0) {
                name.append(", ");
            }
            name.append(listener.getName());
        }
        LOGGER.log(Level.FINE, msg, name.toString());
    }

    private void initializeSSL() throws Exception {
        SSLImplementation sslHelper = this.getSSLImplementation();
        ServerSocketFactory serverSF = sslHelper.getServerSocketFactory();
        if (this.ssl != null) {
            if (this.ssl.getCrlFile() != null) {
                SSLConfigHolder.setAttribute(serverSF, "crlFile", this.ssl.getCrlFile(), null, null);
            }
            if (this.ssl.getTrustAlgorithm() != null) {
                SSLConfigHolder.setAttribute(serverSF, "truststoreAlgorithm", this.ssl.getTrustAlgorithm(), null, null);
            }
            if (this.ssl.getKeyAlgorithm() != null) {
                SSLConfigHolder.setAttribute(serverSF, "algorithm", this.ssl.getKeyAlgorithm(), null, null);
            }
            SSLConfigHolder.setAttribute(serverSF, "trustMaxCertLength", this.ssl.getTrustMaxCertLength(), null, null);
        }
        SSLConfigHolder.setAttribute(serverSF, "keystore", this.ssl != null ? this.ssl.getKeyStore() : null, "javax.net.ssl.keyStore", null);
        SSLConfigHolder.setAttribute(serverSF, "keystoreType", this.ssl != null ? this.ssl.getKeyStoreType() : null, "javax.net.ssl.keyStoreType", "JKS");
        SSLConfigHolder.setAttribute(serverSF, "keystorePass", this.ssl != null ? SSLConfigHolder.getKeyStorePassword(this.ssl) : null, "javax.net.ssl.keyStorePassword", "changeit");
        SSLConfigHolder.setAttribute(serverSF, "truststore", this.ssl != null ? this.ssl.getTrustStore() : null, "javax.net.ssl.trustStore", null);
        SSLConfigHolder.setAttribute(serverSF, "truststoreType", this.ssl != null ? this.ssl.getTrustStoreType() : null, "javax.net.ssl.trustStoreType", "JKS");
        SSLConfigHolder.setAttribute(serverSF, "truststorePass", this.ssl != null ? SSLConfigHolder.getTrustStorePassword(this.ssl) : null, "javax.net.ssl.trustStorePassword", "changeit");
        serverSF.setAttribute("keyAlias", this.ssl != null ? this.ssl.getCertNickname() : null);
        serverSF.init();
        this.sslContext = serverSF.getSSLContext();
        CipherInfo.updateCiphers(this.sslContext);
    }

    public static boolean isAllowLazyInit(Ssl ssl) {
        return ssl == null || Boolean.parseBoolean(ssl.getAllowLazyInit());
    }

    private static void setAttribute(ServerSocketFactory serverSF, String name, String value, String property, String defaultValue) {
        serverSF.setAttribute(name, value == null ? System.getProperty(property, defaultValue) : value);
    }

    private static String getKeyStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getKeyStorePasswordProvider())) {
            return ssl.getKeyStorePassword();
        }
        return SSLConfigHolder.getStorePasswordCustom(ssl.getKeyStorePassword());
    }

    private static String getTrustStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getTrustStorePasswordProvider())) {
            return ssl.getTrustStorePassword();
        }
        return SSLConfigHolder.getStorePasswordCustom(ssl.getTrustStorePassword());
    }

    private static String getStorePasswordCustom(String storePasswordProvider) {
        block3: {
            try {
                SecurePasswordProvider provider = (SecurePasswordProvider)Utils.newInstance(storePasswordProvider);
                if (provider != null) {
                    return provider.getPassword();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_SECURE_PASSWORD_INITIALIZATION_ERROR(storePasswordProvider), e);
            }
        }
        return null;
    }

    private static SSLImplementation lookupSSLImplementation(Habitat habitat, Ssl ssl) {
        try {
            String sslImplClassName = ssl.getClassname();
            if (sslImplClassName != null) {
                SSLImplementation impl = Utils.newInstance(habitat, SSLImplementation.class, sslImplClassName, sslImplClassName);
                if (impl != null) {
                    return impl;
                }
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(LogMessages.WARNING_GRIZZLY_CONFIG_SSL_SSL_IMPLEMENTATION_LOAD_ERROR(sslImplClassName));
                }
                return SSLImplementation.getInstance();
            }
            return SSLImplementation.getInstance();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), e);
            }
            return null;
        }
    }

    private String[] filterSupportedProtocols(List<String> protocols) {
        if (protocols.isEmpty()) {
            return protocols.toArray(new String[0]);
        }
        SSLEngine engine = this.sslContext.createSSLEngine();
        Object[] supportedProtocols = engine.getSupportedProtocols();
        Arrays.sort(supportedProtocols);
        Iterator<String> i = protocols.iterator();
        while (i.hasNext()) {
            String protocol = i.next();
            if (Arrays.binarySearch(supportedProtocols, protocol) >= 0) continue;
            i.remove();
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Protocol {0}, not supported by current SSL implementation; ignoring.", protocol);
        }
        return protocols.toArray(new String[protocols.size()]);
    }

    private static String[] getJSSECiphers(List<String> configuredCiphers) {
        HashSet<String> enabledCiphers = null;
        for (String cipher : configuredCiphers) {
            String jsseCipher;
            if (cipher.length() <= 0 || cipher.charAt(0) == '-') continue;
            if (cipher.charAt(0) == '+') {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = SSLConfigHolder.getJSSECipher(cipher)) == null) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning(LogMessages.WARNING_GRIZZLY_CONFIG_SSL_UNKNOWN_CIPHER_ERROR(cipher));
                continue;
            }
            if (enabledCiphers == null) {
                enabledCiphers = new HashSet<String>(configuredCiphers.size());
            }
            enabledCiphers.add(jsseCipher);
        }
        return enabledCiphers == null ? null : enabledCiphers.toArray(new String[enabledCiphers.size()]);
    }

    private static String getJSSECipher(String cipher) {
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        return ci != null ? ci.getCipherName() : null;
    }

    private static final class CipherInfo {
        private static final short SSL2 = 1;
        private static final short SSL3 = 2;
        private static final short TLS = 4;
        private static final String[][] OLD_CIPHER_MAPPING = new String[][]{{"rsa_null_md5", "SSL_RSA_WITH_NULL_MD5"}, {"rsa_null_sha", "SSL_RSA_WITH_NULL_SHA"}, {"rsa_rc4_40_md5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"rsa_rc4_128_md5", "SSL_RSA_WITH_RC4_128_MD5"}, {"rsa_rc4_128_sha", "SSL_RSA_WITH_RC4_128_SHA"}, {"rsa_3des_sha", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"fips_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_MD5"}, {"SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_SHA"}};
        private static final Map<String, CipherInfo> ciphers = new HashMap<String, CipherInfo>();
        private static final ReadWriteLock ciphersLock = new ReentrantReadWriteLock();
        private final String configName;
        private final String cipherName;
        private final short protocolVersion;

        private CipherInfo(String configName, String cipherName, short protocolVersion) {
            this.configName = configName;
            this.cipherName = cipherName;
            this.protocolVersion = protocolVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateCiphers(SSLContext sslContext) {
            SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
            String[] supportedCiphers = factory.getDefaultCipherSuites();
            ciphersLock.writeLock().lock();
            try {
                for (String s : supportedCiphers) {
                    ciphers.put(s, new CipherInfo(s, s, 6));
                }
            }
            finally {
                ciphersLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CipherInfo getCipherInfo(String configName) {
            ciphersLock.readLock().lock();
            try {
                CipherInfo cipherInfo = ciphers.get(configName);
                return cipherInfo;
            }
            finally {
                ciphersLock.readLock().unlock();
            }
        }

        public String getCipherName() {
            return this.cipherName;
        }

        public boolean isSSL2() {
            return (this.protocolVersion & 1) == 1;
        }

        public boolean isSSL3() {
            return (this.protocolVersion & 2) == 2;
        }

        public boolean isTLS() {
            return (this.protocolVersion & 4) == 4;
        }

        static {
            int len = OLD_CIPHER_MAPPING.length;
            for (int i = 0; i < len; ++i) {
                String nonStdName = OLD_CIPHER_MAPPING[i][0];
                String stdName = OLD_CIPHER_MAPPING[i][1];
                ciphers.put(nonStdName, new CipherInfo(nonStdName, stdName, 6));
            }
        }
    }
}

