/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.config.ConfigAwareElement;
import com.sun.grizzly.config.dom.HttpRedirect;
import com.sun.grizzly.http.portunif.HttpRedirector;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import javax.net.ssl.SSLEngine;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class HttpRedirectFilter
implements ProtocolFilter,
ConfigAwareElement {
    private Integer redirectPort;
    private Boolean secure;

    public boolean execute(Context ctx) throws IOException {
        Utils.Result result;
        boolean redirectToSecure;
        WorkerThread thread = (WorkerThread)Thread.currentThread();
        SSLEngine sslEngine = thread.getSSLEngine();
        if (this.secure != null) {
            redirectToSecure = this.secure;
        } else {
            boolean bl = redirectToSecure = sslEngine == null;
        }
        if (sslEngine != null) {
            HttpRedirector.redirectSSL(ctx, sslEngine, thread.getByteBuffer(), thread.getOutputBB(), this.redirectPort, redirectToSecure);
        } else {
            HttpRedirector.redirect(ctx, thread.getByteBuffer(), this.redirectPort, redirectToSecure);
        }
        SelectableChannel channel = ctx.getSelectionKey().channel();
        ByteBuffer bb = thread.getByteBuffer();
        bb.clear();
        int totalBytesRead = 0;
        do {
            result = null;
            try {
                result = Utils.readWithTemporarySelector(channel, bb, 20L);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            bb.clear();
            if (result != null && !result.isClosed && result.bytesRead > 0) continue;
            return true;
        } while ((totalBytesRead += result.bytesRead) <= 4096);
        return true;
    }

    public boolean postExecute(Context ctx) throws IOException {
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
        return true;
    }

    public void configure(Habitat habitat, ConfigBeanProxy configuration) {
        if (configuration instanceof HttpRedirect) {
            HttpRedirect httpRedirectConfig = (HttpRedirect)configuration;
            int port = Integer.parseInt(httpRedirectConfig.getPort());
            this.redirectPort = port != -1 ? Integer.valueOf(port) : null;
            this.secure = Boolean.parseBoolean(httpRedirectConfig.getSecure());
        }
    }
}

