/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.StatsProvider;
import com.sun.grizzly.http.KeepAliveStats;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="keep-alive-mon", group="monitoring")
@ManagedObject
@Description(value="Keep-Alive Statistics")
public class KeepAliveStatsProvider
implements StatsProvider {
    private final String name;
    protected final CountStatisticImpl maxRequestsCount = new CountStatisticImpl("MaxRequests", "count", "Maximum number of requests allowed on a single keep-alive connection");
    protected final CountStatisticImpl timeoutInSeconds = new CountStatisticImpl("SecondsTimeouts", "seconds", "Keep-alive timeout value in seconds");
    protected final CountStatisticImpl keepAliveConnectionsCount = new CountStatisticImpl("CountConnections", "count", "Number of connections in keep-alive mode");
    protected final CountStatisticImpl flushesCount = new CountStatisticImpl("CountFlushes", "count", "Number of keep-alive connections that were closed");
    protected final CountStatisticImpl hitsCount = new CountStatisticImpl("CountHits", "count", "Number of requests received by connections in keep-alive mode");
    protected final CountStatisticImpl refusalsCount = new CountStatisticImpl("CountRefusals", "count", "Number of keep-alive connections that were rejected");
    protected final CountStatisticImpl timeoutsCount = new CountStatisticImpl("CountTimeouts", "count", "Number of keep-alive connections that timed out");
    protected volatile KeepAliveStats keepAliveStats;

    public KeepAliveStatsProvider(String name) {
        this.name = name;
    }

    public Object getStatsObject() {
        return this.keepAliveStats;
    }

    public void setStatsObject(Object object) {
        this.keepAliveStats = object instanceof KeepAliveStats ? (KeepAliveStats)object : null;
    }

    @ManagedAttribute(id="maxrequests")
    @Description(value="Maximum number of requests allowed on a single keep-alive connection")
    public CountStatistic getMaxKeepAliveRequestsCount() {
        return this.maxRequestsCount;
    }

    @ManagedAttribute(id="secondstimeouts")
    @Description(value="Keep-alive timeout value in seconds")
    public CountStatistic getKeepAliveTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    @ManagedAttribute(id="countconnections")
    @Description(value="Number of connections in keep-alive mode")
    public CountStatistic getKeepAliveConnectionsCount() {
        return this.keepAliveConnectionsCount;
    }

    @ManagedAttribute(id="countflushes")
    @Description(value="Number of keep-alive connections that were closed")
    public CountStatistic getFlushesCount() {
        return this.flushesCount;
    }

    @ManagedAttribute(id="counthits")
    @Description(value="Number of requests received by connections in keep-alive mode")
    public CountStatistic getHitsCount() {
        return this.hitsCount;
    }

    @ManagedAttribute(id="countrefusals")
    @Description(value="Number of keep-alive connections that were rejected")
    public CountStatistic getRefusalsCount() {
        return this.refusalsCount;
    }

    @ManagedAttribute(id="counttimeouts")
    @Description(value="Number of keep-alive connections that timed out")
    public CountStatistic getTimeoutsCount() {
        return this.timeoutsCount;
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:setMaxCountRequestsEvent")
    public void setMaxCountRequestsEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="maxRequests") int max) {
        if (this.name.equals(listenerName)) {
            this.maxRequestsCount.setCount(max);
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:setTimeoutInSecondsEvent")
    public void setTimeoutInSecondsEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="timeoutInSeconds") int timeoutInSeconds) {
        if (this.name.equals(listenerName)) {
            this.timeoutInSeconds.setCount(timeoutInSeconds);
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountConnectionsEvent")
    public void incrementCountConnectionsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.keepAliveConnectionsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:decrementCountConnectionsEvent")
    public void decrementCountConnectionsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.keepAliveConnectionsCount.decrement();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountFlushesEvent")
    public void incrementCountFlushesEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.flushesCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountHitsEvent")
    public void incrementCountHitsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.hitsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountRefusalsEvent")
    public void incrementCountRefusalsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.refusalsCount.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:connections-keep-alive:incrementCountTimeoutsEvent")
    public void incrementCountTimeoutsEvent(@ProbeParam(value="listenerName") String listenerName) {
        if (this.name.equals(listenerName)) {
            this.timeoutsCount.increment();
        }
    }

    @Reset
    public void reset() {
        KeepAliveStats stats = this.keepAliveStats;
        if (stats != null) {
            this.maxRequestsCount.setCount(stats.getMaxKeepAliveRequests());
            this.timeoutInSeconds.setCount(stats.getKeepAliveTimeoutInSeconds());
        }
        this.keepAliveConnectionsCount.setCount(0L);
        this.flushesCount.setCount(0L);
        this.hitsCount.setCount(0L);
        this.refusalsCount.setCount(0L);
        this.timeoutsCount.setCount(0L);
    }
}

