/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.v3.server.HK2Dispatcher;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.enterprise.v3.services.impl.SnifferAdapter;
import com.sun.grizzly.config.ContextRootInfo;
import com.sun.grizzly.config.FileCacheAware;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.MimeType;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.internal.grizzly.V3Mapper;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerMapper
extends StaticResourcesAdapter
implements FileCacheAware {
    private static final String ROOT = "";
    private Mapper mapper;
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    private UDecoder urlDecoder;
    private String defaultHostName = "server";
    private final Habitat habitat;
    private final GrizzlyService grizzlyService;
    protected static final int MAPPING_DATA = 12;
    protected static final int MAPPED_ADAPTER = 13;
    private final ReentrantReadWriteLock mapperLock;
    private static final int MESSAGE_BYTES = 17;
    private final HK2Dispatcher hk2Dispatcher = new HK2Dispatcher();
    private String version;
    private boolean mapMultipleAdapter = false;

    public ContainerMapper(GrizzlyService service, NetworkListener networkListener) {
        this.grizzlyService = service;
        this.mapperLock = service.obtainMapperLock(networkListener.getName());
        this.habitat = service.habitat;
        this.logger = GrizzlyEmbeddedHttp.logger();
        this.version = System.getProperty("product.name");
        if (this.version == null) {
            this.version = Version.getVersion();
        }
    }

    public void setEmbeddedHttp(GrizzlyEmbeddedHttp embeddedHttp) {
        this.grizzlyEmbeddedHttp = embeddedHttp;
        this.urlDecoder = embeddedHttp.getUrlDecoder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultHost(String defaultHost) {
        this.mapperLock.writeLock().lock();
        try {
            this.defaultHostName = defaultHost;
        }
        finally {
            this.mapperLock.writeLock().unlock();
        }
    }

    protected void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureMapper() {
        this.mapperLock.writeLock().lock();
        try {
            this.mapper.setDefaultHostName(this.defaultHostName);
            this.mapper.addHost(this.defaultHostName, new String[0], null);
            this.mapper.addContext(this.defaultHostName, ROOT, new ContextRootInfo(this, null), new String[]{"index.html", "index.htm"}, null);
            Mapper.setAllowReplacement(true);
        }
        finally {
            this.mapperLock.writeLock().unlock();
        }
    }

    @Override
    public void service(Request req, Response res) throws Exception {
        block6: {
            long transactionTimeout = this.grizzlyEmbeddedHttp.getTransactionTimeout();
            if (transactionTimeout < 0L) {
                transactionTimeout = Long.MAX_VALUE;
            }
            this.grizzlyService.getServerReadyFuture().get(transactionTimeout, TimeUnit.MILLISECONDS);
            try {
                Callable handler = this.lookupHandler(req, res);
                handler.call();
            }
            catch (Exception ex) {
                try {
                    res.setStatus(500);
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "Internal Server error: " + req.decodedURI(), ex);
                    }
                    this.customizedErrorPage(req, res);
                }
                catch (Exception ex2) {
                    if (!this.logger.isLoggable(Level.WARNING)) break block6;
                    this.logger.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callable lookupHandler(Request req, Response res) throws Exception {
        this.mapperLock.readLock().lock();
        try {
            Object type2;
            Object ext;
            if (!this.mapMultipleAdapter && this.mapper instanceof V3Mapper) {
                req.setNote(12, null);
                Adapter a = ((V3Mapper)this.mapper).getAdapter();
                if (a != null) {
                    req.setNote(13, a);
                    AdapterCallable adapterCallable = new AdapterCallable(a, req, res);
                    return adapterCallable;
                }
            }
            MessageBytes decodedURI = req.decodedURI();
            decodedURI.duplicate(req.requestURI());
            MappingData mappingData = (MappingData)req.getNote(12);
            if (mappingData == null) {
                mappingData = new MappingData();
                req.setNote(12, mappingData);
            }
            String uriEncoding = (String)this.grizzlyEmbeddedHttp.getProperty("uriEncoding");
            HttpRequestURIDecoder.decode(decodedURI, this.urlDecoder, uriEncoding, null);
            CharChunk decodedURICC = decodedURI.getCharChunk();
            int semicolon = decodedURICC.indexOf(';', 0);
            Adapter adapter = this.mapUriWithSemicolon(req, decodedURI, semicolon, mappingData);
            if (adapter == null || adapter instanceof ContainerMapper) {
                ext = decodedURI.toString();
                type2 = ROOT;
                if (((String)ext).indexOf(".") > 0) {
                    ext = "*" + ((String)ext).substring(((String)ext).lastIndexOf("."));
                    type2 = ((String)ext).substring(((String)ext).lastIndexOf(".") + 1);
                }
                if (!MimeType.contains((String)type2) && !((String)ext).equals("/")) {
                    this.initializeFileURLPattern((String)ext);
                    mappingData.recycle();
                    adapter = this.mapUriWithSemicolon(req, decodedURI, semicolon, mappingData);
                } else {
                    SuperCallable superCallable = new SuperCallable(req, res);
                    return superCallable;
                }
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Request: {0} was mapped to Adapter: {1}", new Object[]{decodedURI.toString(), adapter});
            }
            if (adapter == null || adapter instanceof ContainerMapper) {
                ext = new SuperCallable(req, res);
                return ext;
            }
            req.setNote(13, adapter);
            ContextRootInfo contextRootInfo = null;
            if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
                contextRootInfo = (ContextRootInfo)mappingData.context;
            }
            if (contextRootInfo == null) {
                type2 = new AdapterCallable(adapter, req, res);
                return type2;
            }
            ClassLoader cl = null;
            if (contextRootInfo.getContainer() instanceof ApplicationContainer) {
                cl = ((ApplicationContainer)contextRootInfo.getContainer()).getClassLoader();
            }
            Hk2DispatcherCallable hk2DispatcherCallable = new Hk2DispatcherCallable(adapter, cl, req, res);
            return hk2DispatcherCallable;
        }
        finally {
            this.mapperLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFileURLPattern(String ext) {
        for (Sniffer sniffer : this.grizzlyService.habitat.getAllByContract(Sniffer.class)) {
            boolean match = false;
            if (sniffer.getURLPatterns() == null) continue;
            for (String pattern : sniffer.getURLPatterns()) {
                if (!pattern.equalsIgnoreCase(ext)) continue;
                match = true;
                break;
            }
            Adapter adapter = this;
            if (!match) continue;
            adapter = this.grizzlyService.habitat.getComponent(SnifferAdapter.class);
            ((SnifferAdapter)adapter).initialize(sniffer, this);
            ContextRootInfo c = new ContextRootInfo(adapter, null);
            this.mapperLock.readLock().unlock();
            this.mapperLock.writeLock().lock();
            try {
                for (String pattern : sniffer.getURLPatterns()) {
                    for (String host : this.grizzlyService.hosts) {
                        this.mapper.addWrapper(host, ROOT, pattern, c, "*.jsp".equals(pattern) || "*.jspx".equals(pattern));
                    }
                }
            }
            finally {
                this.mapperLock.writeLock().unlock();
                this.mapperLock.readLock().lock();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Adapter mapUriWithSemicolon(Request req, MessageBytes decodedURI, int semicolonPos, MappingData mappingData) throws Exception {
        this.mapperLock.readLock().lock();
        try {
            CharChunk charChunk = decodedURI.getCharChunk();
            int oldEnd = charChunk.getEnd();
            if (semicolonPos == 0) {
                semicolonPos = decodedURI.indexOf(';');
            }
            MessageBytes localDecodedURI = decodedURI;
            if (semicolonPos >= 0) {
                charChunk.setEnd(semicolonPos);
                localDecodedURI = (MessageBytes)req.getNote(17);
                if (localDecodedURI == null) {
                    localDecodedURI = MessageBytes.newInstance();
                    req.setNote(17, localDecodedURI);
                }
                localDecodedURI.duplicate(decodedURI);
            }
            try {
                Adapter adapter = this.map(req, localDecodedURI, mappingData);
                charChunk.setEnd(oldEnd);
                return adapter;
            }
            catch (Throwable throwable) {
                charChunk.setEnd(oldEnd);
                throw throwable;
            }
        }
        finally {
            this.mapperLock.readLock().unlock();
        }
    }

    Adapter map(Request req, MessageBytes decodedURI, MappingData mappingData) throws Exception {
        if (mappingData == null) {
            mappingData = (MappingData)req.getNote(12);
        }
        this.mapper.map(req.serverName(), decodedURI, mappingData);
        ContextRootInfo contextRootInfo = null;
        if (mappingData.context != null && (mappingData.context instanceof ContextRootInfo || mappingData.wrapper instanceof ContextRootInfo)) {
            contextRootInfo = mappingData.wrapper != null ? (ContextRootInfo)mappingData.wrapper : (ContextRootInfo)mappingData.context;
            return contextRootInfo.getAdapter();
        }
        if (mappingData.context != null && mappingData.context.getClass().getName().equals("com.sun.enterprise.web.WebModule")) {
            return ((V3Mapper)this.mapper).getAdapter();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterService(Request req, Response res) throws Exception {
        MappingData mappingData = (MappingData)req.getNote(12);
        try {
            Adapter adapter = (Adapter)req.getNote(13);
            if (adapter != null) {
                adapter.afterService(req, res);
            }
            super.afterService(req, res);
        }
        finally {
            req.setNote(13, null);
            if (mappingData != null) {
                mappingData.recycle();
            }
        }
    }

    @Override
    protected void customizedErrorPage(Request req, Response res) throws Exception {
        byte[] errorBody = null;
        errorBody = res.getStatus() == 404 ? HttpUtils.getErrorPage(Version.getVersion(), "The requested resource () is not available.", "404") : HttpUtils.getErrorPage(Version.getVersion(), "Internal Error", "500");
        ByteChunk chunk = new ByteChunk();
        chunk.setBytes(errorBody, 0, errorBody.length);
        res.setContentLength(errorBody.length);
        res.setContentType("text/html");
        if (!this.version.isEmpty()) {
            res.addHeader("Server", this.version);
        }
        res.sendHeaders();
        res.doWrite(chunk);
    }

    public void register(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "MAPPER({0}) REGISTER contextRoot: {1} adapter: {2} container: {3} port: {4}", new Object[]{this, contextRoot, adapter, container, this.grizzlyEmbeddedHttp.getPort()});
        }
        if (adapter.getClass().getName().equals("org.apache.catalina.connector.CoyoteAdapter")) {
            return;
        }
        this.mapMultipleAdapter = true;
        String ctx = this.getContextPath(contextRoot);
        String wrapper = this.getWrapperPath(ctx, contextRoot);
        ContextRootInfo c = new ContextRootInfo(adapter, container);
        for (String host : vs) {
            this.mapper.addContext(host, contextRoot, c, new String[0], null);
            if (!(adapter instanceof StaticResourcesAdapter)) continue;
            this.mapper.addWrapper(host, ctx, wrapper, c);
        }
    }

    private String getWrapperPath(String ctx, String mapping) {
        if (mapping.indexOf("*.") > 0) {
            return mapping.substring(mapping.lastIndexOf("/") + 1);
        }
        if (!ctx.equals(ROOT)) {
            return mapping.substring(ctx.length());
        }
        return mapping;
    }

    private String getContextPath(String mapping) {
        String ctx = ROOT;
        int slash = mapping.indexOf("/", 1);
        ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*.") || ctx.startsWith("*.")) {
            ctx = ctx.indexOf("/") == ctx.lastIndexOf("/") ? ROOT : ctx.substring(1);
        }
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = ROOT;
        }
        if (ctx.equals("/")) {
            ctx = ROOT;
        }
        return ctx;
    }

    public void unregister(String contextRoot) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "MAPPER ({0}) UNREGISTER contextRoot: {1}", new Object[]{this, contextRoot});
        }
        for (String host : this.grizzlyService.hosts) {
            this.mapper.removeContext(host, contextRoot);
        }
    }

    private final class Hk2DispatcherCallable
    implements Callable {
        final Adapter adapter;
        final ClassLoader classloader;
        final Request req;
        final Response res;

        public Hk2DispatcherCallable(Adapter adapter, ClassLoader classloader, Request req, Response res) {
            this.adapter = adapter;
            this.classloader = classloader;
            this.req = req;
            this.res = res;
        }

        public Object call() throws Exception {
            ContainerMapper.this.hk2Dispatcher.dispath(this.adapter, this.classloader, this.req, this.res);
            return null;
        }
    }

    private final class SuperCallable
    implements Callable {
        final Request req;
        final Response res;

        public SuperCallable(Request req, Response res) {
            this.req = req;
            this.res = res;
        }

        public Object call() throws Exception {
            ContainerMapper.super.service(this.req, this.res);
            return null;
        }
    }

    private static final class AdapterCallable
    implements Callable {
        final Adapter adapter;
        final Request req;
        final Response res;

        public AdapterCallable(Adapter a, Request req, Response res) {
            this.adapter = a;
            this.req = req;
            this.res = res;
        }

        public Object call() throws Exception {
            this.adapter.service(this.req, this.res);
            return null;
        }
    }
}

