/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeArchive
extends AbstractReadableArchive {
    final ReadableArchive delegate;
    final CompositeHandler filter;

    public CompositeArchive(ReadableArchive delegate, CompositeHandler filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public InputStream getEntry(String name) throws IOException {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.getEntry(name);
        }
        return null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.exists(name);
        }
        return false;
    }

    @Override
    public long getEntrySize(String name) {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.getEntrySize(name);
        }
        return 0L;
    }

    @Override
    public void open(URI uri) throws IOException {
        this.delegate.open(uri);
    }

    @Override
    public ReadableArchive getSubArchive(String name) throws IOException {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.getSubArchive(name);
        }
        return null;
    }

    @Override
    public boolean exists() {
        return this.delegate.exists();
    }

    @Override
    public boolean delete() {
        return this.delegate.delete();
    }

    @Override
    public boolean renameTo(String name) {
        return this.delegate.renameTo(name);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public Enumeration<String> entries() {
        Enumeration<String> original = this.delegate.entries();
        Vector<String> results = new Vector<String>();
        while (original.hasMoreElements()) {
            String entryName = original.nextElement();
            if (!this.filter.accept(this.delegate, entryName)) continue;
            results.add(entryName);
        }
        return results.elements();
    }

    @Override
    public Enumeration<String> entries(String prefix) {
        Enumeration<String> original = this.delegate.entries(prefix);
        Vector<String> results = new Vector<String>();
        while (original.hasMoreElements()) {
            String entryName = original.nextElement();
            if (!this.filter.accept(this.delegate, entryName)) continue;
            results.add(entryName);
        }
        return results.elements();
    }

    @Override
    public boolean isDirectory(String name) {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.isDirectory(name);
        }
        return false;
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.delegate.getManifest();
    }

    @Override
    public URI getURI() {
        return this.delegate.getURI();
    }

    @Override
    public long getArchiveSize() throws SecurityException {
        return this.delegate.getArchiveSize();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public Collection<String> getDirectories() throws IOException {
        return this.delegate.getDirectories();
    }
}

