/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.cluster.ClusterCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@I18n(value="stop.cluster.command")
@Service(name="stop-cluster")
@Scoped(value=PerLookup.class)
public class StopClusterCommand
implements AdminCommand {
    @Param(optional=false, primary=true)
    private String clusterName;
    @Param(optional=true, obsolete=true)
    private boolean autohadboverride = false;
    @Param(optional=true, defaultValue="false")
    private boolean kill = false;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        logger.info(Strings.get("stop.cluster", this.clusterName));
        if (!this.env.isDas()) {
            String msg = Strings.get("cluster.command.notDas");
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        ClusterCommandHelper clusterHelper = new ClusterCommandHelper(this.domain, this.runner);
        ParameterMap map = null;
        if (this.kill) {
            map = new ParameterMap();
            map.add("kill", "true");
        }
        try {
            String commandName = "stop-instance";
            clusterHelper.runCommand(commandName, map, this.clusterName, context, this.verbose);
        }
        catch (CommandException e) {
            String msg = e.getLocalizedMessage();
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
    }
}

