/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=PerLookup.class)
public class NodeAgentConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Domain domain;
    @Inject
    Servers servers;

    public void postConstruct() {
        NodeAgents nodeAgents = this.domain.getNodeAgents();
        if (nodeAgents == null) {
            if (this.domain.getNodes() == null) {
                this.createDefaultNodeList();
            }
            return;
        }
        final List<NodeAgent> agList = nodeAgents.getNodeAgent();
        if (agList.size() == 0) {
            this.createDefaultNodeList();
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Domain>(){

                @Override
                public Object run(Domain d) throws PropertyVetoException, TransactionFailure {
                    Nodes nodes = d.createChild(Nodes.class);
                    Transaction t = Transaction.getTransaction(d);
                    if (t == null) {
                        return null;
                    }
                    for (NodeAgent na : agList) {
                        Object host = null;
                        Node node = nodes.createChild(Node.class);
                        node.setName(na.getName());
                        node.setType("CONFIG");
                        JmxConnector jc = na.getJmxConnector();
                        if (jc != null) {
                            List<Property> agentProp = jc.getProperty();
                            for (Property p : agentProp) {
                                String name = p.getName();
                                if (!name.equals("client-hostname")) continue;
                                node.setNodeHost(p.getValue());
                                node.setInstallDir("${com.sun.aas.productRoot}");
                            }
                        }
                        nodes.getNode().add(node);
                    }
                    NodeAgentConfigUpgrade.this.createDefaultNode(d, nodes);
                    d.setNodes(nodes);
                    List<Server> serverList = NodeAgentConfigUpgrade.this.servers.getServer();
                    if (serverList.size() <= 0) {
                        return null;
                    }
                    for (Server s : serverList) {
                        s = t.enroll(s);
                        s.setNodeRef(s.getNodeAgentRef());
                        s.setNodeAgentRef(null);
                    }
                    d.setNodeAgents(null);
                    return null;
                }
            }, this.domain);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading node-agent from V2 to V3", e);
            throw new RuntimeException(e);
        }
    }

    private void createDefaultNodeList() {
        try {
            ConfigSupport.apply(new SingleConfigCode<Domain>(){

                @Override
                public Object run(Domain d) throws PropertyVetoException, TransactionFailure {
                    Nodes nodes = d.createChild(Nodes.class);
                    Transaction t = Transaction.getTransaction(d);
                    if (t == null) {
                        return null;
                    }
                    NodeAgentConfigUpgrade.this.createDefaultNode(d, nodes);
                    d.setNodes(nodes);
                    return null;
                }
            }, this.domain);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while creating default localhost node during V2 to V3 upgrade.", e);
            throw new RuntimeException(e);
        }
    }

    private void createDefaultNode(Domain d, Nodes nodes) throws TransactionFailure, PropertyVetoException {
        Property domainProp = d.getProperty("administrative.domain.name");
        String domainName = domainProp.getValue();
        Node node = nodes.createChild(Node.class);
        node.setName("localhost-" + domainName);
        node.setType("CONFIG");
        node.setNodeHost("localhost");
        node.setInstallDir("${com.sun.aas.productRoot}");
        nodes.getNode().add(node);
    }
}

