/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ProfilerImpl {
    Item currItem = null;
    List<Item> items = new ArrayList<Item>();
    int numBegins = 0;
    int numEnds = 0;
    int numActualEnds = 0;

    public void reset() {
        this.currItem = null;
        this.items.clear();
        this.numBegins = 0;
        this.numEnds = 0;
        this.numActualEnds = 0;
    }

    public void beginItem() {
        this.beginItem("No Description");
    }

    public void beginItem(String desc) {
        this.currItem = new Item(desc);
        this.items.add(this.currItem);
        ++this.numBegins;
    }

    public void endItem() {
        ++this.numEnds;
        Item item = this.getLastNotEnded();
        if (item != null) {
            item.end();
        }
        ++this.numActualEnds;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nBegins: " + this.numBegins + ", Ends: " + this.numEnds + ", Actual Ends: " + this.numActualEnds + "\n");
        sb.append(Item.getHeader());
        sb.append("\n");
        for (Item item : this.items) {
            sb.append(item.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private Item getLastNotEnded() {
        int index = this.items.size();
        while (--index >= 0) {
            Item item = this.items.get(index);
            if (item.hasEnded()) continue;
            return item;
        }
        return null;
    }

    public static void main(String[] notUsed) {
        ProfilerImpl p = new ProfilerImpl();
        try {
            p.beginItem("first item");
            Thread.sleep(3000L);
            p.beginItem("second item here dude whoa yowser yowser");
            Thread.sleep(1500L);
            p.endItem();
            p.endItem();
            System.out.println("" + p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Item {
        String title;
        long startTime;
        long endTime;
        static int longestTitle = 12;
        boolean ended = false;

        Item(String desc) {
            this.title = desc;
            this.endTime = this.startTime = System.currentTimeMillis();
            if (this.title.length() > longestTitle) {
                longestTitle = this.title.length();
            }
        }

        boolean hasEnded() {
            return this.ended;
        }

        void end() {
            this.endTime = System.currentTimeMillis();
            this.ended = true;
        }

        public String toString() {
            long finish = this.hasEnded() ? this.endTime : System.currentTimeMillis();
            String totalTime = "" + (finish - this.startTime);
            if (totalTime.equals("0")) {
                totalTime = "< 1";
            }
            String desc = StringUtils.padRight(this.title, longestTitle + 1);
            String time = StringUtils.padLeft(totalTime, 8);
            if (!this.hasEnded()) {
                time = time + "  ** STILL RUNNING **";
            }
            return desc + time;
        }

        public static String getHeader() {
            return "\n" + StringUtils.padRight("Description", longestTitle + 1) + StringUtils.padLeft("msec", 8);
        }
    }
}

