/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.recovery;

import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class OracleXAResource
extends XAResourceWrapper {
    private static final StringManager sm = StringManager.getManager(XAResourceWrapper.class);
    private static final Logger _logger = LogDomains.getLogger(JavaEETransactionManagerSimplified.class, "javax.enterprise.resource.jta");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public XAResourceWrapper getInstance() {
        return new OracleXAResource();
    }

    public Xid[] recover(int flag) throws XAException {
        if (flag == 0) {
            return null;
        }
        return this.recoverList(flag);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Xid[] recoverList(int flag) throws XAException {
        block15: {
            stmt = null;
            resultset = null;
            con = null;
            try {
                try {
                    con = (Connection)this.m_xacon.getConnection(this.subject, null);
                    if (null == con) {
                        throw new XAException(OracleXAResource.sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
                    }
                    stmt = con.createStatement();
                    resultset = stmt.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS");
                    resultset.close();
                    resultset = null;
                    stmt.close();
                    stmt = null;
                    var5_5 = this.m_xacon.getXAResource().recover(flag);
                    var7_9 = null;
                    if (null == resultset) break block15;
                }
                catch (SQLException sqlexception) {
                    throw new XAException(OracleXAResource.sm.getString("transaction.oracle_sqlexception_occurred", sqlexception));
                }
                catch (XAException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XAException(OracleXAResource.sm.getString("transaction.oracle_unknownexception_occurred", e));
                }
            }
            catch (Throwable var6_13) {
                var7_10 = null;
                if (null != resultset) {
                    try {
                        resultset.close();
                    }
                    catch (SQLException sqlexception1) {
                        // empty catch block
                    }
                }
                if (null == stmt) throw var6_13;
                try {
                    stmt.close();
                    throw var6_13;
                }
                catch (SQLException sqlexception2) {
                    throw var6_13;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 164->173)] { 
lbl44:
            // 1 sources

            resultset.close();
            break block15;
lbl46:
            // 1 sources

            catch (SQLException sqlexception1) {
                // empty catch block
            }
        }
        if (null == stmt) return var5_5;
        try {}
        catch (SQLException sqlexception2) {
            // empty catch block
            return var5_5;
        }
        stmt.close();
        return var5_5;
    }

    public void commit(Xid xid, boolean flag) throws XAException {
        this.doRecovery(xid, true);
    }

    public void rollback(Xid xid) throws XAException {
        this.doRecovery(xid, false);
    }

    /*
     * Loose catch block
     */
    private void doRecovery(Xid xid, boolean isCommit) throws XAException {
        block22: {
            ResultSet resultset;
            Statement stmt;
            block21: {
                block20: {
                    try {
                        if (isCommit) {
                            this.m_xacon.getXAResource().commit(xid, true);
                        } else {
                            this.m_xacon.getXAResource().rollback(xid);
                        }
                    }
                    catch (XAException ex) {
                        _logger.log(Level.FINEST, " An XAException occurred while calling XAResource method ", ex);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.FINEST, " An Exception occurred while calling XAResource method ", ex);
                    }
                    stmt = null;
                    resultset = null;
                    Connection con = null;
                    con = (Connection)this.m_xacon.getConnection(this.subject, null);
                    if (null == con) {
                        throw new XAException(sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
                    }
                    stmt = con.createStatement();
                    resultset = stmt.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS dba where pending.global_foreign_id = '" + OracleXAResource.toHexString(xid.getGlobalTransactionId()) + "' and pending.local_tran_id = dba.local_tran_id and dba.branch = '" + OracleXAResource.toHexString(xid.getBranchQualifier()) + "' and pending.state = 'prepared'");
                    if (!resultset.next()) break block20;
                    String s = resultset.getString(1);
                    resultset.close();
                    resultset = null;
                    stmt.executeUpdate((isCommit ? "commit force '" : "rollback force '") + s + "'");
                    stmt.close();
                    stmt = null;
                }
                Object var8_11 = null;
                if (null == resultset) break block21;
                try {
                    resultset.close();
                }
                catch (SQLException sqlexception1) {
                    // empty catch block
                }
            }
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlexception2) {}
            }
            break block22;
            {
                catch (SQLException sqlexception) {
                    _logger.log(Level.FINE, " An SQLException during recovery ", sqlexception);
                    throw new XAException(sm.getString("transaction.oracle_sqlexception_occurred", sqlexception));
                }
                catch (Exception e) {
                    _logger.log(Level.FINE, " An Exception during recovery ", e);
                    throw new XAException(sm.getString("transaction.oracle_unknownexception_occurred", e));
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (null != resultset) {
                    try {
                        resultset.close();
                    }
                    catch (SQLException sqlexception1) {
                        // empty catch block
                    }
                }
                if (null != stmt) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlexception2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private static String toHexString(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer();
        if (null != abyte0 && 0 < abyte0.length) {
            for (int i = 0; i < abyte0.length; ++i) {
                stringbuffer.append(HEX_DIGITS[(abyte0[i] & 0xF0) >> 4]);
                stringbuffer.append(HEX_DIGITS[abyte0[i] & 0xF]);
            }
            return stringbuffer.toString();
        }
        return "";
    }
}

