/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.common.WLSecurityRoleAssignment;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.CachedPermission;
import com.sun.enterprise.security.CachedPermissionImpl;
import com.sun.enterprise.security.PermissionCache;
import com.sun.enterprise.security.PermissionCacheFactory;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.web.integration.WebPermissionUtil;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;

public class WebSecurityManager {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    public static final String CONSTRAINT_URI = "org.apache.catalina.CONSTRAINT_URI";
    private static final String RESOURCE = "hasResourcePermission";
    private static final String USERDATA = "hasUserDataPermission";
    private static final String ROLEREF = "hasRoleRefPermission";
    private static final String DEFAULT_PATTERN = "/";
    private static final String EMPTY_STRING = "";
    private String CONTEXT_ID = null;
    private String CODEBASE = null;
    protected Policy policy = Policy.getPolicy();
    protected PolicyConfiguration pc = null;
    protected PolicyConfigurationFactory pcf = null;
    protected CodeSource codesource = null;
    private Map protectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private static final WebResourcePermission allResources = new WebResourcePermission("/*", (String)null);
    private static final WebUserDataPermission allConnections = new WebUserDataPermission("/*", null);
    private static Permission[] protoPerms = new Permission[]{allResources, allConnections};
    private CachedPermission allResourcesCP = null;
    private CachedPermission allConnectionsCP = null;
    private PermissionCache uncheckedPermissionCache = null;
    private static Set defaultPrincipalSet = SecurityContext.getDefaultSecurityContext().getPrincipalSet();
    private WebSecurityManagerFactory wsmf = null;
    private ServerContext serverContext = null;
    private WebBundleDescriptor wbd = null;
    private WebSecurityDeployerProbeProvider probeProvider = new WebSecurityDeployerProbeProvider();
    private boolean register = true;

    WebSecurityManager(WebBundleDescriptor wbd, ServerContext svc, WebSecurityManagerFactory fact, boolean register) throws PolicyContextException {
        this.register = register;
        this.wbd = wbd;
        this.CONTEXT_ID = WebSecurityManager.getContextID(wbd);
        this.serverContext = svc;
        this.wsmf = fact;
        String appname = this.getAppId();
        this.postConstruct();
        this.initialise(appname);
    }

    private WebSecurityManager(WebBundleDescriptor wbd, WebSecurityManagerFactory fact) throws PolicyContextException {
        this(wbd, null, fact);
    }

    WebSecurityManager(WebBundleDescriptor wbd, ServerContext svc, WebSecurityManagerFactory fact) throws PolicyContextException {
        this.wbd = wbd;
        this.CONTEXT_ID = WebSecurityManager.getContextID(wbd);
        this.serverContext = svc;
        this.wsmf = fact;
        String appname = this.getAppId();
        this.postConstruct();
        this.initialise(appname);
    }

    private void postConstruct() {
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().setAppNameForContext(this.getAppId(), this.CONTEXT_ID);
    }

    private String removeSpaces(String withSpaces) {
        return withSpaces.replace(' ', '_');
    }

    public static String getContextID(WebBundleDescriptor wbd) {
        return SecurityUtil.getContextID(wbd);
    }

    private void initialise(String appName) throws PolicyContextException {
        LoginConfiguration lgConf;
        this.getPolicyFactory();
        this.CODEBASE = this.removeSpaces(this.CONTEXT_ID);
        if ("__asadmin".equals(this.getVirtualServers(appName)) && (lgConf = this.wbd.getLoginConfiguration()) != null) {
            String realmName = lgConf.getRealmName();
            SunWebApp sunDes = this.wbd.getSunDescriptor();
            if (sunDes != null) {
                WLSecurityRoleAssignment[] sras;
                SecurityRoleMapping[] srms = sunDes.getSecurityRoleMapping();
                if (srms != null) {
                    for (SecurityRoleMapping srm : srms) {
                        String[] principals = srm.getPrincipalName();
                        if (principals != null) {
                            for (String principal : principals) {
                                this.wsmf.ADMIN_PRINCIPAL.put(realmName + principal, new PrincipalImpl(principal));
                            }
                        }
                        for (String group2 : srm.getGroupNames()) {
                            this.wsmf.ADMIN_GROUP.put(realmName + group2, new Group(group2));
                        }
                    }
                }
                if ((sras = sunDes.getWLSecurityRoleAssignment()) != null) {
                    for (WLSecurityRoleAssignment sra : sras) {
                        List<String> principals = sra.getPrincipalNames();
                        if (sra.isExternallyDefined()) {
                            this.wsmf.ADMIN_GROUP.put(realmName + sra.getRoleName(), new Group(sra.getRoleName()));
                            continue;
                        }
                        for (String principal : principals) {
                            this.wsmf.ADMIN_PRINCIPAL.put(realmName + principal, new PrincipalImpl(principal));
                        }
                    }
                }
            }
        }
        try {
            URI uri = null;
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[Web-Security] Creating a Codebase URI with = {0}", this.CODEBASE);
                }
                if ((uri = new URI("file:///" + this.CODEBASE)) != null) {
                    this.codesource = new CodeSource(new URL(uri.toString()), (Certificate[])null);
                }
            }
            catch (URISyntaxException use) {
                logger.log(Level.FINE, "[Web-Security] Error Creating URI ", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            logger.log(Level.SEVERE, "ejbsm.codesourceerror", mue);
            throw new RuntimeException(mue);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Context id (id under which  WEB component in application will be created) = {0}", this.CONTEXT_ID);
            logger.log(Level.FINE, "[Web-Security] Codebase (module id for web component) {0}", this.CODEBASE);
        }
        this.loadPolicyConfiguration();
        if (this.uncheckedPermissionCache == null) {
            if (this.register) {
                this.uncheckedPermissionCache = PermissionCacheFactory.createPermissionCache(this.CONTEXT_ID, this.codesource, protoPerms, null);
                this.allResourcesCP = new CachedPermissionImpl(this.uncheckedPermissionCache, allResources);
                this.allConnectionsCP = new CachedPermissionImpl(this.uncheckedPermissionCache, allConnections);
            }
        } else {
            this.uncheckedPermissionCache.reset();
        }
    }

    public void loadPolicyConfiguration() throws PolicyContextException {
        boolean inService = this.getPolicyFactory().inService(this.CONTEXT_ID);
        if (!inService) {
            this.pc = this.getPolicyFactory().getPolicyConfiguration(this.CONTEXT_ID, false);
            try {
                WebPermissionUtil.processConstraints(this.wbd, this.pc);
                WebPermissionUtil.createWebRoleRefPermission(this.wbd, this.pc);
            }
            catch (PolicyContextException pce) {
                logger.log(Level.FINE, "[Web-Security] FATAL Permission Generation: " + pce.getMessage());
                throw pce;
            }
        }
    }

    private String getAppId() {
        return this.wbd.getApplication().getRegistrationName();
    }

    public boolean permitAll(HttpServletRequest req) {
        boolean ret = false;
        WebResourcePermission webResPerm = this.createWebResourcePermission(req);
        if (this.uncheckedPermissionCache != null) {
            ret = this.uncheckedPermissionCache.checkPermission(webResPerm);
        }
        if (!ret) {
            ret = this.checkPermissionWithoutCache(webResPerm, null);
        }
        return ret;
    }

    protected boolean checkPermission(Permission perm, Set principalSet) {
        boolean ret = false;
        if (this.uncheckedPermissionCache != null) {
            ret = this.uncheckedPermissionCache.checkPermission(perm);
        }
        if (!ret) {
            ret = this.checkPermissionWithoutCache(perm, principalSet);
        } else {
            try {
                WebSecurityManager.setPolicyContext(this.CONTEXT_ID);
            }
            catch (Throwable t) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[Web-Security] Web Permission Access Denied.", t);
                }
                ret = false;
            }
        }
        return ret;
    }

    private boolean checkPermissionWithoutCache(Permission perm, Set principalSet) {
        try {
            WebSecurityManager.setPolicyContext(this.CONTEXT_ID);
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] Web Permission Access Denied.", t);
            }
            return false;
        }
        ProtectionDomain prdm = (ProtectionDomain)this.protectionDomainCache.get(principalSet);
        if (prdm == null) {
            Principal[] principals = null;
            Principal[] principalArray = principals = principalSet == null ? null : principalSet.toArray(new Principal[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] Generating a protection domain for Permission check.");
                if (principals != null) {
                    for (int i = 0; i < principals.length; ++i) {
                        logger.log(Level.FINE, "[Web-Security] Checking with Principal : {0}", ((Object)principals[i]).toString());
                    }
                } else {
                    logger.log(Level.FINE, "[Web-Security] Checking with Principals: null");
                }
            }
            prdm = new ProtectionDomain(this.codesource, null, null, principals);
            this.protectionDomainCache.put(principalSet, prdm);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Codesource with Web URL: {0}", this.codesource.getLocation().toString());
            logger.log(Level.FINE, "[Web-Security] Checking Web Permission with Principals : {0}", this.principalSetToString(principalSet));
            logger.log(Level.FINE, "[Web-Security] Web Permission = {0}", perm.toString());
        }
        return this.policy.implies(prdm, perm);
    }

    private PolicyConfigurationFactory getPolicyFactory() throws PolicyContextException {
        if (this.pcf != null) {
            return this.pcf;
        }
        return this._getPolicyFactory();
    }

    private synchronized PolicyConfigurationFactory _getPolicyFactory() throws PolicyContextException {
        if (this.pcf == null) {
            try {
                this.pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            }
            catch (ClassNotFoundException cnfe) {
                logger.severe("jaccfactory.notfound");
                throw new PolicyContextException(cnfe);
            }
            catch (PolicyContextException pce) {
                logger.severe("jaccfactory.notfound");
                throw pce;
            }
        }
        return this.pcf;
    }

    private WebResourcePermission createWebResourcePermission(HttpServletRequest httpsr) {
        String uri = (String)httpsr.getAttribute(CONSTRAINT_URI);
        if (uri == null && (uri = httpsr.getRequestURI()) != null) {
            int contextLength;
            String contextPath = httpsr.getContextPath();
            int n = contextLength = contextPath == null ? 0 : contextPath.length();
            if (contextLength > 0) {
                uri = uri.substring(contextLength);
            }
        }
        if (uri == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] mappedUri is null");
            }
            throw new RuntimeException("Fatal Error in creating WebResourcePermission");
        }
        uri = uri.equals(DEFAULT_PATTERN) ? EMPTY_STRING : uri.replaceAll(":", "%3A");
        WebResourcePermission perm = new WebResourcePermission(uri, httpsr.getMethod());
        return perm;
    }

    public boolean hasResourcePermission(HttpServletRequest httpsr) {
        AuditManager auditManager;
        SecurityContext sc = this.getSecurityContext(httpsr.getUserPrincipal());
        WebResourcePermission perm = this.createWebResourcePermission(httpsr);
        this.setSecurityInfo(httpsr);
        boolean isGranted = this.checkPermission(perm, sc.getPrincipalSet());
        SecurityContext.setCurrent(sc);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasResource isGranted: {0}", isGranted);
            logger.log(Level.FINE, "[Web-Security] hasResource perm: {0}", perm);
        }
        if ((auditManager = SecurityServicesUtil.getInstance().getAuditManager()) != null && auditManager.isAuditOn()) {
            Principal prin = httpsr.getUserPrincipal();
            String user = prin != null ? prin.getName() : null;
            auditManager.webInvocation(user, httpsr, RESOURCE, isGranted);
        }
        return isGranted;
    }

    public boolean hasRoleRefPermission(String servletName, String role, Principal p) {
        Set principalSet = this.getSecurityContext(p).getPrincipalSet();
        WebRoleRefPermission perm = new WebRoleRefPermission(servletName, role);
        boolean isGranted = this.checkPermission(perm, principalSet);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasRoleRef perm: {0}", perm);
            logger.log(Level.FINE, "[Web-Security] hasRoleRef isGranted: {0}", isGranted);
        }
        return isGranted;
    }

    public int hasUserDataPermission(HttpServletRequest httpsr, String uri, String httpMethod) {
        AuditManager auditManager;
        WebUserDataPermission perm;
        this.setSecurityInfo(httpsr);
        boolean requestIsSecure = httpsr.isSecure();
        if (uri == null) {
            perm = new WebUserDataPermission(httpsr);
        } else {
            String[] stringArray;
            if (httpMethod == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = httpMethod;
            }
            perm = new WebUserDataPermission(uri, stringArray, requestIsSecure ? "CONFIDENTIAL" : null);
        }
        boolean isGranted = this.checkPermission(perm, defaultPrincipalSet);
        int result = 0;
        if (isGranted) {
            result = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission perm: {0}", perm);
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission isGranted: {0}", isGranted);
        }
        if ((auditManager = SecurityServicesUtil.getInstance().getAuditManager()) != null && auditManager.isAuditOn()) {
            Principal prin = httpsr.getUserPrincipal();
            String user = prin != null ? prin.getName() : null;
            auditManager.webInvocation(user, httpsr, USERDATA, isGranted);
        }
        if (!isGranted && !requestIsSecure) {
            String[] stringArray;
            if (uri == null) {
                httpMethod = httpsr.getMethod();
            }
            String string = perm.getName();
            if (httpMethod == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = httpMethod;
            }
            perm = new WebUserDataPermission(string, stringArray, "CONFIDENTIAL");
            isGranted = this.checkPermission(perm, defaultPrincipalSet);
            if (isGranted) {
                result = -1;
            }
        }
        return result;
    }

    public void destroy() throws PolicyContextException {
        boolean wasInService = this.getPolicyFactory().inService(this.CONTEXT_ID);
        if (wasInService) {
            this.policy.refresh();
        }
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().removeAppNameForContext(this.CONTEXT_ID);
        this.wsmf.getManager(this.CONTEXT_ID, null, true);
    }

    public void release() throws PolicyContextException {
        boolean wasInService = this.getPolicyFactory().inService(this.CONTEXT_ID);
        PolicyConfiguration config = this.getPolicyFactory().getPolicyConfiguration(this.CONTEXT_ID, false);
        WebPermissionUtil.removePolicyStatements(config, this.wbd);
        if (wasInService) {
            Policy.getPolicy().refresh();
        }
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
        this.wsmf.getManager(this.CONTEXT_ID, null, true);
    }

    private static String setPolicyContext(final String ctxID) throws Throwable {
        String old = PolicyContext.getContextID();
        if (!(old == ctxID || old != null && ctxID != null && old.equals(ctxID))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] Setting Policy Context ID: old = {0} ctxID = {1}", new Object[]{old, ctxID});
            }
            try {
                AppservAccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PolicyContext.setContextID(ctxID);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AccessControlException) {
                    logger.log(Level.SEVERE, "[Web-Security] setPolicy SecurityPermission required to call PolicyContext.setContextID", cause);
                } else {
                    logger.log(Level.SEVERE, "[Web-Security] Unexpected Exception while setting policy context", cause);
                }
                throw cause;
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Policy Context ID was: {0}", old);
        }
        return old;
    }

    private SecurityContext getSecurityContext(Principal principal) {
        SecurityContext secContext = null;
        if (principal != null) {
            if (principal instanceof WebPrincipal) {
                WebPrincipal wp = (WebPrincipal)principal;
                secContext = wp.getSecurityContext();
            } else {
                secContext = new SecurityContext(principal.getName(), null);
            }
        }
        if (secContext == null) {
            secContext = SecurityContext.getDefaultSecurityContext();
        }
        return secContext;
    }

    private void setSecurityInfo(HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            this.wsmf.pcHandlerImpl.getHandlerData().setHttpServletRequest(httpRequest);
        }
    }

    private String principalSetToString(Set principalSet) {
        StringBuilder result = null;
        if (principalSet != null) {
            Principal[] principals = principalSet.toArray(new Principal[0]);
            for (int i = 0; i < principals.length; ++i) {
                if (i == 0) {
                    result = new StringBuilder(((Object)principals[i]).toString());
                    continue;
                }
                result.append(", ").append(((Object)principals[i]).toString());
            }
        }
        return result != null ? result.toString() : null;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        Server server = this.serverContext.getDefaultHabitat().getComponent(Server.class);
        for (ApplicationRef appRef : server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef.getVirtualServers();
        }
        return ret;
    }

    public boolean hasNoConstrainedResources() {
        boolean result = false;
        if (this.allResourcesCP != null && this.allConnectionsCP != null) {
            boolean x = this.allResourcesCP.checkPermission();
            boolean y = this.allConnectionsCP.checkPermission();
            boolean bl = result = x && y;
            if (result) {
                try {
                    WebSecurityManager.setPolicyContext(this.CONTEXT_ID);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        return result;
    }
}

