/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.sql.DataSourceDefinition;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.Interceptors;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DataSourceDefinitionHandler
extends AbstractResourceHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return DataSourceDefinition.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        DataSourceDefinition dataSourceDefnAn = (DataSourceDefinition)ainfo.getAnnotation();
        return this.processAnnotation(dataSourceDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(DataSourceDefinition dataSourceDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            DataSourceDefinitionDescriptor desc;
            if (!this.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set<DataSourceDefinitionDescriptor> dsdDescs = context.getDataSourceDefinitionDescriptors();
            if (this.isDefinitionAlreadyPresent(dsdDescs, desc = this.createDescriptor(dataSourceDefnAn))) {
                this.merge(dsdDescs, dataSourceDefnAn);
                continue;
            }
            dsdDescs.add(desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean isAEjbComponentClass(Annotation[] annotations) {
        boolean ejbClass = false;
        Class<? extends Annotation>[] ejbAnnotations = this.getEjbAnnotationTypes();
        block0: for (Annotation annotation : annotations) {
            for (Class<? extends Annotation> ejbAnnotation : ejbAnnotations) {
                if (!ejbAnnotation.equals(annotation.annotationType())) continue;
                ejbClass = true;
                continue block0;
            }
        }
        return ejbClass;
    }

    private boolean isAWebComponentClass(Annotation[] annotations) {
        boolean warClass = false;
        Class<? extends Annotation>[] webAnnotations = this.getWebAnnotationTypes();
        block0: for (Annotation annotation : annotations) {
            for (Class<? extends Annotation> webAnnotation : webAnnotations) {
                if (!webAnnotation.equals(annotation.annotationType())) continue;
                warClass = true;
                continue block0;
            }
        }
        return warClass;
    }

    private boolean canProcessAnnotation(Class annotatedClass, boolean ejbClass, boolean warClass, ResourceContainerContext context) {
        if (ejbClass) {
            if (!(context instanceof EjbBundleContext || context instanceof EjbContext || context instanceof EjbInterceptorContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @DataSourceDefinition annotation processing as the class isan EJB class and context is not one of EJBContext");
                }
                return false;
            }
        } else if (context instanceof EjbBundleContext) {
            EjbBundleContext ejbContext = (EjbBundleContext)context;
            EjbBundleDescriptor ejbBundleDescriptor = ejbContext.getDescriptor();
            EjbDescriptor[] ejbDescriptor = ejbBundleDescriptor.getEjbByClassName(annotatedClass.getName());
            if (ejbDescriptor == null || ejbDescriptor.length == 0) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @DataSourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an EJB class and the context is EJBContext");
                }
                return false;
            }
        } else if (warClass) {
            if (!(context instanceof WebBundleContext || context instanceof WebComponentsContext || context instanceof WebComponentContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @DataSourceDefinition annotation processing as the class isan Web class and context is not one of WebContext");
                }
                return false;
            }
        } else if (context instanceof WebBundleContext) {
            WebBundleContext webBundleContext = (WebBundleContext)context;
            WebBundleDescriptor webBundleDescriptor = webBundleContext.getDescriptor();
            Collection<RootDeploymentDescriptor> extDesc = webBundleDescriptor.getExtensionsDescriptors();
            for (RootDeploymentDescriptor desc : extDesc) {
                Method[] methods;
                if (!(desc instanceof EjbBundleDescriptor)) continue;
                EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)desc;
                EjbDescriptor[] ejbDescs = ejbBundleDesc.getEjbByClassName(annotatedClass.getName());
                if (ejbDescs != null && ejbDescs.length > 0) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @DataSourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class and the context is WebContext");
                    }
                    return false;
                }
                if (ejbBundleDesc.getInterceptorByClassName(annotatedClass.getName()) != null) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @DataSourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class and the context is WebContext");
                    }
                    return false;
                }
                for (Method method : methods = annotatedClass.getDeclaredMethods()) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = method.getAnnotations()) {
                        if (!annotation.annotationType().equals(AroundInvoke.class) && !annotation.annotationType().equals(AroundTimeout.class) && !annotation.annotationType().equals(Interceptors.class)) continue;
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.log(Level.FINEST, "Ignoring @DataSourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class, an interceptor and the context is WebContext");
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isDefinitionAlreadyPresent(Set<DataSourceDefinitionDescriptor> dsdDescs, DataSourceDefinitionDescriptor desc) {
        boolean result = false;
        for (DataSourceDefinitionDescriptor dsdDesc : dsdDescs) {
            if (!dsdDesc.equals(desc)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        Class<? extends Annotation>[] annotations = this.getEjbAndWebAnnotationTypes();
        ArrayList<Class<Annotation>> annotationsList = new ArrayList<Class<Annotation>>();
        for (Class<? extends Annotation> annotation : annotations) {
            annotationsList.add(annotation);
        }
        annotationsList.add(Interceptors.class);
        annotationsList.add(Interceptor.class);
        annotationsList.add(AroundInvoke.class);
        annotationsList.add(AroundTimeout.class);
        Class[] result = new Class[annotationsList.size()];
        return annotationsList.toArray(result);
    }

    private void merge(Set<DataSourceDefinitionDescriptor> dsdDescs, DataSourceDefinition defn) {
        for (DataSourceDefinitionDescriptor desc : dsdDescs) {
            if (!desc.getName().equals(defn.name())) continue;
            if (desc.getClassName() == null) {
                desc.setClassName(defn.className());
            }
            if (desc.getDescription() == null && defn.description() != null && !defn.description().equals("")) {
                desc.setDescription(defn.description());
            }
            if (!desc.isServerNameSet() && desc.getUrl() == null && defn.serverName() != null && !defn.serverName().equals("localhost")) {
                desc.setServerName(defn.serverName());
            }
            if (desc.getPortNumber() == -1 && desc.getUrl() == null && defn.portNumber() != -1) {
                desc.setPortNumber(defn.portNumber());
            }
            if (desc.getDatabaseName() == null && desc.getUrl() == null && defn.databaseName() != null && !defn.databaseName().equals("")) {
                desc.setDatabaseName(defn.databaseName());
            }
            if (!(desc.getUrl() != null || desc.getPortNumber() != -1 && desc.getServerName() != null && desc.getDatabaseName() != null || defn.url() == null || defn.url().equals(""))) {
                desc.setUrl(defn.url());
            }
            if (desc.getUser() == null && defn.user() != null && !defn.user().equals("")) {
                desc.setUser(defn.user());
            }
            if (desc.getPassword() == null && defn.password() != null) {
                desc.setPassword(defn.password());
            }
            if (desc.getIsolationLevel() == -1 && defn.isolationLevel() != -1) {
                desc.setIsolationLevel(String.valueOf(defn.isolationLevel()));
            }
            if (!desc.isTransactionSet()) {
                if (defn.transactional()) {
                    desc.setTransactional(true);
                } else {
                    desc.setTransactional(false);
                }
            }
            if (desc.getMinPoolSize() == -1 && defn.minPoolSize() != -1) {
                desc.setMinPoolSize(defn.minPoolSize());
            }
            if (desc.getMaxPoolSize() == -1 && defn.maxPoolSize() != -1) {
                desc.setMaxPoolSize(defn.maxPoolSize());
            }
            if (desc.getInitialPoolSize() == -1 && defn.initialPoolSize() != -1) {
                desc.setInitialPoolSize(defn.initialPoolSize());
            }
            if (desc.getMaxIdleTime() == -1L && defn.maxIdleTime() != -1) {
                desc.setMaxIdleTime(String.valueOf(defn.maxIdleTime()));
            }
            if (desc.getMaxStatements() == -1 && defn.maxStatements() != -1) {
                desc.setMaxStatements(defn.maxStatements());
            }
            if (!desc.isLoginTimeoutSet() && defn.loginTimeout() != 0) {
                desc.setLoginTimeout(String.valueOf(defn.loginTimeout()));
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf("=");
                if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index);
                String value = property.substring(index + 1);
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private DataSourceDefinitionDescriptor createDescriptor(DataSourceDefinition defn) {
        DataSourceDefinitionDescriptor desc = new DataSourceDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setClassName(defn.className());
        if (defn.description() != null && !defn.description().equals("")) {
            desc.setDescription(defn.description());
        }
        if (defn.serverName() != null && !defn.serverName().equals("localhost")) {
            desc.setServerName(defn.serverName());
        }
        if (defn.portNumber() != -1) {
            desc.setPortNumber(defn.portNumber());
        }
        if (defn.databaseName() != null && !defn.databaseName().equals("")) {
            desc.setDatabaseName(defn.databaseName());
        }
        if (!(desc.getPortNumber() != -1 && desc.getDatabaseName() != null && desc.getServerName() != null || defn.url() == null || defn.url().equals(""))) {
            desc.setUrl(defn.url());
        }
        if (defn.user() != null && !defn.user().equals("")) {
            desc.setUser(defn.user());
        }
        if (defn.password() != null) {
            desc.setPassword(defn.password());
        }
        if (defn.isolationLevel() != -1) {
            desc.setIsolationLevel(String.valueOf(defn.isolationLevel()));
        }
        if (defn.transactional()) {
            desc.setTransactional(true);
        } else {
            desc.setTransactional(false);
        }
        if (defn.minPoolSize() != -1) {
            desc.setMinPoolSize(defn.minPoolSize());
        }
        if (defn.maxPoolSize() != -1) {
            desc.setMaxPoolSize(defn.maxPoolSize());
        }
        if (defn.initialPoolSize() != -1) {
            desc.setInitialPoolSize(defn.initialPoolSize());
        }
        if (defn.maxIdleTime() != -1) {
            desc.setMaxIdleTime(String.valueOf(defn.maxIdleTime()));
        }
        if (defn.maxStatements() != -1) {
            desc.setMaxStatements(defn.maxStatements());
        }
        if (defn.loginTimeout() != 0) {
            desc.setLoginTimeout(String.valueOf(defn.loginTimeout()));
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index);
                    String value = property.substring(index + 1);
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }
}

