/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.glassfish.api.admin.config.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotDuplicateTargetNameValidator
implements ConstraintValidator<NotDuplicateTargetName, Named> {
    Domain domain = null;

    @Override
    public void initialize(NotDuplicateTargetName constraintAnnotation) {
        this.domain = ConfigBeansUtilities.getDomain();
    }

    @Override
    public boolean isValid(Named bean, ConstraintValidatorContext context) {
        boolean checkCluster = true;
        boolean checkConfig = true;
        boolean checkNode = true;
        boolean checkServer = true;
        if (bean instanceof Server) {
            checkServer = false;
        } else if (bean instanceof Cluster) {
            checkCluster = false;
        } else if (bean instanceof Config) {
            checkConfig = false;
        } else if (bean instanceof Node) {
            checkNode = false;
        }
        String name = bean.getName();
        if (this.domain == null) {
            return true;
        }
        return !(checkCluster && this.domain.getClusterNamed(name) != null || checkConfig && this.domain.getConfigNamed(name) != null || checkNode && this.domain.getNodeNamed(name) != null) && (!checkServer || this.domain.getServerNamed(name) == null);
    }
}

