/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.config.serverbeans.WebModule;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.admin.config.ApplicationName;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public final class ConfigBeansUtilities {
    @Inject
    private static Applications apps;
    @Inject
    private static Domain domain;

    public static String getDefaultFormat() {
        return "%client.name% %auth-user-name% %datetime% %request% %status% %response.length%";
    }

    public static String getDefaultRotationPolicy() {
        return "time";
    }

    public static String getDefaultRotationEnabled() {
        return "true";
    }

    public static String getDefaultRotationIntervalInMinutes() {
        return "1440";
    }

    public static String getDefaultQueueSizeInBytes() {
        return "4096";
    }

    public static boolean toBoolean(String value) {
        if (value != null) {
            String v = value.trim();
            return "true".equals(v) || "yes".equals(v) || "on".equals(v) || "1".equals(v);
        }
        return false;
    }

    public static List<Application> getSystemApplicationsReferencedFrom(String sn) {
        if (domain == null || sn == null) {
            throw new IllegalArgumentException("Null argument");
        }
        List<Application> allApps = ConfigBeansUtilities.getAllDefinedSystemApplications();
        if (allApps.isEmpty()) {
            return allApps;
        }
        Server s = ConfigBeansUtilities.getServerNamed(sn);
        ArrayList<Application> referencedApps = new ArrayList<Application>();
        List<ApplicationRef> appsReferenced = s.getApplicationRef();
        for (ApplicationRef ref : appsReferenced) {
            for (Application app : allApps) {
                if (!ref.getRef().equals(app.getName())) continue;
                referencedApps.add(app);
            }
        }
        return referencedApps;
    }

    public static Application getSystemApplicationReferencedFrom(String sn, String appName) {
        List<Application> allApps = ConfigBeansUtilities.getSystemApplicationsReferencedFrom(sn);
        for (Application app : allApps) {
            if (!app.getName().equals(appName)) continue;
            return app;
        }
        return null;
    }

    public static boolean isNamedSystemApplicationReferencedFrom(String appName, String serverName) {
        List<Application> referencedApps = ConfigBeansUtilities.getSystemApplicationsReferencedFrom(serverName);
        for (Application app : referencedApps) {
            if (!app.getName().equals(appName)) continue;
            return true;
        }
        return false;
    }

    public static List<Server> getServers() {
        if (domain == null || domain.getServers() == null) {
            throw new IllegalArgumentException("Either domain is null or no <servers> element");
        }
        return domain.getServers().getServer();
    }

    public static Server getServerNamed(String name) {
        if (domain == null || domain.getServers() == null || name == null) {
            throw new IllegalArgumentException("Either domain is null or no <servers> element");
        }
        List<Server> servers = domain.getServers().getServer();
        for (Server s : servers) {
            if (!name.equals(s.getName().trim())) continue;
            return s;
        }
        return null;
    }

    public static List<Application> getAllDefinedSystemApplications() {
        ArrayList<Application> allSysApps = new ArrayList<Application>();
        SystemApplications sa = domain.getSystemApplications();
        if (sa != null) {
            for (ApplicationName m : sa.getModules()) {
                if (!(m instanceof Application)) continue;
                allSysApps.add((Application)m);
            }
        }
        return allSysApps;
    }

    public static List<ApplicationRef> getApplicationRefsInServer(String sn) {
        return ConfigBeansUtilities.getApplicationRefsInServer(sn, true);
    }

    public static List<ApplicationRef> getApplicationRefsInServer(String sn, boolean excludeSystemApps) {
        Servers ss = domain.getServers();
        List<Server> list = ss.getServer();
        Server theServer = null;
        for (Server s : list) {
            if (!s.getName().equals(sn)) continue;
            theServer = s;
            break;
        }
        if (theServer != null) {
            List<ApplicationName> modulesToExclude = excludeSystemApps ? domain.getSystemApplications().getModules() : Collections.emptyList();
            ArrayList<ApplicationRef> result = new ArrayList<ApplicationRef>();
            for (ApplicationRef candidateRef : theServer.getApplicationRef()) {
                String appRefModuleName = candidateRef.getRef();
                boolean isSystem = false;
                for (ApplicationName sysModule : modulesToExclude) {
                    if (!sysModule.getName().equals(appRefModuleName)) continue;
                    isSystem = true;
                    break;
                }
                if (isSystem) continue;
                result.add(candidateRef);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static ApplicationRef getApplicationRefInServer(String sn, String name) {
        Servers ss = domain.getServers();
        List<Server> list = ss.getServer();
        RefContainer theServer = null;
        for (Server s : list) {
            if (!s.getName().equals(sn)) continue;
            theServer = s;
            break;
        }
        ApplicationRef aref = null;
        if (theServer != null) {
            List<ApplicationRef> arefs = theServer.getApplicationRef();
            for (ApplicationRef ar : arefs) {
                if (!ar.getRef().equals(name)) continue;
                aref = ar;
                break;
            }
        }
        return aref;
    }

    public static ApplicationName getModule(String moduleID) {
        for (ApplicationName module : apps.getModules()) {
            if (!module.getName().equals(moduleID)) continue;
            return module;
        }
        return null;
    }

    public static String getEnabled(String sn, String moduleID) {
        ApplicationRef appRef = ConfigBeansUtilities.getApplicationRefInServer(sn, moduleID);
        if (appRef != null) {
            return appRef.getEnabled();
        }
        return null;
    }

    public static String getVirtualServers(String sn, String moduleID) {
        ApplicationRef appRef = ConfigBeansUtilities.getApplicationRefInServer(sn, moduleID);
        if (appRef != null) {
            return appRef.getVirtualServers();
        }
        return null;
    }

    public static String getContextRoot(String moduleID) {
        ApplicationName module = ConfigBeansUtilities.getModule(moduleID);
        if (module == null) {
            return null;
        }
        if (module instanceof Application) {
            return ((Application)module).getContextRoot();
        }
        if (module instanceof WebModule) {
            return ((WebModule)module).getContextRoot();
        }
        return null;
    }

    public static String getLibraries(String moduleID) {
        ApplicationName module = ConfigBeansUtilities.getModule(moduleID);
        if (module == null) {
            return null;
        }
        if (module instanceof Application) {
            return ((Application)module).getLibraries();
        }
        if (module instanceof WebModule) {
            return ((WebModule)module).getLibraries();
        }
        if (module instanceof EjbModule) {
            return ((EjbModule)module).getLibraries();
        }
        if (module instanceof J2eeApplication) {
            return ((J2eeApplication)module).getLibraries();
        }
        return null;
    }

    public static String getLocation(String moduleID) {
        ApplicationName module = ConfigBeansUtilities.getModule(moduleID);
        if (module == null) {
            return null;
        }
        String location = null;
        if (module instanceof Application) {
            location = ((Application)module).getLocation();
        } else if (module instanceof WebModule) {
            location = ((WebModule)module).getLocation();
        } else if (module instanceof EjbModule) {
            location = ((EjbModule)module).getLocation();
        } else if (module instanceof ConnectorModule) {
            location = ((ConnectorModule)module).getLocation();
        } else if (module instanceof AppclientModule) {
            location = ((AppclientModule)module).getLocation();
        } else if (module instanceof J2eeApplication) {
            location = ((J2eeApplication)module).getLocation();
        }
        try {
            if (location != null) {
                return new URI(location).getPath();
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String getDirectoryDeployed(String moduleID) {
        ApplicationName module = ConfigBeansUtilities.getModule(moduleID);
        if (module == null) {
            return null;
        }
        if (module instanceof Application) {
            return ((Application)module).getDirectoryDeployed();
        }
        if (module instanceof WebModule) {
            return ((WebModule)module).getDirectoryDeployed();
        }
        if (module instanceof EjbModule) {
            return ((EjbModule)module).getDirectoryDeployed();
        }
        if (module instanceof ConnectorModule) {
            return ((ConnectorModule)module).getDirectoryDeployed();
        }
        if (module instanceof AppclientModule) {
            return ((AppclientModule)module).getDirectoryDeployed();
        }
        if (module instanceof J2eeApplication) {
            return ((J2eeApplication)module).getDirectoryDeployed();
        }
        return null;
    }

    public static String join(Iterable<String> list, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(string);
        }
        return builder.toString();
    }

    public static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static Domain getDomain() {
        return domain;
    }
}

