/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.FileValidator;
import com.sun.enterprise.admin.servermgmt.InvalidConfigException;
import com.sun.enterprise.admin.servermgmt.PortValidator;
import com.sun.enterprise.admin.servermgmt.StringValidator;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class PEDomainConfigValidator
extends DomainConfigValidator {
    private static final StringManager strMgr = StringManager.getManager(PEDomainConfigValidator.class);
    private static final String lInstallRoot = strMgr.getString("installRoot");
    private static final String lDomainsRoot = strMgr.getString("domainsRoot");
    private static final String lJavaHome = strMgr.getString("javaHome");
    private static final String lAdminPort = strMgr.getString("adminPort");
    private static final String lInstancePort = strMgr.getString("instancePort");
    private static final String lHostName = strMgr.getString("hostName");
    private static final String lJmsPort = strMgr.getString("jmsPort");
    private static final String lOrbPort = strMgr.getString("orbPort");
    static DomainConfigValidator.DomainConfigEntryInfo[] entries = new DomainConfigValidator.DomainConfigEntryInfo[]{new DomainConfigValidator.DomainConfigEntryInfo("install.root", "java.lang.String", lInstallRoot, new FileValidator(lInstallRoot, "dr")), new DomainConfigValidator.DomainConfigEntryInfo("domains.root", "java.lang.String", lDomainsRoot, new FileValidator(lDomainsRoot, "drw")), new DomainConfigValidator.DomainConfigEntryInfo("domain.adminPort", "java.lang.Integer", lAdminPort, new PortValidator(lAdminPort)), new DomainConfigValidator.DomainConfigEntryInfo("domain.instancePort", "java.lang.Integer", lInstancePort, new PortValidator(lInstancePort)), new DomainConfigValidator.DomainConfigEntryInfo("domain.hostName", "java.lang.String", lHostName, new StringValidator(lHostName)), new DomainConfigValidator.DomainConfigEntryInfo("orb.listener.port", "java.lang.Integer", lOrbPort, new PortValidator(lOrbPort)), new DomainConfigValidator.DomainConfigEntryInfo("jms.port", "java.lang.Integer", lJmsPort, new PortValidator(lJmsPort))};

    PEDomainConfigValidator() {
        super(entries);
    }

    public void validate(Object domainConfig) throws InvalidConfigException {
        super.validate(domainConfig);
        this.uniquePorts((DomainConfig)domainConfig);
    }

    protected boolean isValidate(String name, Object domainConfig) {
        boolean isPortEntry = "domain.adminPort".equals(name) || "domain.instancePort".equals(name) || "orb.listener.port".equals(name) || "jms.port".equals(name);
        return isPortEntry ? this.isValidatePorts((Map)domainConfig) : true;
    }

    private boolean isValidatePorts(Map domainConfig) {
        Boolean isValidatePorts = (Boolean)domainConfig.get("domain.validatePorts");
        return null != isValidatePorts ? isValidatePorts : true;
    }

    final void uniquePorts(DomainConfig dc) throws InvalidConfigException {
        Map ports = dc.getPorts();
        HashSet portValues = new HashSet(ports.values());
        if (ports.keySet().size() != portValues.size()) {
            throw new InvalidConfigException(this.getMessage(ports));
        }
    }

    private final String getMessage(Map ports) {
        return this.getLocalizedString("duplicatePorts", this.getDuplicatePorts(ports));
    }

    private final String getLocalizedString(String key, Object o) {
        return strMgr.getString(key, o);
    }

    final String getDuplicatePorts(Map ports) {
        return this.printDuplicatesFromMap(this.reverseMap(ports));
    }

    private final Map reverseMap(Map inputMap) {
        TreeMap outputMap = new TreeMap();
        for (Map.Entry entry : inputMap.entrySet()) {
            this.addEntryToMap(entry.getKey(), entry.getValue(), outputMap);
        }
        return outputMap;
    }

    private final void addEntryToMap(Object key, Object value, Map map) {
        if (!map.containsKey(value)) {
            map.put(value, new TreeSet());
        }
        ((Set)map.get(value)).add(key);
    }

    private final String printDuplicatesFromMap(Map map) {
        StringBuffer sb = new StringBuffer();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = this.getNextDuplicate(it);
        if (entry != null) {
            this.printEntry(sb, entry);
            while ((entry = this.getNextDuplicate(it)) != null) {
                sb.append(", ");
                this.printEntry(sb, entry);
            }
        }
        return sb.toString();
    }

    private final Map.Entry getNextDuplicate(Iterator it) {
        while (it.hasNext()) {
            Map.Entry result = (Map.Entry)it.next();
            if (((Set)result.getValue()).size() <= 1) continue;
            return result;
        }
        return null;
    }

    private final void printEntry(StringBuffer sb, Map.Entry entry) {
        this.printEntry(sb, entry.getKey(), (Set)entry.getValue());
    }

    private final void printEntry(StringBuffer sb, Object key, Set dups) {
        sb.append(key).append(" -> ");
        this.printSet(sb, dups);
    }

    private final void printSet(StringBuffer sb, Set set) {
        sb.append("{");
        String separator = "";
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append(separator).append(it.next());
            separator = ", ";
        }
        sb.append("}");
    }
}

