/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.InvalidConfigException;
import com.sun.enterprise.admin.servermgmt.Validator;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashMap;

public abstract class DomainConfigValidator
extends Validator {
    private static final StringManager strMgr = StringManager.getManager(DomainConfigValidator.class);
    private DomainConfigEntryInfo[] entries;

    protected DomainConfigValidator(DomainConfigEntryInfo[] entries) {
        super(strMgr.getString("domainConfig"), DomainConfig.class);
        this.entries = entries;
    }

    protected DomainConfigValidator(String name, Class type2, DomainConfigEntryInfo[] entries) {
        super(name, type2);
        this.entries = entries;
    }

    public void validate(Object domainConfig) throws InvalidConfigException {
        super.validate(domainConfig);
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.isValidate(this.entries[i].key, domainConfig)) continue;
            Object value = ((HashMap)domainConfig).get(this.entries[i].key);
            if (!this.entries[i].hasValidator()) continue;
            this.entries[i].validator.validate(value);
        }
    }

    public boolean isKeyAllowed(Object key) {
        return this.get(key) != null;
    }

    public boolean isValueValid(Object key, Object value) {
        boolean isValid = false;
        DomainConfigEntryInfo info = this.get(key);
        if (info != null) {
            if (info.hasValidator()) {
                try {
                    info.validator.validate(value);
                }
                catch (InvalidConfigException idce) {
                    isValid = false;
                }
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    public String getDataType(Object key) {
        DomainConfigEntryInfo info = this.get(key);
        if (info != null) {
            return info.dataType;
        }
        return "";
    }

    protected abstract boolean isValidate(String var1, Object var2);

    private DomainConfigEntryInfo get(Object key) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].key.equals(key)) continue;
            return this.entries[i];
        }
        return null;
    }

    protected static class DomainConfigEntryInfo {
        final String key;
        final String dataType;
        final String displayText;
        final Validator validator;

        public DomainConfigEntryInfo(String key, String dataType, String displayText, Validator validator) {
            this.key = key;
            this.dataType = dataType;
            this.displayText = displayText;
            this.validator = validator;
        }

        public boolean hasValidator() {
            return this.validator != null;
        }
    }
}

