/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.optional.BackupCommands;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupManager;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="backup-domain")
@Scoped(value=PerLookup.class)
public final class BackupDomainCommand
extends BackupCommands {
    @Param(name="description", optional=true)
    String description;
    @Param(name="_force", optional=true)
    String force;
    @Param(name="_recyclelimit", optional=true)
    String recycleLimit;
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupDomainCommand.class);

    protected void validate() throws CommandException {
        if (this.domainName == null) {
            super.validate();
        }
        this.checkOptions();
        this.setDomainName(this.domainName);
        this.initDomain();
        File domainFile = new File(new File(this.domainDirParam), this.domainName);
        if (!this.isWritableDirectory(domainFile)) {
            throw new CommandException(strings.get("InvalidDirectory", domainFile.getPath()));
        }
        if (this.force == null && this.isRunning()) {
            boolean suspendAvailable = this.canSuspend();
            if (suspendAvailable && !this.isSuspended()) {
                throw new CommandException(strings.get("DomainIsNotSuspended", this.domainName));
            }
            if (!suspendAvailable) {
                throw new CommandException(strings.get("DomainIsNotStopped", this.domainName));
            }
        }
        int limit = 0;
        if (this.recycleLimit != null) {
            try {
                limit = Integer.parseInt(this.recycleLimit.trim());
            }
            catch (NumberFormatException ex) {
                limit = -1;
            }
            if (limit < 0) {
                throw new CommandException(strings.get("InvalidBackupRecycleLimit", this.recycleLimit));
            }
        }
        this.setDescription(this.description);
        this.setBackupDir(this.backupdir);
        this.setRecycleLimit(limit);
        this.prepareRequest();
        this.initializeLogger();
    }

    protected int executeCommand() throws CommandException {
        try {
            BackupManager mgr = new BackupManager(this.request);
            logger.info(mgr.backup());
        }
        catch (BackupWarningException bwe) {
            logger.info(bwe.getMessage());
        }
        catch (BackupException be) {
            throw new CommandException(be);
        }
        return 0;
    }

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString(this);
    }

    private boolean canSuspend() {
        try {
            RemoteCommand cmd = new RemoteCommand("list-commands", this.programOpts, this.env);
            String response = cmd.executeAndReturnOutput("list-commands");
            if (response.indexOf("suspend-domain") >= 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info("Exception while probing DAS (list-commands): " + e.getMessage());
        }
        return false;
    }

    private boolean isSuspended() {
        try {
            RemoteCommand cmd = new RemoteCommand("suspend-domain", this.programOpts, this.env);
            String response = cmd.executeAndReturnOutput("suspend-domain", "--_test=true");
            if (response.indexOf("SUSPENDED=TRUE") >= 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info("Exception while probing DAS (suspend-domain): " + e.getMessage());
        }
        return false;
    }
}

