/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.Transactor;
import org.jvnet.hk2.config.WriteableView;

public class Transaction {
    final LinkedList<Transactor> participants = new LinkedList();

    synchronized void addParticipant(Transactor t) {
        this.participants.addFirst(t);
    }

    public synchronized void rollback() {
        for (Transactor t : this.participants) {
            t.abort(this);
        }
    }

    public boolean canCommit() throws TransactionFailure {
        for (Transactor t : this.participants) {
            if (t.canCommit(this)) continue;
            return false;
        }
        return true;
    }

    public synchronized List<PropertyChangeEvent> commit() throws RetryableException, TransactionFailure {
        if (!this.canCommit()) {
            throw new RetryableException();
        }
        LinkedList<PropertyChangeEvent> transactionChanges = new LinkedList<PropertyChangeEvent>();
        for (Transactor t : this.participants) {
            for (PropertyChangeEvent evt : t.commit(this)) {
                transactionChanges.addFirst(evt);
            }
        }
        for (Transactor t : this.participants) {
            if (!(t instanceof WriteableView)) continue;
            ((WriteableView)t).getMasterView().getHabitat().getComponent(Transactions.class).addTransaction(transactionChanges);
            break;
        }
        return transactionChanges;
    }

    public static <T extends ConfigBeanProxy> Transaction getTransaction(T source) {
        InvocationHandler sourceBean = Proxy.getInvocationHandler(source);
        if (sourceBean instanceof WriteableView) {
            return ((WriteableView)sourceBean).getTransaction();
        }
        return null;
    }

    public <T extends ConfigBeanProxy> T enroll(T source) throws TransactionFailure {
        ConfigView sourceBean = (ConfigView)Proxy.getInvocationHandler(source);
        WriteableView writeableView = ConfigSupport.getWriteableView(source, (ConfigBean)sourceBean.getMasterView());
        if (!writeableView.join(this)) {
            throw new TransactionFailure("Cannot join transaction : " + sourceBean.getProxyType());
        }
        return writeableView.getProxy(sourceBean.getProxyType());
    }
}

