/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import org.jboss.weld.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

public class TypeVariableResolver {
    private Class beanClass;
    private HashMap<TypeVariable, Type> resolvedVariables;

    public TypeVariableResolver(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass should not be null");
        }
        this.beanClass = beanClass;
    }

    public static Type resolveVariables(Class beanClass, Type type2) {
        return new TypeVariableResolver(beanClass).resolveVariablesInType(type2);
    }

    public Type resolveVariablesInType(Type type2) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            return new ParameterizedTypeImpl(parameterizedType.getRawType(), this.resolveVariablesInTypes(parameterizedType.getActualTypeArguments()), parameterizedType.getOwnerType());
        }
        if (type2 instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type2;
            return this.resolveTypeVariable(typeVariable);
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type2;
            return new GenericArrayTypeImpl(this.resolveVariablesInType(genericArrayType.getGenericComponentType()));
        }
        return type2;
    }

    private Type[] resolveVariablesInTypes(Type[] types) {
        Type[] resolvedTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypes[i] = this.resolveVariablesInType(types[i]);
        }
        return resolvedTypes;
    }

    private Type resolveTypeVariable(TypeVariable typeVariable) {
        if (this.resolvedVariables == null) {
            this.resolvedVariables = new HashMap();
            this.fillResolvedVariablesMap(this.beanClass);
        }
        return this.resolve(typeVariable);
    }

    private void fillResolvedVariablesMap(Class beanClass) {
        Type genericSuperclass = beanClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedSuperClassType = (ParameterizedType)genericSuperclass;
            Type[] actualTypeArguments = parameterizedSuperClassType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = beanClass.getSuperclass().getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                this.resolvedVariables.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
        if (beanClass.getSuperclass() != null) {
            this.fillResolvedVariablesMap(beanClass.getSuperclass());
        }
    }

    private Type resolve(Type type2) {
        TypeVariable typeVariable;
        if (type2 instanceof TypeVariable && this.resolvedVariables.containsKey(typeVariable = (TypeVariable)type2)) {
            return this.resolve(this.resolvedVariables.get(typeVariable));
        }
        return type2;
    }
}

