/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.validator.internal.engine.MethodValidationContext;
import org.hibernate.validator.internal.engine.PathImpl;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.Sequence;
import org.hibernate.validator.internal.engine.groups.ValidationOrder;
import org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import org.hibernate.validator.internal.engine.resolver.SingleThreadCachedTraversableResolver;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MethodMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.method.MethodConstraintViolation;
import org.hibernate.validator.method.MethodValidator;
import org.hibernate.validator.method.metadata.TypeDescriptor;

public class ValidatorImpl
implements Validator,
MethodValidator {
    private static final Log log = LoggerFactory.make();
    private static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final transient ValidationOrderGenerator validationOrderGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final BeanMetaDataManager beanMetaDataManager;
    private final boolean failFast;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, BeanMetaDataManager beanMetaDataManager, boolean failFast) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.beanMetaDataManager = beanMetaDataManager;
        this.failFast = failFast;
        this.validationOrderGenerator = new ValidationOrderGenerator();
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T, ConstraintViolation<T>> validationContext = ValidationContext.getContextForValidate(object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        ValueContext valueContext = ValueContext.getLocalExecutionContext(object, PathImpl.createRootPath());
        return this.validateInContext(valueContext, validationContext, validationOrder);
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T, ConstraintViolation<T>> context = ValidationContext.getContextForValidateProperty(object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        return this.validatePropertyInContext(context, PathImpl.createPathFromString(propertyName), validationOrder);
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Contracts.assertNotNull(beanType, Messages.MESSAGES.beanTypeCannotBeNull());
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T, ConstraintViolation<T>> context = ValidationContext.getContextForValidateValue(beanType, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        return this.validateValueInContext(context, value, PathImpl.createPathFromString(propertyName), validationOrder);
    }

    @Override
    public final <T> Set<MethodConstraintViolation<T>> validateParameter(T object, Method method, Object parameterValue, int parameterIndex, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameter(method, parameterIndex, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        Object[] parameterValues = new Object[method.getParameterTypes().length];
        parameterValues[parameterIndex] = parameterValue;
        this.validateParametersInContext(context, object, parameterValues, validationOrder);
        return context.getFailingConstraints();
    }

    @Override
    public final <T> Set<MethodConstraintViolation<T>> validateAllParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        if (parameterValues == null) {
            return Collections.emptySet();
        }
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameters(method, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        this.validateParametersInContext(context, object, parameterValues, validationOrder);
        return context.getFailingConstraints();
    }

    @Override
    public <T> Set<MethodConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameters(method, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        this.validateReturnValueInContext(context, object, returnValue, validationOrder);
        return context.getFailingConstraints();
    }

    @Override
    public final BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.beanMetaDataManager.getBeanMetaData(clazz).getBeanDescriptor();
    }

    @Override
    public final TypeDescriptor getConstraintsForType(Class<?> clazz) {
        return this.beanMetaDataManager.getBeanMetaData(clazz).getTypeDescriptor();
    }

    @Override
    public final <T> T unwrap(Class<T> type2) {
        if (type2.isAssignableFrom(this.getClass())) {
            return type2.cast(this);
        }
        throw log.getTypeNotSupportedException(type2);
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw log.getInvalidPropertyPathException();
        }
    }

    private ValidationOrder determineGroupValidationOrder(Class<?>[] groups) {
        Contracts.assertNotNull(groups, Messages.MESSAGES.groupMustNotBeNull());
        Class<?>[] tmpGroups = groups;
        if (tmpGroups.length == 0) {
            tmpGroups = DEFAULT_GROUP_ARRAY;
        }
        return this.validationOrderGenerator.getValidationOrder(Arrays.asList(tmpGroups));
    }

    private <T, U, V, E extends ConstraintViolation<T>> Set<E> validateInContext(ValueContext<U, V> valueContext, ValidationContext<T, E> context, ValidationOrder validationOrder) {
        Group group2;
        if (valueContext.getCurrentBean() == null) {
            return Collections.emptySet();
        }
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getDefiningClass());
            this.validateConstraintsForCurrentGroup(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getDefiningClass());
            this.validateCascadedConstraints(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group3 : sequence.getComposingGroups()) {
                int numberOfViolations = context.getFailingConstraints().size();
                valueContext.setCurrentGroup(group3.getDefiningClass());
                this.validateConstraintsForCurrentGroup(context, valueContext);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                this.validateCascadedConstraints(context, valueContext);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraintsForCurrentGroup(ValidationContext<T, E> validationContext, ValueContext<U, V> valueContext) {
        if (!valueContext.validatingDefault()) {
            this.validateConstraintsForNonDefaultGroup(validationContext, valueContext);
        } else {
            this.validateConstraintsForDefaultGroup(validationContext, valueContext);
        }
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraintsForDefaultGroup(ValidationContext<T, E> validationContext, ValueContext<U, V> valueContext) {
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<?>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<?> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<?> hostingBeanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            List<Class<?>> defaultGroupSequence = hostingBeanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean());
            Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
            if (defaultGroupSequenceIsRedefined) {
                metaConstraints = hostingBeanMetaData.getMetaConstraints();
            }
            PathImpl currentPath = valueContext.getPropertyPath();
            for (Class<?> defaultSequenceMember : defaultGroupSequence) {
                valueContext.setCurrentGroup(defaultSequenceMember);
                boolean validationSuccessful = true;
                for (MetaConstraint<?> metaConstraint : metaConstraints) {
                    Class<?> declaringClass = metaConstraint.getLocation().getBeanClass();
                    if (declaringClass.isInterface()) {
                        Class validatedForClass = (Class)validatedInterfaces.get(declaringClass);
                        if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                        validatedInterfaces.put(declaringClass, clazz);
                    }
                    boolean tmp = this.validateConstraint(validationContext, valueContext, metaConstraint);
                    if (this.shouldFailFast(validationContext)) {
                        return;
                    }
                    validationSuccessful = validationSuccessful && tmp;
                    valueContext.setPropertyPath(currentPath);
                }
                if (validationSuccessful) continue;
                break;
            }
            validationContext.markProcessed(valueContext.getCurrentBean(), valueContext.getCurrentGroup(), valueContext.getPropertyPath());
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
    }

    private <T, U, V> void validateConstraintsForNonDefaultGroup(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext) {
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        PathImpl currentPath = valueContext.getPropertyPath();
        for (MetaConstraint<?> metaConstraint : beanMetaData.getMetaConstraints()) {
            this.validateConstraint(validationContext, valueContext, metaConstraint);
            if (this.shouldFailFast(validationContext)) {
                return;
            }
            valueContext.setPropertyPath(currentPath);
        }
        validationContext.markProcessed(valueContext.getCurrentBean(), valueContext.getCurrentGroup(), valueContext.getPropertyPath());
    }

    private <T, U, V> boolean validateConstraint(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext, MetaConstraint<?> metaConstraint) {
        boolean validationSuccessful = true;
        if (metaConstraint.getElementType() != ElementType.TYPE) {
            valueContext.appendNode(ReflectionHelper.getPropertyName(metaConstraint.getLocation().getMember()));
        }
        if (this.isValidationRequired(validationContext, valueContext, metaConstraint)) {
            Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
            valueContext.setCurrentValidatedValue(valueToValidate);
            validationSuccessful = metaConstraint.validateConstraint(validationContext, valueContext);
        }
        return validationSuccessful;
    }

    private <T, U, V> void validateCascadedConstraints(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext) {
        Set<Member> cascadedMembers = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType()).getCascadedMembers();
        PathImpl currentPath = valueContext.getPropertyPath();
        for (Member member : cascadedMembers) {
            Object value;
            String newNode = ReflectionHelper.getPropertyName(member);
            valueContext.appendNode(newNode);
            if (this.isCascadeRequired(validationContext, valueContext, member) && (value = ReflectionHelper.getValue(member, valueContext.getCurrentBean())) != null) {
                Class<?> type2 = value.getClass();
                Iterator<?> iter = this.createIteratorForCascadedValue(type2, value, valueContext);
                boolean isIndexable = this.isIndexable(type2);
                this.validateCascadedConstraint(validationContext, iter, isIndexable, valueContext);
                if (this.shouldFailFast(validationContext)) {
                    return;
                }
            }
            valueContext.setPropertyPath(currentPath);
        }
    }

    private <T, U, V> void validateCascadedMethodConstraints(MethodValidationContext<T> validationContext, ValueContext<U, V> valueContext) {
        U value = valueContext.getCurrentBean();
        Class<U> type2 = valueContext.getCurrentBeanType();
        Iterator<?> iter = this.createIteratorForCascadedValue(type2, value, valueContext);
        boolean isIndexable = this.isIndexable(type2);
        this.validateCascadedConstraint(validationContext, iter, isIndexable, valueContext);
    }

    private Iterator<?> createIteratorForCascadedValue(Type type2, Object value, ValueContext<?, ?> valueContext) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type2)) {
            iter = ((Iterable)value).iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (ReflectionHelper.isMap(type2)) {
            Map map = (Map)value;
            iter = map.entrySet().iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (TypeHelper.isArray(type2)) {
            List<Object> arrayList = Arrays.asList((Object[])value);
            iter = arrayList.iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else {
            ArrayList list = CollectionHelper.newArrayList();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    private boolean isIndexable(Type type2) {
        boolean isIndexable = false;
        if (ReflectionHelper.isList(type2)) {
            isIndexable = true;
        } else if (ReflectionHelper.isMap(type2)) {
            isIndexable = true;
        } else if (TypeHelper.isArray(type2)) {
            isIndexable = true;
        }
        return isIndexable;
    }

    private <T> void validateCascadedConstraint(ValidationContext<T, ?> context, Iterator<?> iter, boolean isIndexable, ValueContext<?, ?> valueContext) {
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof Map.Entry) {
                Object mapKey = ((Map.Entry)value).getKey();
                valueContext.setKey(mapKey);
                value = ((Map.Entry)value).getValue();
            } else if (isIndexable) {
                valueContext.setIndex(i);
            }
            if (!context.isAlreadyValidated(value, valueContext.getCurrentGroup(), valueContext.getPropertyPath())) {
                ValidationOrder validationOrder = this.validationOrderGenerator.getValidationOrder(Arrays.asList(valueContext.getCurrentGroup()));
                ValueContext newValueContext = value != null ? ValueContext.getLocalExecutionContext(value, valueContext.getPropertyPath()) : ValueContext.getLocalExecutionContext(valueContext.getCurrentBeanType(), valueContext.getPropertyPath());
                if (valueContext.getParameterIndex() != null) {
                    newValueContext.setParameterIndex(valueContext.getParameterIndex());
                    newValueContext.setParameterName(valueContext.getParameterName());
                }
                this.validateInContext(newValueContext, context, validationOrder);
                if (this.shouldFailFast(context)) {
                    return;
                }
            }
            ++i;
        }
    }

    private <T, U, V> Set<ConstraintViolation<T>> validatePropertyInContext(ValidationContext<T, ConstraintViolation<T>> context, PathImpl propertyPath, ValidationOrder validationOrder) {
        ArrayList<MetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        Iterator<Path.Node> propertyIter = propertyPath.iterator();
        ValueContext<U, V> valueContext = this.collectMetaConstraintsForPath(context.getRootBeanClass(), context.getRootBean(), propertyIter, propertyPath, metaConstraints);
        if (valueContext.getCurrentBean() == null) {
            throw log.getInvalidPropertyPathException();
        }
        if (metaConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getDefiningClass());
            this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group3 : sequence.getComposingGroups()) {
                valueContext.setCurrentGroup(group3.getDefiningClass());
                int numberOfConstraintViolations = this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V> Set<ConstraintViolation<T>> validateValueInContext(ValidationContext<T, ConstraintViolation<T>> context, V value, PathImpl propertyPath, ValidationOrder validationOrder) {
        ArrayList<MetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        ValueContext<U, V> valueContext = this.collectMetaConstraintsForPath(context.getRootBeanClass(), null, propertyPath.iterator(), propertyPath, metaConstraints);
        valueContext.setCurrentValidatedValue(value);
        if (metaConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(null));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getDefiningClass());
            this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group3 : sequence.getComposingGroups()) {
                valueContext.setCurrentGroup(group3.getDefiningClass());
                int numberOfConstraintViolations = this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V> int validatePropertyForCurrentGroup(ValueContext<U, V> valueContext, ValidationContext<T, ConstraintViolation<T>> validationContext, List<MetaConstraint<?>> metaConstraints) {
        if (!valueContext.validatingDefault()) {
            return this.validatePropertyForNonDefaultGroup(valueContext, validationContext, metaConstraints);
        }
        return this.validatePropertyForDefaultGroup(valueContext, validationContext, metaConstraints);
    }

    private <T, U, V> int validatePropertyForNonDefaultGroup(ValueContext<U, V> valueContext, ValidationContext<T, ConstraintViolation<T>> validationContext, List<MetaConstraint<?>> metaConstraints) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        for (MetaConstraint<Object> metaConstraint : metaConstraints) {
            if (!this.isValidationRequired(validationContext, valueContext, metaConstraint)) continue;
            if (valueContext.getCurrentBean() != null) {
                Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
                valueContext.setCurrentValidatedValue(valueToValidate);
            }
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <T, U, V> int validatePropertyForDefaultGroup(ValueContext<U, V> valueContext, ValidationContext<T, ConstraintViolation<T>> validationContext, List<MetaConstraint<?>> constraintList) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<?>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<?> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<?> hostingBeanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
            List<Class<?>> defaultGroupSequence = hostingBeanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean());
            if (defaultGroupSequenceIsRedefined) {
                metaConstraints = hostingBeanMetaData.getMetaConstraints();
            }
            for (Class<?> groupClass : defaultGroupSequence) {
                boolean validationSuccessful = true;
                valueContext.setCurrentGroup(groupClass);
                for (MetaConstraint<Object> metaConstraint : metaConstraints) {
                    Class<?> declaringClass = metaConstraint.getLocation().getBeanClass();
                    if (declaringClass.isInterface()) {
                        Class validatedForClass = (Class)validatedInterfaces.get(declaringClass);
                        if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                        validatedInterfaces.put(declaringClass, clazz);
                    }
                    if (!constraintList.contains(metaConstraint) || !this.isValidationRequired(validationContext, valueContext, metaConstraint)) continue;
                    if (valueContext.getCurrentBean() != null) {
                        Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
                        valueContext.setCurrentValidatedValue(valueToValidate);
                    }
                    boolean tmp = metaConstraint.validateConstraint(validationContext, valueContext);
                    boolean bl = validationSuccessful = validationSuccessful && tmp;
                    if (!this.shouldFailFast(validationContext)) continue;
                    return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
                }
                if (validationSuccessful) continue;
                break;
            }
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <T> void validateParametersInContext(MethodValidationContext<T> validationContext, T object, Object[] parameterValues, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        MethodMetaData methodMetaData = beanMetaData.getMetaDataFor(validationContext.getMethod());
        methodMetaData.assertCorrectnessOfMethodParameterConstraints();
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(object));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateParametersForGroup(validationContext, object, parameterValues, groupIterator.next());
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group2 : sequence.getComposingGroups()) {
                int numberOfFailingConstraint = this.validateParametersForGroup(validationContext, object, parameterValues, group2);
                if (this.shouldFailFast(validationContext)) {
                    return;
                }
                if (numberOfFailingConstraint <= 0) continue;
                continue block1;
            }
        }
    }

    private <T> int validateParametersForGroup(MethodValidationContext<T> validationContext, T object, Object[] parameterValues, Group group2) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        Method method = validationContext.getMethod();
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        MethodMetaData methodMetaData = beanMetaData.getMetaDataFor(method);
        List<Class<Object>> groupList = group2.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence(object) : Arrays.asList(group2.getDefiningClass());
        for (Class<?> oneGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            for (int i = 0; i < parameterValues.length; ++i) {
                if (validationContext.getParameterIndex() != null && !validationContext.getParameterIndex().equals(i)) continue;
                Object value = parameterValues[i];
                String parameterName = methodMetaData.getParameterMetaData(i).getName();
                ValueContext<T, Object> valueContext = ValueContext.getLocalExecutionContext(object, PathImpl.createPathForMethodParameter(method, parameterName), i, parameterName);
                valueContext.setCurrentValidatedValue(value);
                valueContext.setCurrentGroup(oneGroup);
                numberOfViolationsOfCurrentGroup += this.validateParameterForGroup(validationContext, valueContext, methodMetaData.getParameterMetaData(i));
                if (!this.shouldFailFast(validationContext)) continue;
                return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            if (validationContext.getParameterIndex() != null && !validationContext.getParameterIndex().equals(i)) continue;
            Object value = parameterValues[i];
            ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(i);
            String parameterName = parameterMetaData.getName();
            if (!parameterMetaData.isCascading() || value == null) continue;
            ValueContext cascadingvalueContext = ValueContext.getLocalExecutionContext(value, PathImpl.createPathForMethodParameter(method, parameterName), i, parameterName);
            cascadingvalueContext.setCurrentGroup(group2.getDefiningClass());
            this.validateCascadedMethodConstraints(validationContext, cascadingvalueContext);
            if (this.shouldFailFast(validationContext)) break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, U, V> int validateParameterForGroup(MethodValidationContext<T> validationContext, ValueContext<U, V> valueContext, ParameterMetaData parameterMetaData) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        for (MetaConstraint<U> metaConstraint : parameterMetaData) {
            if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <V, T> void validateReturnValueInContext(MethodValidationContext<T> context, T bean, V value, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(context.getRootBeanClass());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(bean));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateReturnValueForGroup(context, bean, value, groupIterator.next());
            if (!this.shouldFailFast(context)) continue;
            return;
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group2 : sequence.getComposingGroups()) {
                int numberOfFailingConstraint = this.validateReturnValueForGroup(context, bean, value, group2);
                if (this.shouldFailFast(context)) {
                    return;
                }
                if (numberOfFailingConstraint <= 0) continue;
                continue block1;
            }
        }
    }

    private <T, V> int validateReturnValueForGroup(MethodValidationContext<T> validationContext, T bean, V value, Group group2) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        Method method = validationContext.getMethod();
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        MethodMetaData methodMetaData = beanMetaData.getMetaDataFor(method);
        List<Class<Object>> groupList = group2.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence(bean) : Arrays.asList(group2.getDefiningClass());
        for (Class<?> oneGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            ValueContext<T, V> valueContext = ValueContext.getLocalExecutionContext(bean, PathImpl.createPathForMethodReturnValue(method));
            valueContext.setCurrentValidatedValue(value);
            valueContext.setCurrentGroup(oneGroup);
            numberOfViolationsOfCurrentGroup += this.validateReturnValueForGroup(validationContext, valueContext, methodMetaData);
            if (this.shouldFailFast(validationContext)) {
                return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        if (methodMetaData.isCascading() && value != null) {
            ValueContext cascadingvalueContext = ValueContext.getLocalExecutionContext(value, PathImpl.createPathForMethodReturnValue(method));
            cascadingvalueContext.setCurrentGroup(group2.getDefiningClass());
            this.validateCascadedMethodConstraints(validationContext, cascadingvalueContext);
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, V> int validateReturnValueForGroup(MethodValidationContext<T> validationContext, ValueContext<T, V> valueContext, MethodMetaData methodMetaData) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        for (MetaConstraint<T> metaConstraint : methodMetaData) {
            if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, U, V> ValueContext<U, V> collectMetaConstraintsForPath(Class<T> clazz, Object value, Iterator<Path.Node> propertyIter, PathImpl propertyPath, List<MetaConstraint<?>> metaConstraintsList) {
        Path.Node elem = propertyIter.next();
        Object newValue = value;
        BeanMetaData<Object> metaData = this.beanMetaDataManager.getBeanMetaData(clazz);
        if (!metaData.isPropertyPresent(elem.getName())) {
            throw log.getInvalidPropertyPathException(elem.getName(), metaData.getBeanClass().getName());
        }
        if (!propertyIter.hasNext()) {
            for (Class<?> hierarchyClass : metaData.getClassHierarchy()) {
                metaData = this.beanMetaDataManager.getBeanMetaData(hierarchyClass);
                for (MetaConstraint<?> constraint : metaData.getDirectMetaConstraints()) {
                    if (elem.getName() == null || !elem.getName().equals(ReflectionHelper.getPropertyName(constraint.getLocation().getMember()))) continue;
                    metaConstraintsList.add(constraint);
                }
            }
        } else {
            Set<Member> cascadedMembers = metaData.getCascadedMembers();
            for (Member m : cascadedMembers) {
                if (!ReflectionHelper.getPropertyName(m).equals(elem.getName())) continue;
                Type type2 = ReflectionHelper.typeOf(m);
                Object object = newValue = newValue == null ? null : ReflectionHelper.getValue(m, newValue);
                if (elem.isInIterable()) {
                    if (newValue != null && elem.getIndex() != null) {
                        newValue = ReflectionHelper.getIndexedValue(newValue, elem.getIndex());
                    } else if (newValue != null && elem.getKey() != null) {
                        newValue = ReflectionHelper.getMappedValue(newValue, elem.getKey());
                    } else if (newValue != null) {
                        throw log.getPropertyPathMustProvideIndexOrMapKeyException();
                    }
                    type2 = ReflectionHelper.getIndexedType(type2);
                }
                Class<?> castedValueClass = newValue == null ? type2 : newValue.getClass();
                Object castedValue = newValue;
                return this.collectMetaConstraintsForPath(castedValueClass, castedValue, propertyIter, propertyPath, metaConstraintsList);
            }
        }
        if (newValue == null) {
            return ValueContext.getLocalExecutionContext(clazz, propertyPath);
        }
        return ValueContext.getLocalExecutionContext(value, propertyPath);
    }

    private TraversableResolver getCachingTraversableResolver() {
        return new SingleThreadCachedTraversableResolver(this.traversableResolver);
    }

    private boolean isValidationRequired(ValidationContext<?, ?> validationContext, ValueContext<?, ?> valueContext, MetaConstraint<?> metaConstraint) {
        boolean isReachable;
        if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) {
            return false;
        }
        if (ElementType.TYPE.equals((Object)metaConstraint.getElementType())) {
            return true;
        }
        PathImpl path = valueContext.getPropertyPath();
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            isReachable = validationContext.getTraversableResolver().isReachable(valueContext.getCurrentBean(), path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, metaConstraint.getElementType());
        }
        catch (RuntimeException e) {
            throw log.getErrorDuringCallOfTraversableResolverIsReachableException(e);
        }
        return isReachable;
    }

    private boolean isCascadeRequired(ValidationContext<?, ?> validationContext, ValueContext<?, ?> valueContext, Member member) {
        boolean isCascadable;
        boolean isReachable;
        ElementType type2 = member instanceof Field ? ElementType.FIELD : ElementType.METHOD;
        PathImpl path = valueContext.getPropertyPath();
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        if (ElementType.TYPE.equals((Object)type2)) {
            isReachable = true;
        } else {
            try {
                isReachable = validationContext.getTraversableResolver().isReachable(valueContext.getCurrentBean(), path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, type2);
            }
            catch (RuntimeException e) {
                throw log.getErrorDuringCallOfTraversableResolverIsReachableException(e);
            }
        }
        if (ElementType.TYPE.equals((Object)type2)) {
            isCascadable = true;
        } else {
            try {
                isCascadable = validationContext.getTraversableResolver().isCascadable(valueContext.getCurrentBean(), path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, type2);
            }
            catch (RuntimeException e) {
                throw log.getErrorDuringCallOfTraversableResolverIsCascadableException(e);
            }
        }
        return isReachable && isCascadable;
    }

    private boolean shouldFailFast(ValidationContext context) {
        return context.isFailFastModeEnabled() && !context.getFailingConstraints().isEmpty();
    }
}

