/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.jvnet.hk2.component.Habitat;

public class InjectionPointHelper {
    private final Habitat habitat;
    private final ComponentEnvManager compEnvManager;
    private final GlassfishNamingManager namingManager;

    public InjectionPointHelper(Habitat h) {
        this.habitat = h;
        this.compEnvManager = this.habitat.getByContract(ComponentEnvManager.class);
        this.namingManager = this.habitat.getByContract(GlassfishNamingManager.class);
    }

    public Object resolveInjectionPoint(Member member, Application app) throws NamingException {
        Annotation[] annotations;
        Object result = null;
        Field field = null;
        Method method = null;
        if (member instanceof Field) {
            field = (Field)member;
            annotations = field.getDeclaredAnnotations();
        } else if (member instanceof Method) {
            method = (Method)member;
            annotations = method.getDeclaredAnnotations();
        } else {
            throw new IllegalArgumentException("Member must be Field or Method");
        }
        Annotation envAnnotation = this.getEnvAnnotation(annotations);
        if (envAnnotation == null) {
            throw new IllegalArgumentException("No Java EE env dependency annotation found on " + member);
        }
        String envAnnotationName = null;
        try {
            Method m = envAnnotation.annotationType().getDeclaredMethod("name", new Class[0]);
            envAnnotationName = (String)m.invoke((Object)envAnnotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid annotation : must have name() attribute " + ((Object)envAnnotation).toString(), e);
        }
        String envDependencyName = envAnnotationName;
        Class<?> declaringClass = member.getDeclaringClass();
        if (envAnnotationName == null || envAnnotationName.equals("")) {
            envDependencyName = field != null ? declaringClass.getName() + "/" + field.getName() : declaringClass.getName() + "/" + this.getInjectionMethodPropertyName(method);
        }
        if (envAnnotationName.startsWith("java:global/")) {
            Context ic = this.namingManager.getInitialContext();
            result = ic.lookup(envAnnotationName);
        } else {
            BundleDescriptor matchingBundle = null;
            for (BundleDescriptor bundle2 : app.getBundleDescriptors()) {
                if (bundle2 instanceof EjbBundleDescriptor || bundle2 instanceof WebBundleDescriptor) {
                    JndiNameEnvironment jndiEnv = (JndiNameEnvironment)((Object)bundle2);
                    for (InjectionCapable next : jndiEnv.getInjectableResourcesByClass(declaringClass.getName())) {
                        if (!next.getComponentEnvName().equals(envDependencyName)) continue;
                        matchingBundle = bundle2;
                        break;
                    }
                }
                if (matchingBundle == null) continue;
                break;
            }
            if (matchingBundle == null) {
                throw new IllegalArgumentException("Cannot find matching env dependency for " + member + " in Application " + app.getAppName());
            }
            String componentId = this.compEnvManager.getComponentEnvId((JndiNameEnvironment)((Object)matchingBundle));
            String lookupName = envDependencyName.startsWith("java:") ? envDependencyName : "java:comp/env/" + envDependencyName;
            result = this.namingManager.lookup(componentId, lookupName);
        }
        return result;
    }

    private String getInjectionMethodPropertyName(Method method) {
        String methodName;
        String propertyName = methodName = method.getName();
        if (methodName.length() <= 3 || !methodName.startsWith("set")) {
            throw new IllegalArgumentException("Illegal env dependency setter name" + method.getName());
        }
        propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        return propertyName;
    }

    private Annotation getEnvAnnotation(Annotation[] annotations) {
        Annotation envAnnotation = null;
        for (Annotation next : annotations) {
            String className = next.annotationType().getName();
            if (!className.equals("javax.ejb.EJB") && !className.equals("javax.annotation.Resource") && !className.equals("javax.persistence.PersistenceContext") && !className.equals("javax.persistence.PersistenceUnit") && !className.equals("javax.xml.ws.WebServiceRef")) continue;
            envAnnotation = next;
            break;
        }
        return envAnnotation;
    }
}

