/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.reader.api.LbReaderException;
import org.glassfish.loadbalancer.admin.cli.reader.api.WebModuleReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.WebModuleReaderImpl;
import org.glassfish.loadbalancer.admin.cli.reader.impl.WebServiceEndpointReaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterReaderHelper {
    public static WebModuleReader[] getWebModules(Domain domain, ApplicationRegistry appRegistry, List<ApplicationRef> refs, String target) {
        ArrayList<WebModuleReader> list = new ArrayList<WebModuleReader>();
        HashSet<String> contextRoots = new HashSet<String>();
        Iterator<ApplicationRef> refAppsIter = refs.iterator();
        HashMap<String, ApplicationRef> refferedApps = new HashMap<String, ApplicationRef>();
        while (refAppsIter.hasNext()) {
            ApplicationRef appRef = refAppsIter.next();
            refferedApps.put(appRef.getRef(), appRef);
        }
        Applications applications = domain.getApplications();
        HashSet<com.sun.enterprise.config.serverbeans.Application> apps = new HashSet<com.sun.enterprise.config.serverbeans.Application>();
        apps.addAll(applications.getApplicationsWithSnifferType("web"));
        apps.addAll(applications.getApplicationsWithSnifferType("webservices"));
        for (com.sun.enterprise.config.serverbeans.Application app : apps) {
            String appName = app.getName();
            if (!refferedApps.containsKey(appName)) continue;
            ApplicationInfo appInfo = appRegistry.get(appName);
            if (appInfo == null) {
                String msg = LbLogUtil.getStringManager().getString("UnableToGetAppInfo", appName);
                LbLogUtil.getLogger().log(Level.WARNING, msg);
                continue;
            }
            Application depApp = appInfo.getMetaData(Application.class);
            for (BundleDescriptor bundleDescriptor : depApp.getBundleDescriptors()) {
                try {
                    EjbBundleDescriptor ejbBundleDescriptor;
                    if (bundleDescriptor instanceof WebBundleDescriptor) {
                        WebModuleReaderImpl wmr = new WebModuleReaderImpl(appName, (ApplicationRef)refferedApps.get(appName), app, (WebBundleDescriptor)bundleDescriptor);
                        if (contextRoots.contains(wmr.getContextRoot())) continue;
                        contextRoots.add(wmr.getContextRoot());
                        list.add(wmr);
                        continue;
                    }
                    if (!(bundleDescriptor instanceof EjbBundleDescriptor) || !(ejbBundleDescriptor = (EjbBundleDescriptor)bundleDescriptor).hasWebServices()) continue;
                    Iterator<WebServiceEndpoint> wsIter = ejbBundleDescriptor.getWebServices().getEndpoints().iterator();
                    while (wsIter.hasNext()) {
                        WebServiceEndpointReaderImpl wsr = new WebServiceEndpointReaderImpl(appName, (ApplicationRef)refferedApps.get(appName), app, wsIter.next());
                        if (contextRoots.contains(wsr.getContextRoot())) continue;
                        contextRoots.add(wsr.getContextRoot());
                        list.add(wsr);
                    }
                }
                catch (LbReaderException ex) {
                    String msg = LbLogUtil.getStringManager().getString("UnableToGetContextRoot", appName, ex.getMessage());
                    LbLogUtil.getLogger().log(Level.WARNING, msg);
                    if (!LbLogUtil.getLogger().isLoggable(Level.FINE)) continue;
                    LbLogUtil.getLogger().log(Level.FINE, "Exception when getting context root for application", ex);
                }
            }
        }
        contextRoots.clear();
        WebModuleReader[] webModules = new WebModuleReader[list.size()];
        return list.toArray(webModules);
    }
}

