/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.helper;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import java.io.OutputStream;
import java.util.Date;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.beans.Loadbalancer;
import org.glassfish.loadbalancer.admin.cli.reader.api.LoadbalancerReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.LoadbalancerReaderImpl;
import org.glassfish.loadbalancer.admin.cli.transform.LoadbalancerVisitor;

public class LbConfigHelper {
    private static final String PUBLICID = "-//Sun Microsystems Inc.//DTD Sun Java System Application Server 9.1//EN";
    private static final String SYSTEMID = "glassfish-loadbalancer_1_3.dtd";

    public static LoadbalancerReader getLbReader(Domain domain, ApplicationRegistry appRegistry, String lbConfigName) throws Exception {
        LbConfig lbConfig = domain.getLbConfigs().getLbConfig(lbConfigName);
        if (lbConfig == null) {
            throw new Exception(LbLogUtil.getStringManager().getString("UnableToGetLbConfig", lbConfigName));
        }
        return new LoadbalancerReaderImpl(domain, appRegistry, lbConfig);
    }

    public static LoadBalancer getLoadBalancer(Domain domain, String lbName) throws Exception {
        LoadBalancer loadBalancer = domain.getLoadBalancers().getLoadBalancer(lbName);
        if (loadBalancer == null) {
            throw new Exception(LbLogUtil.getStringManager().getString("UnableToGetLoadbalancer", lbName));
        }
        return loadBalancer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportXml(LoadbalancerReader lbRdr, OutputStream out) throws Exception {
        Loadbalancer _lb = new Loadbalancer();
        LoadbalancerVisitor lbVstr = new LoadbalancerVisitor(_lb);
        lbRdr.accept(lbVstr);
        try {
            String footer = LbLogUtil.getStringManager().getString("GeneratedFileFooter", new Date().toString());
            _lb.graphManager().setDoctype(PUBLICID, SYSTEMID);
            _lb.write(out);
            out.write(footer.getBytes());
            Object var6_5 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            out.close();
            out = null;
            throw throwable;
        }
        out.close();
    }
}

