/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable-http-lb-application")
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
public final class DisableHTTPLBApplicationCommand
implements AdminCommand {
    @Param(primary=true)
    String target;
    @Param(optional=false)
    String name;
    @Param(optional=true, defaultValue="30")
    String timeout;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableHTTPLBApplicationCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ApplicationRef appRef = this.domain.getApplicationRefInTarget(this.name, this.target);
        if (appRef == null) {
            String msg = localStrings.getLocalString("AppRefNotDefined", "Application ref [{0}] does not exist in server [{1}]", this.name, this.target);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        boolean appEnabled = Boolean.valueOf(appRef.getEnabled());
        if (appEnabled) {
            if (appRef.getLbEnabled().equals("false")) {
                String msg = localStrings.getLocalString("AppDisabled", "Application [{0}] is already disabled for [{1}].", this.name, this.target);
                logger2.warning(msg);
                report.setMessage(msg);
            } else {
                try {
                    this.updateLbEnabledForApp(this.name, this.target, this.timeout);
                }
                catch (TransactionFailure e) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", this.name);
                    logger2.warning(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    report.setFailureCause(e);
                }
            }
        }
    }

    public void updateLbEnabledForApp(final String appName, final String target, final String timeout) throws TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction(param);
                if (t != null) {
                    Cluster cluster;
                    Server servr = ((Domain)param).getServerNamed(target);
                    if (servr != null) {
                        for (ApplicationRef appRef : servr.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ApplicationRef appRef_w = t.enroll(appRef);
                            appRef_w.setLbEnabled("false");
                            appRef_w.setDisableTimeoutInMinutes(timeout);
                            break;
                        }
                    }
                    if ((cluster = ((Domain)param).getClusterNamed(target)) != null) {
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ApplicationRef appRef_w = t.enroll(appRef);
                            appRef_w.setLbEnabled("false");
                            appRef_w.setDisableTimeoutInMinutes(timeout);
                            break;
                        }
                        block2: for (Server svr : cluster.getInstances()) {
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ApplicationRef appRef_w = t.enroll(appRef);
                                appRef_w.setLbEnabled("false");
                                appRef_w.setDisableTimeoutInMinutes(timeout);
                                continue block2;
                            }
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, this.domain);
    }
}

