/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.grizzly;

import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.http.mapper.Mapper;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractProvided(value=Mapper.class)
public class ContextMapper
extends Mapper {
    protected final Logger logger;
    protected Adapter adapter;
    protected String id;

    public ContextMapper() {
        this(Logger.getAnonymousLogger());
    }

    public ContextMapper(Logger logger2) {
        this.logger = logger2;
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard, String servletName, boolean isEmptyPathSpecial) {
        super.addWrapper(hostName, contextPath, path, wrapper, jspWildCard, servletName, isEmptyPathSpecial);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Wrapper-Host: " + hostName + " contextPath " + contextPath + " wrapper " + wrapper + " path " + path + " jspWildcard " + jspWildCard + " servletName " + servletName + " isEmptyPathSpecial " + isEmptyPathSpecial);
        }
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        super.addHost(name, aliases, host);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Host-Host: " + name + " aliases " + Arrays.toString(aliases) + " host " + host);
        }
    }

    public void addContext(String hostName, String path, Object context, String[] welcomeResources, Context resources) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Context-Host: " + hostName + " path " + path + " context " + context + " port " + this.getPort());
        }
        if (this.adapter != null && "org.apache.catalina.connector.CoyoteAdapter".equals(this.adapter.getClass().getName())) {
            this.removeContext(hostName, path);
        }
        super.addContext(hostName, path, context, welcomeResources, resources);
    }

    public synchronized void removeHost(String name) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Faking removal of host: " + name);
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

