/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.bootstrap;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
public class GMSAdapterService
implements Startup,
PostConstruct,
ConfigListener {
    static final Logger logger = LogDomains.getLogger(GMSAdapterService.class, "javax.enterprise.system.core");
    private static final StringManager strings = StringManager.getManager(GMSAdapterService.class);
    private static final String GMS_ENABLED = "GMS_ENABLED";
    private static final String SEED_LIST = "GMS_" + (Object)((Object)ServiceProviderConfigurationKeys.DISCOVERY_URI_LIST);
    private static final String CLUSTER_NAME_PROPERTY = "cluster-name";
    @Inject
    Clusters clusters;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    @Inject
    StartupContext startupContext;
    private static final Object lock = new Object();
    List<GMSAdapter> gmsAdapters = new LinkedList<GMSAdapter>();
    private static final Level TRACE_LEVEL = Level.FINE;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        Properties args;
        if (this.startupContext != null && (args = this.startupContext.getArguments()) != null && Boolean.valueOf(args.getProperty("-upgrade")).booleanValue()) {
            return;
        }
        if (this.server.isClusteredDas()) {
            logger.setLevel(TRACE_LEVEL);
            logger.log(TRACE_LEVEL, "Turning on trace logging during development. Will remove this once we're stable.");
            this.checkServerConfig(this.server.getConfig());
        } else if (this.clusters != null) {
            if (this.env.isDas()) {
                this.checkAllClusters(this.clusters);
            } else {
                Cluster cluster = this.server.getCluster();
                if (cluster != null) {
                    this.checkCluster(cluster);
                }
            }
        }
    }

    public String toString() {
        return "GMS Loader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GMSAdapter getGMSAdapter() {
        Object object = lock;
        synchronized (object) {
            if (this.gmsAdapters.size() > 1) {
                throw new IllegalStateException(strings.getString("use.getByName"));
            }
            if (this.gmsAdapters.size() == 1) {
                return this.gmsAdapters.get(0);
            }
            return null;
        }
    }

    public boolean isGmsEnabled() {
        return this.gmsAdapters.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GMSAdapter getGMSAdapterByName(String clusterName) {
        Object object = lock;
        synchronized (object) {
            return this.habitat.getComponent(GMSAdapter.class, clusterName);
        }
    }

    private void checkAllClusters(Clusters clusters) {
        if (logger.isLoggable(TRACE_LEVEL)) {
            logger.log(TRACE_LEVEL, "In DAS. Checking all clusters.");
        }
        for (Cluster cluster : clusters.getCluster()) {
            this.checkCluster(cluster);
        }
    }

    private GMSAdapter checkCluster(Cluster cluster) {
        GMSAdapter result = null;
        String gmsEnString = cluster.getGmsEnabled();
        if (logger.isLoggable(TRACE_LEVEL)) {
            logger.log(TRACE_LEVEL, String.format("cluster %s found with gms-enabled='%s'", cluster.getName(), gmsEnString));
        }
        if (gmsEnString != null && Boolean.parseBoolean(gmsEnString)) {
            result = this.loadModule(cluster.getName());
        }
        return result;
    }

    private void checkServerConfig(Config config) {
        com.sun.enterprise.config.serverbeans.GroupManagementService gms = config.getGroupManagementService();
        boolean gmsEnabled = false;
        String seedList = null;
        for (Property prop : gms.getProperty()) {
            if (GMS_ENABLED.equals(prop.getName())) {
                gmsEnabled = Boolean.valueOf(prop.getValue());
                continue;
            }
            if (!SEED_LIST.equals(prop.getName())) continue;
            seedList = prop.getValue();
        }
        if (gmsEnabled) {
            if (seedList == null) {
                logger.log(Level.WARNING, "gmsadapter.null.seedlist");
                return;
            }
            String clusterName = this.server.getPropertyValue(CLUSTER_NAME_PROPERTY);
            if (clusterName == null || clusterName.isEmpty()) {
                logger.log(Level.WARNING, "gmsadapter.null.clustername");
                return;
            }
            this.loadModule(clusterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GMSAdapter loadModule(String name) {
        GMSAdapter result = null;
        Object object = lock;
        synchronized (object) {
            result = this.getGMSAdapterByName(name);
            if (logger.isLoggable(TRACE_LEVEL)) {
                logger.log(TRACE_LEVEL, "lookup GMSAdapter by clusterName=" + name + " returned " + result);
            }
            if (result == null) {
                if (logger.isLoggable(TRACE_LEVEL)) {
                    logger.log(TRACE_LEVEL, "creating gms-adapter for clustername " + name + " since no gms adapter found for clustername " + name);
                }
                if ((result = this.habitat.getByContract(GMSAdapter.class)) == null) {
                    logger.log(Level.WARNING, "gmsadapter.not.available");
                    return null;
                }
                boolean initResult = result.initialize(name);
                if (!initResult) {
                    return null;
                }
                this.habitat.addIndex(new ExistingSingletonInhabitant<GMSAdapter>(result), GMSAdapter.class.getName(), name);
                if (logger.isLoggable(TRACE_LEVEL)) {
                    logger.log(TRACE_LEVEL, "loadModule: registered created gmsadapter for cluster " + name + " initialized result=" + initResult);
                }
                this.gmsAdapters.add(result);
            }
        }
        return result;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        if (this.env.isDas()) {
            return ConfigSupport.sortAndDispatch(events, new Changed(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
                    Cluster cluster;
                    if (changedType == Cluster.class && type2 == Changed.TYPE.ADD) {
                        GroupManagementService gms;
                        GMSAdapter localGmsAdapter;
                        cluster = (Cluster)changedInstance;
                        if (logger.isLoggable(TRACE_LEVEL)) {
                            logger.log(TRACE_LEVEL, "ClusterChangeEvent add cluster " + cluster.getName());
                        }
                        if ((localGmsAdapter = GMSAdapterService.this.checkCluster(cluster)) != null && (gms = localGmsAdapter.getModule()) != null) {
                            gms.reportJoinedAndReadyState();
                        }
                    }
                    if (changedType == Cluster.class && type2 == Changed.TYPE.REMOVE) {
                        cluster = (Cluster)changedInstance;
                        if (logger.isLoggable(TRACE_LEVEL)) {
                            logger.log(TRACE_LEVEL, "ClusterChangeEvent remove cluster " + cluster.getName());
                        }
                        Object object = lock;
                        synchronized (object) {
                            GMSAdapter localGmsAdapter = GMSAdapterService.this.getGMSAdapterByName(cluster.getName());
                            if (localGmsAdapter != null) {
                                GMSAdapterService.this.gmsAdapters.remove(localGmsAdapter);
                                localGmsAdapter.getModule().shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                                boolean result = GMSAdapterService.this.habitat.removeIndex(GMSAdapter.class.getName(), localGmsAdapter);
                                if (logger.isLoggable(TRACE_LEVEL)) {
                                    logger.log(TRACE_LEVEL, "removeIndex(" + GMSAdapter.class.getName() + ") returned result of " + result);
                                }
                                localGmsAdapter.complete();
                            }
                        }
                    }
                    return null;
                }
            }, logger);
        }
        return null;
    }
}

