/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.transformer;

import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.impl.client.AgentAttacher;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeProviderClassFileTransformer
implements ClassFileTransformer {
    private static final Instrumentation instrumentation;
    private static boolean _debug;
    private final Class providerClass;
    private Map<String, FlashlightProbe> probes = new HashMap<String, FlashlightProbe>();
    private ClassWriter cw;
    private static final Logger logger;
    private static boolean emittedAttachUnavailableMessageAlready;
    private static final String AGENT_CLASSNAME = "org.glassfish.flashlight.agent.ProbeAgentMain";

    public ProbeProviderClassFileTransformer(Class providerClass) {
        this.providerClass = providerClass;
    }

    public void regProbe(FlashlightProbe probe) throws NoSuchMethodException {
        java.lang.reflect.Method m = this.getMethod(probe);
        this.probes.put(probe.getProviderJavaMethodName() + "::" + Type.getMethodDescriptor(m), probe);
    }

    public void transform() {
        try {
            if (instrumentation != null) {
                instrumentation.addTransformer(this, true);
                instrumentation.retransformClasses(this.providerClass);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error during re-transformation", e);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (AgentAttacher.canAttach() && classBeingRedefined == this.providerClass) {
                this.cw = new ClassWriter(3);
                ClassReader cr = new ClassReader(classfileBuffer);
                cr.accept(new ProbeProviderClassVisitor(this.cw), null, 0);
                classfileBuffer = this.cw.toByteArray();
                if (_debug) {
                    ProbeProviderClassFileTransformer.writeFile(className.substring(className.lastIndexOf(47) + 1), classfileBuffer);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error during registration of FlashlightProbe", ex);
        }
        return classfileBuffer;
    }

    private static String makeKey(String name, String desc) {
        return name + "::" + desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeFile(String name, byte[] data) {
        FileOutputStream fos = null;
        try {
            File installRoot = new File(System.getProperty("com.sun.aas.installRoot"));
            File dir = new File(installRoot, "flashlight-generated");
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new RuntimeException("Can't create directory: " + dir);
            }
            fos = new FileOutputStream(new File(dir, name + ".class"));
            fos.write(data);
        }
        catch (Throwable th) {
            logger.log(Level.INFO, "Couldn't write the retransformed class data", th);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private java.lang.reflect.Method getMethod(FlashlightProbe probe) throws NoSuchMethodException {
        java.lang.reflect.Method m = probe.getProbeMethod();
        if (m == null) {
            m = probe.getProviderClazz().getDeclaredMethod(probe.getProviderJavaMethodName(), probe.getParamTypes());
            probe.setProbeMethod(m);
        }
        return m;
    }

    static {
        _debug = Boolean.parseBoolean(Utility.getEnvOrProp("AS_DEBUG"));
        logger = Logger.getLogger(ProbeProviderClassFileTransformer.class.getName());
        emittedAttachUnavailableMessageAlready = false;
        Instrumentation nonFinalInstrumentation = null;
        Throwable throwable = null;
        Class<?> agentMainClass = null;
        boolean canAttach = false;
        if (AgentAttacher.canAttach()) {
            canAttach = true;
            try {
                ProbeProviderClassFileTransformer.class.getClassLoader();
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                try {
                    agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
                }
                catch (Throwable t) {
                    AgentAttacher.attachAgent();
                    agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
                }
                java.lang.reflect.Method mthd = agentMainClass.getMethod("getInstrumentation", null);
                nonFinalInstrumentation = (Instrumentation)mthd.invoke(null, null);
            }
            catch (Throwable t) {
                nonFinalInstrumentation = null;
                throwable = t;
            }
        }
        instrumentation = nonFinalInstrumentation;
        if (!canAttach) {
            logger.warning("Monitoring is disabled because there is no Attach API from the JVM available.");
        } else if (instrumentation != null) {
            logger.log(Level.INFO, "Successfully got INSTRUMENTATION: " + instrumentation);
        } else if (throwable != null) {
            logger.log(Level.WARNING, "Error while getting Instrumentation object from ProbeAgentmain", throwable);
        } else {
            logger.log(Level.WARNING, "Error while getting Instrumentation object from ProbeAgentmain");
        }
    }

    private class ProbeProviderMethodVisitor
    extends MethodAdapter {
        private FlashlightProbe probe;
        private int access;
        private String name;
        private String desc;

        ProbeProviderMethodVisitor(MethodVisitor mv, int access, String name, String desc, FlashlightProbe probe) {
            super(mv);
            this.probe = probe;
            this.access = access;
            this.name = name;
            this.desc = desc;
        }

        public void visitCode() {
            super.visitCode();
            GeneratorAdapter gen = new GeneratorAdapter(this.mv, this.access, this.name, this.desc);
            gen.push(this.probe.getId());
            gen.loadArgArray();
            gen.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("void invokeProbe(int, Object[])"));
        }
    }

    private class ProbeProviderClassVisitor
    extends ClassAdapter {
        ProbeProviderClassVisitor(ClassVisitor cv) {
            super(cv);
            for (String methodDesc : ProbeProviderClassFileTransformer.this.probes.keySet()) {
                logger.log(Level.FINE, "ProbeProviderClassVisitor will visit" + methodDesc);
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            FlashlightProbe probe = (FlashlightProbe)ProbeProviderClassFileTransformer.this.probes.get(ProbeProviderClassFileTransformer.makeKey(name, desc));
            if (probe != null) {
                mv = new ProbeProviderMethodVisitor(mv, access, name, desc, probe);
            }
            return mv;
        }
    }
}

