/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.provider;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.provider.FlashlightProbe;

class DTraceMethodFinder {
    private static final Logger logger = LogDomains.getLogger(DTraceMethodFinder.class, "javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DTraceMethodFinder.class);
    private final FlashlightProbe probe;
    private final Object targetObject;
    private final Class targetClass;
    private final int numProbeParams;
    private Method method;
    private Class[] probeParamTypes;

    DTraceMethodFinder(FlashlightProbe p, Object t) {
        this.probe = p;
        this.targetObject = t;
        this.targetClass = this.targetObject.getClass();
        this.probeParamTypes = this.probe.getParamTypes();
        if (this.probeParamTypes == null) {
            this.probeParamTypes = new Class[0];
        }
        this.numProbeParams = this.probeParamTypes.length;
    }

    Method matchMethod() {
        String metname = this.probe.getProviderJavaMethodName();
        if (this.probe.isHidden()) {
            throw new RuntimeException(localStrings.getLocalString("dtrace_cantfind", "The probe is  hidden.  DTrace will ignore it.", metname));
        }
        for (Method m : this.targetClass.getMethods()) {
            Class[] paramTypes;
            if (!m.getName().equals(metname) || (paramTypes = m.getParameterTypes()).length != this.numProbeParams || !this.compareParams(this.probeParamTypes, paramTypes)) continue;
            return m;
        }
        String errStr = localStrings.getLocalString("dtrace_cantfind", "Can not match the Probe method ({0}) with any method in the DTrace object.", metname);
        throw new RuntimeException(errStr);
    }

    private boolean compareParams(Class[] probep, Class[] dtracep) {
        for (int i = 0; i < probep.length; ++i) {
            Class probeClass = probep[i];
            Class dtraceClass = dtracep[i];
            if (probeClass.equals(dtraceClass) || dtraceClass.equals(String.class) && !FlashlightUtils.isIntegral(probeClass) || FlashlightUtils.compareIntegral(dtraceClass, probeClass)) continue;
            return false;
        }
        return true;
    }
}

