/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.AbstractSingletonContainer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.startup.SingletonLifeCycleManager;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ejb")
@Scoped(value=PerLookup.class)
public class EjbApplication
implements ApplicationContainer<Collection<EjbDescriptor>> {
    private static final Logger _logger = LogDomains.getLogger(EjbApplication.class, "javax.enterprise.system.container.ejb");
    private EjbBundleDescriptor ejbBundle;
    private Collection<EjbDescriptor> ejbs;
    private Collection<Container> containers = new ArrayList<Container>();
    private ClassLoader ejbAppClassLoader;
    private DeploymentContext dc;
    private Habitat habitat;
    private EJBSecurityManagerFactory ejbSMF;
    private ContainerFactory ejbContainerFactory;
    private SingletonLifeCycleManager singletonLCM;
    boolean usesEJBTimerService = false;
    private PolicyLoader policyLoader;
    private boolean initializeInOrder;
    private volatile boolean started;
    private static final String CONTAINER_LIST_KEY = "org.glassfish.ejb.startup.EjbContainerList";
    private static final String EJB_APP_MARKED_AS_STARTED_STATUS = "org.glassfish.ejb.startup.EjbApplicationMarkedAsStarted";
    static final String KEEP_STATE = "org.glassfish.ejb.startup.keepstate";

    public EjbApplication(EjbBundleDescriptor bundle2, DeploymentContext dc, ClassLoader cl, Habitat habitat, EJBSecurityManagerFactory ejbSecMgrFactory) {
        this.ejbBundle = bundle2;
        this.ejbs = bundle2.getEjbs();
        this.ejbAppClassLoader = cl;
        this.dc = dc;
        this.habitat = habitat;
        this.ejbContainerFactory = habitat.getByContract(ContainerFactory.class);
        this.ejbSMF = ejbSecMgrFactory;
        this.policyLoader = habitat.getComponent(PolicyLoader.class);
        Application app = this.ejbBundle.getApplication();
        this.initializeInOrder = app != null && app.isInitializeInOrder();
    }

    @Override
    public Collection<EjbDescriptor> getDescriptor() {
        return this.ejbs;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        return this.ejbBundle;
    }

    public boolean isStarted() {
        return this.started;
    }

    void markAllContainersAsStarted() {
        for (Container container : this.containers) {
            container.setStartedState();
        }
    }

    @Override
    public boolean start(ApplicationContext startupContext) throws Exception {
        Boolean alreadyMarked;
        this.started = true;
        if (!this.initializeInOrder && !(alreadyMarked = this.dc.getTransientAppMetaData(EJB_APP_MARKED_AS_STARTED_STATUS, Boolean.class)).booleanValue()) {
            List ejbAppList = this.dc.getTransientAppMetaData(CONTAINER_LIST_KEY, List.class);
            for (EjbApplication app : ejbAppList) {
                app.markAllContainersAsStarted();
            }
            this.dc.addTransientAppMetaData(EJB_APP_MARKED_AS_STARTED_STATUS, Boolean.TRUE);
        }
        try {
            DeployCommandParameters params = ((DeploymentContext)startupContext).getCommandParameters(DeployCommandParameters.class);
            for (Container container : this.containers) {
                container.startApplication(params.origin.isDeploy());
            }
            this.singletonLCM.doStartup(this);
        }
        catch (Exception e) {
            this.abortInitializationAfterException();
            throw e;
        }
        return true;
    }

    boolean loadContainers(ApplicationContext startupContext) {
        DeploymentContext dc = (DeploymentContext)startupContext;
        DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
        String dcMapToken = "org.glassfish.ejb.startup.SingletonLCM";
        this.singletonLCM = dc.getTransientAppMetaData(dcMapToken, SingletonLifeCycleManager.class);
        if (this.singletonLCM == null) {
            this.singletonLCM = new SingletonLifeCycleManager(this.initializeInOrder);
            dc.addTransientAppMetaData(dcMapToken, this.singletonLCM);
        }
        if (!this.initializeInOrder) {
            dc.addTransientAppMetaData(EJB_APP_MARKED_AS_STARTED_STATUS, Boolean.FALSE);
            ArrayList<EjbApplication> ejbAppList = dc.getTransientAppMetaData(CONTAINER_LIST_KEY, List.class);
            if (ejbAppList == null) {
                ejbAppList = new ArrayList<EjbApplication>();
                dc.addTransientAppMetaData(CONTAINER_LIST_KEY, ejbAppList);
            }
            ejbAppList.add(this);
        }
        try {
            this.policyLoader.loadPolicy();
            Object moduleName = null;
            for (EjbDescriptor desc : this.ejbs) {
                EJBSecurityManager ejbSM = null;
                ejbSM = this.ejbSMF.createManager(desc, true);
                Container container = this.ejbContainerFactory.createContainer(desc, this.ejbAppClassLoader, ejbSM, dc);
                this.containers.add(container);
                if (!(container instanceof AbstractSingletonContainer)) continue;
                this.singletonLCM.addSingletonContainer(this, (AbstractSingletonContainer)container);
            }
        }
        catch (Throwable t) {
            this.abortInitializationAfterException();
            throw new RuntimeException("EJB Container initialization error", t);
        }
        return true;
    }

    @Override
    public boolean stop(ApplicationContext stopContext) {
        boolean undeploy;
        DeploymentContext depc = (DeploymentContext)stopContext;
        OpsParams params = depc.getCommandParameters(OpsParams.class);
        boolean keepState = false;
        if (params.origin.isUndeploy() && (keepState = this.resolveKeepStateOptions(depc, false, this.ejbBundle))) {
            Properties appProps = depc.getAppProps();
            Object appId = appProps.get("org.glassfish.ejb.container.application_unique_id");
            Properties actionReportProps = null;
            if (this.ejbBundle.getApplication().isVirtual()) {
                actionReportProps = depc.getActionReport().getExtraProperties();
            } else {
                ExtendedDeploymentContext exdc = (ExtendedDeploymentContext)depc;
                actionReportProps = exdc.getParentContext().getActionReport().getExtraProperties();
            }
            actionReportProps.put("org.glassfish.ejb.container.application_unique_id", appId);
            actionReportProps.put(KEEP_STATE, String.valueOf(true));
            _logger.log(Level.INFO, "keepstate options resolved to true, saving appId {0} for application {1}.", new Object[]{appId, params.name()});
        }
        boolean bl = undeploy = params.origin.isUndeploy() || params.origin.isDeploy();
        if (undeploy) {
            ApplicationRegistry appRegistry = this.habitat.getComponent(ApplicationRegistry.class);
            ApplicationInfo appInfo = appRegistry.get(params.name());
            appInfo.addTransientAppMetaData(KEEP_STATE, keepState);
            this.ejbBundle.getApplication().setKeepStateResolved(String.valueOf(keepState));
        }
        this.singletonLCM.doShutdown();
        for (Container container : this.containers) {
            if (undeploy) {
                container.undeploy();
            } else {
                container.onShutdown();
            }
            if (container.getSecurityManager() == null) continue;
            container.getSecurityManager().destroy();
        }
        this.containers.clear();
        return true;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean resume() {
        return false;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.ejbAppClassLoader;
    }

    boolean containsTimedObject() {
        for (Container container : this.containers) {
            if (!container.isTimedObject()) continue;
            return true;
        }
        return false;
    }

    private void abortInitializationAfterException() {
        for (Container container : this.containers) {
            container.undeploy();
        }
    }

    private boolean resolveKeepStateOptions(DeploymentContext deployContext, boolean isDeploy, EjbBundleDescriptor bundleDesc) {
        Boolean isredeploy = Boolean.FALSE;
        Boolean keepState = null;
        if (isDeploy) {
            DeployCommandParameters dcp = deployContext.getCommandParameters(DeployCommandParameters.class);
            if (dcp != null) {
                isredeploy = dcp.isredeploy;
                keepState = dcp.keepstate;
            }
        } else {
            UndeployCommandParameters ucp = deployContext.getCommandParameters(UndeployCommandParameters.class);
            if (ucp != null) {
                isredeploy = ucp.isredeploy;
                keepState = ucp.keepstate;
            }
        }
        if (!isredeploy.booleanValue()) {
            return false;
        }
        if (keepState == null) {
            Application app = bundleDesc.getApplication();
            keepState = app.getKeepState();
        }
        return keepState;
    }
}

