/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public abstract class AutoOperation {
    static final Logger sLogger = LogDomains.getLogger(DeploymentUtils.class, "javax.enterprise.system.tools.deployment");
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AutoDeployer.class);
    private static final String[] autoDeployFileSuffixes = new String[]{"_deployed", "_deployFailed", "_undeployed", "_undeployFailed", "_pending"};
    private File file;
    private Properties props;
    private String commandName;
    private AdminCommand command;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private AutodeployRetryManager retryManager;

    AutoOperation init(File file, Properties props, String commandName, AdminCommand command) {
        this.file = file;
        this.props = props;
        this.commandName = commandName;
        this.command = command;
        return this;
    }

    protected abstract void markFiles(AutoDeployer.AutodeploymentStatus var1, File var2);

    protected abstract String getMessageString(AutoDeployer.AutodeploymentStatus var1, File var2);

    final AutoDeployer.AutodeploymentStatus run() throws AutoDeploymentException {
        try {
            ParameterMap p = new ParameterMap();
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                p.set((String)entry.getKey(), (String)entry.getValue());
            }
            ActionReport report = this.commandRunner.getActionReport("hk2-agent");
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(this.commandName, report);
            inv.parameters(p).execute(this.command);
            AutoDeployer.AutodeploymentStatus ds = AutoDeployer.AutodeploymentStatus.forExitCode(report.getActionExitCode());
            Level messageLevel = ds.status ? Level.INFO : Level.WARNING;
            sLogger.log(messageLevel, this.getMessageString(ds, this.file));
            this.markFiles(ds, this.file);
            ds = this.retryManager.chooseAutodeploymentStatus(report.getActionExitCode(), this.file);
            return ds;
        }
        catch (Exception ex) {
            sLogger.log(Level.SEVERE, "Error occurred: ", ex);
            return AutoDeployer.AutodeploymentStatus.FAILURE;
        }
    }

    private File getSuffixedFile(File f, String suffix) {
        String absPath = f.getAbsolutePath();
        File ret = new File(absPath + suffix);
        return ret;
    }

    protected File getDeployedFile(File f) {
        return this.getSuffixedFile(f, "_deployed");
    }

    protected File getDeployFailedFile(File f) {
        return this.getSuffixedFile(f, "_deployFailed");
    }

    protected File getUndeployedFile(File f) {
        return this.getSuffixedFile(f, "_undeployed");
    }

    protected File getUndeployFailedFile(File f) {
        return this.getSuffixedFile(f, "_undeployFailed");
    }

    protected void deleteAllMarks(File f) {
        try {
            for (String suffix : autoDeployFileSuffixes) {
                this.getSuffixedFile(f, suffix).delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

