/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.security.store.PasswordAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatedConfigView
implements ConfigView {
    static final Pattern p = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}([^\\$]*)");
    private static final String ALIAS_TOKEN = "ALIAS";
    final ConfigView masterView;
    static Habitat habitat;

    public static Object getTranslatedValue(Object value) {
        if (value != null && value instanceof String) {
            String stringValue = value.toString();
            if (stringValue.indexOf(36) == -1) {
                return value;
            }
            MasterPassword masterpasswd = habitat.getByContract(MasterPassword.class);
            if (masterpasswd != null && TranslatedConfigView.getAlias(stringValue) != null) {
                try {
                    return TranslatedConfigView.getRealPasswordFromAlias(masterpasswd, stringValue);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().severe("Error in dealiasing the password " + e.getLocalizedMessage());
                    return stringValue;
                }
            }
            Matcher m = p.matcher(stringValue);
            while (m.find()) {
                String newValue = System.getProperty(m.group(2).trim());
                if (newValue == null) continue;
                stringValue = m.replaceFirst(Matcher.quoteReplacement(m.group(1) + System.getProperty(m.group(2).trim()) + m.group(3)));
                m.reset(stringValue);
            }
            return stringValue;
        }
        return value;
    }

    TranslatedConfigView(ConfigView master) {
        this.masterView = master;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return TranslatedConfigView.getTranslatedValue(this.masterView.invoke(proxy, method, args));
    }

    @Override
    public ConfigView getMasterView() {
        return this.masterView;
    }

    @Override
    public void setMasterView(ConfigView view) {
    }

    @Override
    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.masterView.getProxyType();
    }

    @Override
    public <T extends ConfigBeanProxy> T getProxy(Class<T> proxyType) {
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)this)));
    }

    public static void setHabitat(Habitat h) {
        habitat = h;
    }

    public static String getAlias(String propName) {
        int lastIdx;
        String aliasName = null;
        String starter = "${ALIAS=";
        String ender = "}";
        if ((propName = propName.trim()).startsWith(starter) && propName.endsWith(ender) && (lastIdx = (propName = propName.substring(starter.length())).length() - 1) > 1 && (propName = propName.substring(0, lastIdx)) != null) {
            aliasName = propName.trim();
        }
        return aliasName;
    }

    public static String getRealPasswordFromAlias(MasterPassword masterPasswordHelper, String at) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String an = TranslatedConfigView.getAlias(at);
        PasswordAdapter pa = masterPasswordHelper.getMasterPasswordAdapter();
        boolean exists = pa.aliasExists(an);
        if (!exists) {
            String msg = String.format("Alias  %s does not exist", an);
            throw new IllegalArgumentException(msg);
        }
        String real = pa.getPasswordForAlias(an);
        return real;
    }
}

