/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.NanoDuration;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigurationCleanup;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.ConfigurationAccess;
import org.glassfish.config.support.DasReaderFilter;
import org.glassfish.config.support.InstanceReaderFilter;
import org.glassfish.config.support.ServerReaderFilter;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public abstract class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    protected Habitat habitat;
    @Inject
    ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ConfigurationAccess configAccess;
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXml.class);
    private static final LocalStringsImpl strings = new LocalStringsImpl(DomainXml.class);

    public void run(ConfigParser parser) throws BootException {
        LogRecord lr = new LogRecord(Level.FINE, "Startup class : " + this.getClass().getName());
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
        this.habitat.addComponent("parent-class-loader", new ExistingSingletonInhabitant<ClassLoader>(ClassLoader.class, this.registry.getParentClassLoader()));
        try {
            this.parseDomainXml(parser, this.getDomainXml(this.env), this.env.getInstanceName());
        }
        catch (IOException e) {
            throw new BootException(localStrings.getLocalString("ConfigParsingFailed", "Failed to parse domain.xml"), e);
        }
        if ("upgrade".equals(this.context.getPlatformMainServiceName())) {
            this.upgrade();
        }
        for (Inhabitant<ConfigurationCleanup> cc : this.habitat.getInhabitants(ConfigurationCleanup.class)) {
            try {
                cc.get();
                lr = new LogRecord(Level.FINE, "Successful cleaned domain.xml with " + cc.getClass());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            catch (Exception e) {
                lr = new LogRecord(Level.FINE, e.toString() + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
                lr = new LogRecord(Level.SEVERE, cc.getClass() + " cleaning domain.xml failed " + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
        this.decorate();
    }

    protected void decorate() {
        Server server = this.habitat.getComponent(Server.class, this.env.getInstanceName());
        this.habitat.addIndex(new ExistingSingletonInhabitant<Server>(server), Server.class.getName(), "default-instance-name");
        this.habitat.addIndex(new ExistingSingletonInhabitant<Config>(this.habitat.getComponent(Config.class, server.getConfigRef())), Config.class.getName(), "default-instance-name");
        Cluster c = server.getCluster();
        if (c != null) {
            this.habitat.addIndex(new ExistingSingletonInhabitant<Cluster>(c), Cluster.class.getName(), "default-instance-name");
        }
    }

    protected void upgrade() {
        for (Inhabitant<ConfigurationUpgrade> cu : this.habitat.getInhabitants(ConfigurationUpgrade.class)) {
            try {
                cu.get();
                LogRecord lr = new LogRecord(Level.FINE, "Successful Upgrade domain.xml with " + cu.getClass());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            catch (Exception e) {
                LogRecord lr = new LogRecord(Level.FINE, e.toString() + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
                lr = new LogRecord(Level.SEVERE, cu.getClass() + " upgrading domain.xml failed " + e);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        File domainXml = new File(env.getConfigDirPath(), "domain.xml");
        if (domainXml.exists() && domainXml.length() > 0L) {
            return domainXml.toURI().toURL();
        }
        LogRecord lr = new LogRecord(Level.SEVERE, localStrings.getLocalString("NoConfigFile", "{0} does not exist or is empty, will use backup", domainXml.getAbsolutePath()));
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
        domainXml = new File(env.getConfigDirPath(), "domain.xml.bak");
        if (domainXml.exists() && domainXml.length() > 0L) {
            return domainXml.toURI().toURL();
        }
        lr = new LogRecord(Level.SEVERE, localStrings.getLocalString("NoBackupFile", "{0} does not exist or is empty, cannot use backup", domainXml.getAbsolutePath()));
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
        throw new IOException(localStrings.getLocalString("NoUsableConfigFile", "No usable configuration file at {0}", env.getConfigDirPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        long startNano = System.nanoTime();
        try {
            ServerReaderFilter xsr = null;
            this.xif.setXMLResolver(new XMLResolver(){

                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    return new ByteArrayInputStream(new byte[0]);
                }
            });
            if (this.env.getRuntimeType() == RuntimeType.DAS || this.env.getRuntimeType() == RuntimeType.EMBEDDED) {
                xsr = new DasReaderFilter(domainXml, this.xif);
            } else if (this.env.getRuntimeType() == RuntimeType.INSTANCE) {
                xsr = new InstanceReaderFilter(this.env.getInstanceName(), domainXml, this.xif);
            } else {
                throw new RuntimeException("Internal Error: Unknown server type: " + (Object)((Object)this.env.getRuntimeType()));
            }
            Lock lock = null;
            try {
                try {
                    lock = this.configAccess.accessRead();
                }
                catch (Exception e) {
                    // empty catch block
                }
                parser.parse(xsr, this.getDomDocument());
                xsr.close();
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
            String errorMessage = xsr.configWasFound();
            if (errorMessage != null) {
                LogRecord lr = new LogRecord(Level.WARNING, errorMessage);
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Fatal Error.  Unable to parse " + domainXml, e);
        }
        LogRecord lr = new LogRecord(Level.FINE, strings.get("time", new NanoDuration(System.nanoTime() - startNano).toString()));
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
    }

    protected abstract DomDocument getDomDocument();
}

