/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.util;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.sun.enterprise.util.cluster.windows.process.WindowsRemoteAsadmin;
import java.util.HashMap;
import org.glassfish.cluster.ssh.util.DcomUtils;
import org.glassfish.cluster.ssh.util.Strings;

public final class DcomInfo {
    private final WindowsCredentials credentials;
    private final Node node;
    private final String password;
    private final String host;
    private final String user;
    private final String windowsDomain;
    private final String remoteNodeRootDirectory;
    private final String remoteInstallRoot;
    private final String asadminPath;
    private final String asadminParentPath;

    public DcomInfo(Node theNode) throws WindowsException {
        TokenResolver resolver = new TokenResolver(new HashMap<Object, Object>(System.getProperties()));
        this.node = theNode;
        if (this.node == null) {
            throw new WindowsException(Strings.get("internal.error", "Node is null"));
        }
        if (!DcomInfo.isDcomNode(this.node)) {
            throw new WindowsException(Strings.get("not.dcom.node", this.getNode().getName(), this.getNode().getType()));
        }
        SshConnector conn = this.node.getSshConnector();
        if (conn == null) {
            throw new WindowsException(Strings.get("no.password"));
        }
        SshAuth auth = conn.getSshAuth();
        if (auth == null) {
            throw new WindowsException(Strings.get("no.password"));
        }
        String notFinal = auth.getPassword();
        if (!StringUtils.ok(notFinal)) {
            throw new WindowsException(Strings.get("no.password"));
        }
        this.password = DcomUtils.resolvePassword(notFinal);
        notFinal = this.node.getNodeHost();
        if (!StringUtils.ok(notFinal)) {
            notFinal = conn.getSshHost();
        }
        if (!StringUtils.ok(notFinal)) {
            throw new WindowsException(Strings.get("no.host"));
        }
        this.host = resolver.resolve(notFinal);
        notFinal = auth.getUserName();
        if (!StringUtils.ok(notFinal)) {
            notFinal = System.getProperty("user.name");
        }
        if (!StringUtils.ok(notFinal)) {
            throw new WindowsException(Strings.get("no.username"));
        }
        this.user = resolver.resolve(notFinal);
        notFinal = this.node.getWindowsDomain();
        if (!StringUtils.ok(notFinal)) {
            notFinal = this.host;
        }
        this.windowsDomain = resolver.resolve(notFinal);
        notFinal = this.node.getInstallDirUnixStyle();
        if (!StringUtils.ok(notFinal)) {
            throw new WindowsException(Strings.get("no.lib.dir"));
        }
        if (!notFinal.endsWith("/")) {
            notFinal = notFinal + "/";
        }
        notFinal = notFinal + SystemPropertyConstants.getComponentName();
        this.remoteInstallRoot = StringUtils.quotePathIfNecessary(notFinal);
        notFinal = notFinal + "/bin";
        notFinal = StringUtils.quotePathIfNecessary(notFinal);
        this.asadminParentPath = notFinal = notFinal.replace('/', '\\');
        this.asadminPath = notFinal + "\\asadmin.bat";
        String notFinal2 = this.node.getNodeDirAbsolute();
        if (notFinal2 == null) {
            notFinal2 = this.remoteInstallRoot;
            notFinal2 = notFinal2 + "/nodes";
        }
        if (!(notFinal2 = notFinal2.replace('/', '\\')).endsWith("\\")) {
            notFinal2 = notFinal2 + '\\';
        }
        this.remoteNodeRootDirectory = notFinal2 + this.node.getName();
        this.credentials = new WindowsCredentials(this.getHost(), this.getWindowsDomain(), this.getUser(), this.getPassword());
    }

    public String getRemoteNodeRootDirectory() {
        return this.remoteNodeRootDirectory;
    }

    public String getRemoteInstallRoot() {
        return this.remoteInstallRoot;
    }

    public String getNadminPath() {
        return this.asadminPath;
    }

    public String getAsadminParentPath() {
        return this.asadminParentPath;
    }

    public WindowsCredentials getCredentials() {
        return this.credentials;
    }

    public Node getNode() {
        return this.node;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getWindowsDomain() {
        return this.windowsDomain;
    }

    public WindowsRemoteAsadmin getAsadmin() {
        return new WindowsRemoteAsadmin(this.remoteInstallRoot, this.credentials);
    }

    private static boolean isDcomNode(Node node) {
        return "DCOM".equals(node.getType());
    }
}

