/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service(name="__supports-user-management")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.CLUSTERED_INSTANCE})
public class SupportsUserManagementCommand
implements AdminCommand {
    @Inject
    Domain domain;
    @Param
    String realmName;
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    RealmsManager realmsManager;
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(SupportsUserManagementCommand.class);

    public void execute(AdminCommandContext context) {
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        try {
            report.setMessage("" + this.supportsUserManagement(this.realmName));
        }
        catch (BadRealmException ex) {
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (NoSuchRealmException ex) {
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (Exception ex) {
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private boolean supportsUserManagement(String realmName) throws BadRealmException, NoSuchRealmException {
        Realm r = this.realmsManager.getFromLoadedRealms(this.config.getName(), realmName);
        if (r != null) {
            return r.supportsUserManagement();
        }
        List<AuthRealm> authRealmConfigs = this.config.getSecurityService().getAuthRealm();
        for (AuthRealm authRealm : authRealmConfigs) {
            if (!realmName.equals(authRealm.getName())) continue;
            List<Property> propConfigs = authRealm.getProperty();
            Properties props = new Properties();
            for (Property p : propConfigs) {
                String value = p.getValue();
                props.setProperty(p.getName(), value);
            }
            r = Realm.instantiate(authRealm.getName(), authRealm.getClassname(), props, this.config.getName());
            return r.supportsUserManagement();
        }
        throw new NoSuchRealmException(_localStrings.getLocalString("NO_SUCH_REALM", "No Such Realm: {0}", realmName));
    }
}

