/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import com.sun.logging.LogDomains;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

@Service
public class DigesterFactory {
    @Inject(optional=true, name="web")
    EntityResolver entityResolver;
    protected static final Logger _logger = LogDomains.getLogger(DigesterFactory.class, "javax.enterprise.system.container.web");

    public Digester newDigester() {
        return this.newDigester(false, false, null);
    }

    public Digester newDigester(RuleSet rule) {
        return this.newDigester(false, false, rule);
    }

    public Digester newDigester(boolean xmlValidation, boolean xmlNamespaceAware, RuleSet rule) {
        Digester digester = new Digester();
        digester.setNamespaceAware(xmlNamespaceAware);
        digester.setValidating(xmlValidation);
        digester.setUseContextClassLoader(true);
        String parserName = digester.getFactory().getClass().getName();
        if (parserName.indexOf("xerces") != -1) {
            digester = this.patchXerces(digester);
        }
        if (xmlValidation) {
            if (parserName.indexOf("xerces") != -1) {
                this.turnOnXercesValidation(digester);
            } else {
                this.turnOnValidation(digester);
            }
        }
        digester.setEntityResolver(this.entityResolver);
        if (rule != null) {
            digester.addRuleSet(rule);
        }
        return digester;
    }

    private Digester patchXerces(Digester digester) {
        try {
            digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        return digester;
    }

    protected void turnOnValidation(Digester digester) {
        URL url = this.getClass().getResource("/javax/servlet/resources/web-app_2_4.xsd");
        digester.setSchema(url.toString());
    }

    protected void turnOnXercesValidation(Digester digester) {
        try {
            digester.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            digester.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }
}

